/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserOutput;
import org.jreleaser.model.internal.announce.Announcer;
import org.jreleaser.model.internal.announce.ArticleAnnouncer;
import org.jreleaser.model.internal.announce.DiscordAnnouncer;
import org.jreleaser.model.internal.announce.DiscourseAnnouncer;
import org.jreleaser.model.internal.announce.DiscussionsAnnouncer;
import org.jreleaser.model.internal.announce.GitterAnnouncer;
import org.jreleaser.model.internal.announce.GoogleChatAnnouncer;
import org.jreleaser.model.internal.announce.HttpAnnouncer;
import org.jreleaser.model.internal.announce.HttpAnnouncers;
import org.jreleaser.model.internal.announce.MastodonAnnouncer;
import org.jreleaser.model.internal.announce.MattermostAnnouncer;
import org.jreleaser.model.internal.announce.SdkmanAnnouncer;
import org.jreleaser.model.internal.announce.SlackAnnouncer;
import org.jreleaser.model.internal.announce.SmtpAnnouncer;
import org.jreleaser.model.internal.announce.TeamsAnnouncer;
import org.jreleaser.model.internal.announce.TelegramAnnouncer;
import org.jreleaser.model.internal.announce.TwitterAnnouncer;
import org.jreleaser.model.internal.announce.WebhookAnnouncer;
import org.jreleaser.model.internal.announce.WebhooksAnnouncer;
import org.jreleaser.model.internal.announce.ZulipAnnouncer;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class Announce
extends AbstractModelObject<Announce>
implements Domain,
Activatable {
    private final ArticleAnnouncer article = new ArticleAnnouncer();
    private final DiscordAnnouncer discord = new DiscordAnnouncer();
    private final DiscourseAnnouncer discourse = new DiscourseAnnouncer();
    private final DiscussionsAnnouncer discussions = new DiscussionsAnnouncer();
    private final GitterAnnouncer gitter = new GitterAnnouncer();
    private final GoogleChatAnnouncer googleChat = new GoogleChatAnnouncer();
    private final HttpAnnouncers http = new HttpAnnouncers();
    private final SmtpAnnouncer mail = new SmtpAnnouncer();
    private final MastodonAnnouncer mastodon = new MastodonAnnouncer();
    private final MattermostAnnouncer mattermost = new MattermostAnnouncer();
    private final SdkmanAnnouncer sdkman = new SdkmanAnnouncer();
    private final SlackAnnouncer slack = new SlackAnnouncer();
    private final TeamsAnnouncer teams = new TeamsAnnouncer();
    private final TelegramAnnouncer telegram = new TelegramAnnouncer();
    private final TwitterAnnouncer twitter = new TwitterAnnouncer();
    private final WebhooksAnnouncer webhooks = new WebhooksAnnouncer();
    private final ZulipAnnouncer zulip = new ZulipAnnouncer();
    private Active active;
    @JsonIgnore
    private boolean enabled = true;
    private final org.jreleaser.model.api.announce.Announce immutable = new org.jreleaser.model.api.announce.Announce(){

        public org.jreleaser.model.api.announce.ArticleAnnouncer getArticle() {
            return Announce.this.article.asImmutable();
        }

        public org.jreleaser.model.api.announce.DiscordAnnouncer getDiscord() {
            return Announce.this.discord.asImmutable();
        }

        public org.jreleaser.model.api.announce.DiscourseAnnouncer getDiscourse() {
            return Announce.this.discourse.asImmutable();
        }

        public org.jreleaser.model.api.announce.DiscussionsAnnouncer getDiscussions() {
            return Announce.this.discussions.asImmutable();
        }

        public org.jreleaser.model.api.announce.GitterAnnouncer getGitter() {
            return Announce.this.gitter.asImmutable();
        }

        public org.jreleaser.model.api.announce.GoogleChatAnnouncer getGoogleChat() {
            return Announce.this.googleChat.asImmutable();
        }

        public org.jreleaser.model.api.announce.SmtpAnnouncer getMail() {
            return Announce.this.mail.asImmutable();
        }

        public org.jreleaser.model.api.announce.MastodonAnnouncer getMastodon() {
            return Announce.this.mastodon.asImmutable();
        }

        public org.jreleaser.model.api.announce.MattermostAnnouncer getMattermost() {
            return Announce.this.mattermost.asImmutable();
        }

        public org.jreleaser.model.api.announce.SdkmanAnnouncer getSdkman() {
            return Announce.this.sdkman.asImmutable();
        }

        public org.jreleaser.model.api.announce.SlackAnnouncer getSlack() {
            return Announce.this.slack.asImmutable();
        }

        public org.jreleaser.model.api.announce.TeamsAnnouncer getTeams() {
            return Announce.this.teams.asImmutable();
        }

        public org.jreleaser.model.api.announce.TelegramAnnouncer getTelegram() {
            return Announce.this.telegram.asImmutable();
        }

        public org.jreleaser.model.api.announce.TwitterAnnouncer getTwitter() {
            return Announce.this.twitter.asImmutable();
        }

        public Map<String, ? extends org.jreleaser.model.api.announce.HttpAnnouncer> getHttp() {
            return Announce.this.http.asImmutable().getHttpAnnouncers();
        }

        public Map<String, ? extends org.jreleaser.model.api.announce.WebhookAnnouncer> getWebhooks() {
            return Announce.this.webhooks.asImmutable().getWebhooks();
        }

        public org.jreleaser.model.api.announce.ZulipAnnouncer getZulip() {
            return Announce.this.zulip.asImmutable();
        }

        public Active getActive() {
            return Announce.this.active;
        }

        public boolean isEnabled() {
            return Announce.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Announce.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.announce.Announce asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Announce source) {
        this.active = this.merge(this.active, source.active);
        this.enabled = this.merge(this.enabled, source.enabled);
        this.setArticle(source.article);
        this.setDiscord(source.discord);
        this.setDiscourse(source.discourse);
        this.setDiscussions(source.discussions);
        this.setGitter(source.gitter);
        this.setGoogleChat(source.googleChat);
        this.setConfiguredHttp(source.http);
        this.setMail(source.mail);
        this.setMastodon(source.mastodon);
        this.setMattermost(source.mattermost);
        this.setSdkman(source.sdkman);
        this.setSlack(source.slack);
        this.setTeams(source.teams);
        this.setTelegram(source.telegram);
        this.setTwitter(source.twitter);
        this.setZulip(source.zulip);
        this.setConfiguredWebhooks(source.webhooks);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.active != null;
    }

    @Deprecated
    public void setEnabled(Boolean enabled) {
        JReleaserOutput.nag((String)"announce.enabled is deprecated since 1.1.0 and will be removed in 2.0.0");
        if (null != enabled) {
            this.active = enabled != false ? Active.ALWAYS : Active.NEVER;
        }
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"announce.active", (String)"", (String)"ALWAYS"));
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public ArticleAnnouncer getArticle() {
        return this.article;
    }

    public void setArticle(ArticleAnnouncer article) {
        this.article.merge(article);
    }

    public DiscordAnnouncer getDiscord() {
        return this.discord;
    }

    public void setDiscord(DiscordAnnouncer discord) {
        this.discord.merge(discord);
    }

    public DiscourseAnnouncer getDiscourse() {
        return this.discourse;
    }

    public void setDiscourse(DiscourseAnnouncer discourse) {
        this.discourse.merge(discourse);
    }

    public DiscussionsAnnouncer getDiscussions() {
        return this.discussions;
    }

    public void setDiscussions(DiscussionsAnnouncer discussions) {
        this.discussions.merge(discussions);
    }

    public GitterAnnouncer getGitter() {
        return this.gitter;
    }

    public void setGitter(GitterAnnouncer gitter) {
        this.gitter.merge(gitter);
    }

    public GoogleChatAnnouncer getGoogleChat() {
        return this.googleChat;
    }

    public void setGoogleChat(GoogleChatAnnouncer googleChat) {
        this.googleChat.merge(googleChat);
    }

    public SmtpAnnouncer getMail() {
        return this.mail;
    }

    public void setMail(SmtpAnnouncer mail) {
        this.mail.merge(mail);
    }

    public MastodonAnnouncer getMastodon() {
        return this.mastodon;
    }

    public void setMastodon(MastodonAnnouncer mastodon) {
        this.mastodon.merge(mastodon);
    }

    public MattermostAnnouncer getMattermost() {
        return this.mattermost;
    }

    public void setMattermost(MattermostAnnouncer mattermost) {
        this.mattermost.merge(mattermost);
    }

    public SdkmanAnnouncer getSdkman() {
        return this.sdkman;
    }

    public void setSdkman(SdkmanAnnouncer sdkman) {
        this.sdkman.merge(sdkman);
    }

    public SlackAnnouncer getSlack() {
        return this.slack;
    }

    public void setSlack(SlackAnnouncer slack) {
        this.slack.merge(slack);
    }

    public TeamsAnnouncer getTeams() {
        return this.teams;
    }

    public void setTeams(TeamsAnnouncer teams) {
        this.teams.merge(teams);
    }

    public TelegramAnnouncer getTelegram() {
        return this.telegram;
    }

    public void setTelegram(TelegramAnnouncer telegram) {
        this.telegram.merge(telegram);
    }

    public TwitterAnnouncer getTwitter() {
        return this.twitter;
    }

    public void setTwitter(TwitterAnnouncer twitter) {
        this.twitter.merge(twitter);
    }

    public HttpAnnouncers getConfiguredHttp() {
        return this.http;
    }

    void setConfiguredHttp(HttpAnnouncers https) {
        this.http.merge(https);
    }

    public Map<String, HttpAnnouncer> getHttp() {
        return this.http.getHttpAnnouncers();
    }

    public void setHttp(Map<String, HttpAnnouncer> https) {
        this.http.setHttpAnnouncers(https);
    }

    public void addHttpAnnouncer(HttpAnnouncer http) {
        this.http.addHttpAnnouncer(http);
    }

    public WebhooksAnnouncer getConfiguredWebhooks() {
        return this.webhooks;
    }

    void setConfiguredWebhooks(WebhooksAnnouncer webhooks) {
        this.webhooks.merge(webhooks);
    }

    public Map<String, WebhookAnnouncer> getWebhooks() {
        return this.webhooks.getWebhooks();
    }

    public void setWebhooks(Map<String, WebhookAnnouncer> webhooks) {
        this.webhooks.setWebhooks(webhooks);
    }

    public void addWebhook(WebhookAnnouncer webhook) {
        this.webhooks.addWebhook(webhook);
    }

    public ZulipAnnouncer getZulip() {
        return this.zulip;
    }

    public void setZulip(ZulipAnnouncer zulip) {
        this.zulip.merge(zulip);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.active);
        map.putAll(this.article.asMap(full));
        map.putAll(this.discord.asMap(full));
        map.putAll(this.discourse.asMap(full));
        map.putAll(this.discussions.asMap(full));
        map.putAll(this.gitter.asMap(full));
        map.putAll(this.googleChat.asMap(full));
        map.putAll(this.http.asMap(full));
        map.putAll(this.mail.asMap(full));
        map.putAll(this.mastodon.asMap(full));
        map.putAll(this.mattermost.asMap(full));
        map.putAll(this.sdkman.asMap(full));
        map.putAll(this.slack.asMap(full));
        map.putAll(this.teams.asMap(full));
        map.putAll(this.telegram.asMap(full));
        map.putAll(this.twitter.asMap(full));
        map.putAll(this.webhooks.asMap(full));
        map.putAll(this.zulip.asMap(full));
        return map;
    }

    public <A extends Announcer> A findAnnouncer(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException("Announcer name must not be blank");
        }
        return this.resolveAnnouncer(name);
    }

    public <A extends Announcer> A getAnnouncer(String name) {
        A announcer = this.findAnnouncer(name);
        if (null != announcer) {
            return announcer;
        }
        throw new JReleaserException(RB.$((String)"ERROR_announcer_not_configured", (Object[])new Object[]{name}));
    }

    private <A extends Announcer> A resolveAnnouncer(String name) {
        switch (name.toLowerCase(Locale.ENGLISH).trim()) {
            case "article": {
                return (A)this.getArticle();
            }
            case "discord": {
                return (A)this.getDiscord();
            }
            case "discourse": {
                return (A)this.getDiscourse();
            }
            case "discussions": {
                return (A)this.getDiscussions();
            }
            case "gitter": {
                return (A)this.getGitter();
            }
            case "googlechat": {
                return (A)this.getGoogleChat();
            }
            case "http": {
                return (A)this.getConfiguredHttp();
            }
            case "mail": {
                return (A)this.getMail();
            }
            case "mastodon": {
                return (A)this.getMastodon();
            }
            case "mattermost": {
                return (A)this.getMattermost();
            }
            case "sdkman": {
                return (A)this.getSdkman();
            }
            case "slack": {
                return (A)this.getSlack();
            }
            case "teams": {
                return (A)this.getTeams();
            }
            case "telegram": {
                return (A)this.getTelegram();
            }
            case "twitter": {
                return (A)this.getTwitter();
            }
            case "webhooks": {
                return (A)this.getConfiguredWebhooks();
            }
            case "zulip": {
                return (A)this.getZulip();
            }
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_announcer", (Object[])new Object[]{name}));
    }
}

