/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Mattermost;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class MattermostValidator
extends Validator {
    private static final String DEFAULT_MATTERMOST_TPL = "src/jreleaser/templates/mattermost.tpl";

    public static void validateMattermost(JReleaserContext context, Mattermost mattermost, Errors errors) {
        context.getLogger().debug("announce.mattermost");
        if (!mattermost.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        mattermost.setWebhook(MattermostValidator.checkProperty(context, "MATTERMOST_WEBHOOK", "mattermost.webhook", mattermost.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)mattermost.getMessage()) && StringUtils.isBlank((String)mattermost.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_MATTERMOST_TPL), new LinkOption[0])) {
                mattermost.setMessageTemplate(DEFAULT_MATTERMOST_TPL);
            } else {
                mattermost.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)mattermost.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(mattermost.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"mattermost.messageTemplate", mattermost.getMessageTemplate()}));
        }
        MattermostValidator.validateTimeout(mattermost);
    }
}

