/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.AppImage;
import org.jreleaser.model.Asdf;
import org.jreleaser.model.Brew;
import org.jreleaser.model.Chocolatey;
import org.jreleaser.model.Docker;
import org.jreleaser.model.Domain;
import org.jreleaser.model.Flatpak;
import org.jreleaser.model.Gofish;
import org.jreleaser.model.Jbang;
import org.jreleaser.model.Macports;
import org.jreleaser.model.Scoop;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.Snap;
import org.jreleaser.model.Spec;

public class Packagers<S extends Packagers<S>>
extends AbstractModelObject<S>
implements Domain {
    protected final AppImage appImage = new AppImage();
    protected final Asdf asdf = new Asdf();
    protected final Brew brew = new Brew();
    protected final Chocolatey chocolatey = new Chocolatey();
    protected final Docker docker = new Docker();
    protected final Flatpak flatpak = new Flatpak();
    protected final Gofish gofish = new Gofish();
    protected final Jbang jbang = new Jbang();
    protected final Macports macports = new Macports();
    protected final Scoop scoop = new Scoop();
    protected final Sdkman sdkman = new Sdkman();
    protected final Snap snap = new Snap();
    protected final Spec spec = new Spec();

    public boolean hasEnabledPackagers() {
        return this.appImage.isEnabled() || this.asdf.isEnabled() || this.brew.isEnabled() || this.chocolatey.isEnabled() || this.docker.isEnabled() || this.flatpak.isEnabled() || this.gofish.isEnabled() || this.jbang.isEnabled() || this.macports.isEnabled() || this.scoop.isEnabled() || this.sdkman.isEnabled() || this.snap.isEnabled() || this.spec.isEnabled();
    }

    @Override
    public void freeze() {
        super.freeze();
        this.appImage.freeze();
        this.asdf.freeze();
        this.brew.freeze();
        this.chocolatey.freeze();
        this.docker.freeze();
        this.flatpak.freeze();
        this.gofish.freeze();
        this.jbang.freeze();
        this.macports.freeze();
        this.scoop.freeze();
        this.sdkman.freeze();
        this.snap.freeze();
        this.spec.freeze();
    }

    @Override
    public void merge(S packagers) {
        this.freezeCheck();
        this.setAppImage(((Packagers)packagers).appImage);
        this.setAsdf(((Packagers)packagers).asdf);
        this.setBrew(((Packagers)packagers).brew);
        this.setChocolatey(((Packagers)packagers).chocolatey);
        this.setDocker(((Packagers)packagers).docker);
        this.setFlatpak(((Packagers)packagers).flatpak);
        this.setGofish(((Packagers)packagers).gofish);
        this.setJbang(((Packagers)packagers).jbang);
        this.setMacports(((Packagers)packagers).macports);
        this.setScoop(((Packagers)packagers).scoop);
        this.setSdkman(((Packagers)packagers).sdkman);
        this.setSnap(((Packagers)packagers).snap);
        this.setSpec(((Packagers)packagers).spec);
    }

    public AppImage getAppImage() {
        return this.appImage;
    }

    public void setAppImage(AppImage appimage) {
        this.appImage.merge(appimage);
    }

    public Asdf getAsdf() {
        return this.asdf;
    }

    public void setAsdf(Asdf asdf) {
        this.asdf.merge(asdf);
    }

    public Brew getBrew() {
        return this.brew;
    }

    public void setBrew(Brew brew) {
        this.brew.merge(brew);
    }

    public Chocolatey getChocolatey() {
        return this.chocolatey;
    }

    public void setChocolatey(Chocolatey chocolatey) {
        this.chocolatey.merge(chocolatey);
    }

    public Docker getDocker() {
        return this.docker;
    }

    public void setDocker(Docker docker) {
        this.docker.merge(docker);
    }

    public Gofish getGofish() {
        return this.gofish;
    }

    public void setGofish(Gofish gofish) {
        this.gofish.merge(gofish);
    }

    public Flatpak getFlatpak() {
        return this.flatpak;
    }

    public void setFlatpak(Flatpak flatpak) {
        this.flatpak.merge(flatpak);
    }

    public Jbang getJbang() {
        return this.jbang;
    }

    public void setJbang(Jbang jbang) {
        this.jbang.merge(jbang);
    }

    public Macports getMacports() {
        return this.macports;
    }

    public void setMacports(Macports macports) {
        this.macports.merge(macports);
    }

    public Scoop getScoop() {
        return this.scoop;
    }

    public void setScoop(Scoop scoop) {
        this.scoop.merge(scoop);
    }

    public Sdkman getSdkman() {
        return this.sdkman;
    }

    public void setSdkman(Sdkman sdkman) {
        this.sdkman.merge(sdkman);
    }

    public Snap getSnap() {
        return this.snap;
    }

    public void setSnap(Snap snap) {
        this.snap.merge(snap);
    }

    public Spec getSpec() {
        return this.spec;
    }

    public void setSpec(Spec spec) {
        this.spec.merge(spec);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.putAll(this.appImage.asMap(full));
        map.putAll(this.asdf.asMap(full));
        map.putAll(this.brew.asMap(full));
        map.putAll(this.chocolatey.asMap(full));
        map.putAll(this.docker.asMap(full));
        map.putAll(this.flatpak.asMap(full));
        map.putAll(this.gofish.asMap(full));
        map.putAll(this.jbang.asMap(full));
        map.putAll(this.macports.asMap(full));
        map.putAll(this.scoop.asMap(full));
        map.putAll(this.sdkman.asMap(full));
        map.putAll(this.snap.asMap(full));
        map.putAll(this.spec.asMap(full));
        return map;
    }
}

