/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Domain;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Glob
extends AbstractModelObject<Glob>
implements Domain,
ExtraProperties {
    private static final String GLOB_PREFIX = "glob:";
    private static final String REGEX_PREFIX = "regex:";
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private String pattern;
    private String platform;
    @JsonIgnore
    private Set<Artifact> artifacts;
    private String directory;

    @Override
    public void merge(Glob glob) {
        this.freezeCheck();
        this.pattern = this.merge(this.pattern, glob.pattern);
        this.platform = this.merge(this.platform, glob.platform);
        this.setExtraProperties(this.merge(this.extraProperties, glob.extraProperties));
    }

    @Override
    public String getPrefix() {
        return "artifact";
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.freezeWrap(this.extraProperties);
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.putAll(extraProperties);
    }

    public Set<Artifact> getResolvedArtifacts(JReleaserContext context) {
        return this.getResolvedArtifactsPattern(context);
    }

    public Set<Artifact> getResolvedArtifactsPattern(JReleaserContext context) {
        if (null == this.artifacts) {
            this.mutate(() -> this.setPattern(Artifacts.resolveForGlob(this.getPattern(), context, this)));
            this.normalizePattern(this.resolveDirectory(context));
            this.artifacts = Artifacts.resolveFiles(context, this.resolveDirectory(context), Collections.singletonList(this.pattern));
            this.artifacts.forEach(artifact -> {
                artifact.setPlatform(this.platform);
                if (context.isPlatformSelected((Artifact)artifact)) {
                    artifact.activate();
                }
                artifact.setExtraProperties(this.getExtraProperties());
            });
        }
        return this.artifacts;
    }

    private Path resolveDirectory(JReleaserContext context) {
        Path path = context.getBasedir();
        if (StringUtils.isNotBlank((String)this.directory)) {
            this.directory = Artifacts.resolveForGlob(this.directory, context, this);
            path = context.getBasedir().resolve(Paths.get(this.directory, new String[0])).normalize();
            if (context.getMode().validatePaths() && !Files.exists(path, new LinkOption[0])) {
                throw new JReleaserException(RB.$((String)"ERROR_path_does_not_exist", (Object[])new Object[]{context.relativizeToBasedir(path)}));
            }
        }
        return path;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.freezeCheck();
        if (StringUtils.isBlank((String)pattern)) {
            return;
        }
        this.pattern = pattern.trim();
    }

    private void normalizePattern(Path basedir) {
        if (!this.pattern.startsWith(GLOB_PREFIX) && !this.pattern.startsWith(REGEX_PREFIX)) {
            this.pattern = GLOB_PREFIX + this.pattern;
        }
        if (this.pattern.startsWith(GLOB_PREFIX)) {
            String path;
            String test = path = this.pattern.substring(GLOB_PREFIX.length());
            if (PlatformUtils.isWindows()) {
                test = test.replace("*", "x");
            }
            this.pattern = !Paths.get(test, new String[0]).isAbsolute() ? "glob:**" + File.separator + path : "glob:**" + this.relativize(basedir, Paths.get(path, new String[0]));
        } else {
            String path;
            String test = path = this.pattern.substring(REGEX_PREFIX.length());
            if (PlatformUtils.isWindows()) {
                test = test.replace("*", "x");
            }
            this.pattern = !Paths.get(test, new String[0]).isAbsolute() ? "regex:.*" + File.separator + path : "regex:.*" + this.relativize(basedir, Paths.get(path, new String[0]));
        }
        if (PlatformUtils.isWindows()) {
            this.pattern = this.pattern.replace("/", "\\\\");
        }
    }

    public Path relativize(Path base, Path other) {
        Path p;
        Path p1 = base.toAbsolutePath();
        Path p2 = other.toAbsolutePath();
        for (p = p1.relativize(p2).normalize(); p != null && !p.endsWith(".."); p = p.getParent()) {
        }
        return base.resolve(p).resolve(p2).normalize();
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.freezeCheck();
        this.platform = platform;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.freezeCheck();
        this.directory = directory;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("pattern", this.pattern);
        props.put("platform", this.platform);
        props.put("extraProperties", this.getResolvedExtraProperties());
        props.put("directory", this.directory);
        return props;
    }
}

