/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Domain;
import org.jreleaser.model.EnabledAware;
import org.jreleaser.model.GitService;

public class Github
extends GitService<Github> {
    public static final String NAME = "github";
    private final ReleaseNotes releaseNotes = new ReleaseNotes();
    private Boolean draft;
    private String discussionCategoryName;

    public Github() {
        super(NAME, true);
        this.setHost("github.com");
        this.setApiEndpoint("https://api.github.com");
        this.setRepoUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}");
        this.setRepoCloneUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}.git");
        this.setCommitUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/commits");
        this.setSrcUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/blob/{{repoBranch}}");
        this.setDownloadUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/download/{{tagName}}/{{artifactFile}}");
        this.setReleaseNotesUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/tag/{{tagName}}");
        this.setLatestReleaseUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/latest");
        this.setIssueTrackerUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/issues");
    }

    @Override
    public void freeze() {
        super.freeze();
        this.releaseNotes.freeze();
    }

    @Override
    public void merge(Github service) {
        this.freezeCheck();
        super.merge(service);
        this.draft = this.merge(this.draft, service.draft);
        this.discussionCategoryName = this.merge(this.discussionCategoryName, service.discussionCategoryName);
        this.setReleaseNotes(service.releaseNotes);
    }

    public boolean isDraft() {
        return this.draft != null && this.draft != false;
    }

    public void setDraft(Boolean draft) {
        this.freezeCheck();
        this.draft = draft;
    }

    public boolean isDraftSet() {
        return this.draft != null;
    }

    public String getDiscussionCategoryName() {
        return this.discussionCategoryName;
    }

    public void setDiscussionCategoryName(String discussionCategoryName) {
        this.freezeCheck();
        this.discussionCategoryName = discussionCategoryName;
    }

    public ReleaseNotes getReleaseNotes() {
        return this.releaseNotes;
    }

    public void setReleaseNotes(ReleaseNotes releaseNotes) {
        this.releaseNotes.merge(releaseNotes);
    }

    @Override
    public String getReverseRepoHost() {
        return "com.github";
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> map = super.asMap(full);
        map.put("draft", this.isDraft());
        map.put("discussionCategoryName", this.discussionCategoryName);
        map.put("releaseNotes", this.releaseNotes.asMap(full));
        return map;
    }

    public static class ReleaseNotes
    extends AbstractModelObject<ReleaseNotes>
    implements Domain,
    EnabledAware {
        private Boolean enabled;
        private String configurationFile;

        @Override
        public void merge(ReleaseNotes source) {
            this.freezeCheck();
            this.enabled = this.merge(this.enabled, source.enabled);
            this.configurationFile = this.merge(this.configurationFile, source.configurationFile);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.freezeCheck();
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public String getConfigurationFile() {
            return this.configurationFile;
        }

        public void setConfigurationFile(String configurationFile) {
            this.freezeCheck();
            this.configurationFile = configurationFile;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("configurationFile", this.configurationFile);
            return map;
        }
    }
}

