/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractUploader;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class GiteaUploader
extends AbstractUploader<GiteaUploader> {
    public static final String TYPE = "gitea";
    private static final String DOWNLOAD_URL = "https://{{host}}/api/packages/{{owner}}/generic/{{packageName}}/{{packageVersion}}/{{artifactFile}}";
    private String host;
    private String owner;
    private String token;
    private String packageName;
    private String packageVersion;

    public GiteaUploader() {
        super(TYPE);
    }

    @Override
    public void merge(GiteaUploader gitlab) {
        this.freezeCheck();
        super.merge(gitlab);
        this.host = this.merge(this.host, gitlab.host);
        this.owner = this.merge(this.owner, gitlab.owner);
        this.token = this.merge(this.token, gitlab.token);
        this.packageName = this.merge(this.packageName, gitlab.packageName);
        this.packageVersion = this.merge(this.packageVersion, gitlab.packageVersion);
    }

    public String getResolvedToken() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{"GITLAB_" + Env.toVar((String)this.name) + "_TOKEN", "GITLAB_TOKEN"}), (String)this.token);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.freezeCheck();
        this.host = host;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.freezeCheck();
        this.token = token;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.freezeCheck();
        this.packageName = packageName;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.freezeCheck();
        this.packageVersion = packageVersion;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("host", this.host);
        props.put("owner", this.owner);
        props.put("token", StringUtils.isNotBlank((String)this.getResolvedToken()) ? "************" : "**unset**");
        props.put("packageName", this.packageName);
        props.put("packageVersion", this.packageVersion);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps((Map)props, artifact));
        p.putAll(this.getResolvedExtraProperties());
        p.put("host", this.host);
        p.put("owner", this.owner);
        p.put("packageName", this.packageName);
        p.put("packageVersion", this.packageVersion);
        return Templates.resolveTemplate((String)DOWNLOAD_URL, p);
    }

    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context, artifact);
    }
}

