/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractAssembler;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.Domain;
import org.jreleaser.model.Jlink;
import org.jreleaser.model.Jpackage;
import org.jreleaser.model.NativeImage;
import org.jreleaser.model.Project;
import org.jreleaser.util.Env;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.JReleaserOutput;
import org.jreleaser.util.StringUtils;

public class Assemble
extends AbstractModelObject<Assemble>
implements Domain,
Activatable {
    private final Map<String, Archive> archive = new LinkedHashMap<String, Archive>();
    private final Map<String, Jlink> jlink = new LinkedHashMap<String, Jlink>();
    private final Map<String, Jpackage> jpackage = new LinkedHashMap<String, Jpackage>();
    private final Map<String, NativeImage> nativeImage = new LinkedHashMap<String, NativeImage>();
    private Active active;
    @JsonIgnore
    private boolean enabled = true;

    @Override
    public void freeze() {
        super.freeze();
        this.archive.values().forEach(AbstractAssembler::freeze);
        this.jlink.values().forEach(Jlink::freeze);
        this.jpackage.values().forEach(Jpackage::freeze);
        this.nativeImage.values().forEach(NativeImage::freeze);
    }

    @Override
    public void merge(Assemble assemble) {
        this.freezeCheck();
        this.active = this.merge(this.active, assemble.active);
        this.enabled = this.merge(this.enabled, assemble.enabled);
        this.setArchive(this.mergeModel(this.archive, assemble.archive));
        this.setJlink(this.mergeModel(this.jlink, assemble.jlink));
        this.setJpackage(this.mergeModel(this.jpackage, assemble.jpackage));
        this.setNativeImage(this.mergeModel(this.nativeImage, assemble.nativeImage));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Deprecated
    public void setEnabled(Boolean enabled) {
        JReleaserOutput.nag((String)"assemble.enabled is deprecated since 1.1.0 and will be removed in 2.0.0");
        this.freezeCheck();
        if (null != enabled) {
            this.active = enabled != false ? Active.ALWAYS : Active.NEVER;
        }
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"assemble.active", (String)"", (String)"ALWAYS"));
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public List<Archive> getActiveArchives() {
        return this.archive.values().stream().filter(AbstractAssembler::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Archive> getArchive() {
        return this.freezeWrap(this.archive);
    }

    public void setArchive(Map<String, Archive> archive) {
        this.freezeCheck();
        this.archive.clear();
        this.archive.putAll(archive);
    }

    public void addArchive(Archive archive) {
        this.freezeCheck();
        this.archive.put(archive.getName(), archive);
    }

    public List<Jlink> getActiveJlinks() {
        return this.jlink.values().stream().filter(AbstractAssembler::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Jlink> getJlink() {
        return this.freezeWrap(this.jlink);
    }

    public void setJlink(Map<String, Jlink> jlink) {
        this.freezeCheck();
        this.jlink.clear();
        this.jlink.putAll(jlink);
    }

    public void addJlink(Jlink jlink) {
        this.freezeCheck();
        this.jlink.put(jlink.getName(), jlink);
    }

    public Jlink findJlink(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException("Jlink name must not be blank");
        }
        if (this.jlink.containsKey(name)) {
            return this.jlink.get(name);
        }
        throw new JReleaserException("Jlink '" + name + "' not found");
    }

    public List<Jpackage> getActiveJpackages() {
        return this.jpackage.values().stream().filter(AbstractAssembler::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Jpackage> getJpackage() {
        return this.freezeWrap(this.jpackage);
    }

    public void setJpackage(Map<String, Jpackage> jpackage) {
        this.freezeCheck();
        this.jpackage.clear();
        this.jpackage.putAll(jpackage);
    }

    public void addJpackage(Jpackage jpackage) {
        this.freezeCheck();
        this.jpackage.put(jpackage.getName(), jpackage);
    }

    public List<NativeImage> getActiveNativeImages() {
        return this.nativeImage.values().stream().filter(AbstractAssembler::isEnabled).collect(Collectors.toList());
    }

    public Map<String, NativeImage> getNativeImage() {
        return this.freezeWrap(this.nativeImage);
    }

    public void setNativeImage(Map<String, NativeImage> nativeImage) {
        this.freezeCheck();
        this.nativeImage.clear();
        this.nativeImage.putAll(nativeImage);
    }

    public void addNativeImage(NativeImage nativeImage) {
        this.freezeCheck();
        this.nativeImage.put(nativeImage.getName(), nativeImage);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List nativeImage;
        List jpackage;
        List jlink;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", (Object)this.active);
        List archive = this.archive.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!archive.isEmpty()) {
            map.put("archive", archive);
        }
        if (!(jlink = this.jlink.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("jlink", jlink);
        }
        if (!(jpackage = this.jpackage.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("jpackage", jpackage);
        }
        if (!(nativeImage = this.nativeImage.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("nativeImage", nativeImage);
        }
        return map;
    }

    public <A extends Assembler> Map<String, A> findAssemblersByType(String assemblerName) {
        switch (assemblerName) {
            case "archive": {
                return this.archive;
            }
            case "jlink": {
                return this.jlink;
            }
            case "jpackage": {
                return this.jpackage;
            }
            case "native-image": {
                return this.nativeImage;
            }
        }
        return Collections.emptyMap();
    }

    public <A extends Assembler> Collection<A> findAllAssemblers() {
        ArrayList<AbstractAssembler> assemblers = new ArrayList<AbstractAssembler>();
        assemblers.addAll(this.getActiveArchives());
        assemblers.addAll(this.getActiveJlinks());
        assemblers.addAll(this.getActiveJpackages());
        assemblers.addAll(this.getActiveNativeImages());
        return assemblers;
    }

    public static Set<String> supportedAssemblers() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("archive");
        set.add("jlink");
        set.add("jpackage");
        set.add("native-image");
        return Collections.unmodifiableSet(set);
    }
}

