/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.DockerConfiguration;
import org.jreleaser.model.Project;
import org.jreleaser.model.Registry;
import org.jreleaser.util.StringUtils;

public abstract class AbstractDockerConfiguration<S extends AbstractDockerConfiguration<S>>
extends AbstractModelObject<S>
implements DockerConfiguration {
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    protected final Map<String, String> labels = new LinkedHashMap<String, String>();
    protected final Set<String> imageNames = new LinkedHashSet<String>();
    protected final List<String> buildArgs = new ArrayList<String>();
    protected final List<String> preCommands = new ArrayList<String>();
    protected final List<String> postCommands = new ArrayList<String>();
    protected final Set<Registry> registries = new LinkedHashSet<Registry>();
    protected final List<String> skipTemplates = new ArrayList<String>();
    @JsonIgnore
    protected boolean enabled;
    protected Active active;
    protected String templateDirectory;
    protected Boolean useLocalArtifact;
    protected String baseImage;

    @Override
    public void freeze() {
        super.freeze();
        this.registries.forEach(AbstractModelObject::freeze);
    }

    @Override
    public void merge(S docker) {
        this.freezeCheck();
        this.active = this.merge(this.active, ((AbstractDockerConfiguration)docker).active);
        this.enabled = this.merge(this.enabled, ((AbstractDockerConfiguration)docker).enabled);
        this.templateDirectory = this.merge(this.templateDirectory, ((AbstractDockerConfiguration)docker).templateDirectory);
        this.setSkipTemplates(this.merge(this.skipTemplates, ((AbstractDockerConfiguration)docker).skipTemplates));
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractDockerConfiguration)docker).extraProperties));
        this.baseImage = this.merge(this.baseImage, ((AbstractDockerConfiguration)docker).baseImage);
        this.useLocalArtifact = this.merge(this.useLocalArtifact, ((AbstractDockerConfiguration)docker).useLocalArtifact);
        this.setImageNames(this.merge(this.imageNames, ((AbstractDockerConfiguration)docker).imageNames));
        this.setBuildArgs(this.merge(this.buildArgs, ((AbstractDockerConfiguration)docker).buildArgs));
        this.setPreCommands(this.merge(this.preCommands, ((AbstractDockerConfiguration)docker).preCommands));
        this.setPostCommands(this.merge(this.postCommands, ((AbstractDockerConfiguration)docker).postCommands));
        this.setLabels(this.merge(this.labels, ((AbstractDockerConfiguration)docker).labels));
        this.setRegistries(this.merge(this.registries, ((AbstractDockerConfiguration)docker).registries));
    }

    @Override
    public String getPrefix() {
        return "docker";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    public boolean resolveEnabled(Project project, Distribution distribution) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.freezeCheck();
        this.templateDirectory = templateDirectory;
    }

    @Override
    public List<String> getSkipTemplates() {
        return this.freezeWrap(this.skipTemplates);
    }

    @Override
    public void setSkipTemplates(List<String> skipTemplates) {
        this.freezeCheck();
        this.skipTemplates.clear();
        this.skipTemplates.addAll(skipTemplates);
    }

    @Override
    public void addSkipTemplates(List<String> templates) {
        this.freezeCheck();
        this.skipTemplates.addAll(templates);
    }

    @Override
    public void addSkipTemplate(String template) {
        this.freezeCheck();
        if (StringUtils.isNotBlank((String)template)) {
            this.skipTemplates.add(template.trim());
        }
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.freezeWrap(this.extraProperties);
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public void setBaseImage(String baseImage) {
        this.freezeCheck();
        this.baseImage = baseImage;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.freezeWrap(this.labels);
    }

    @Override
    public void setLabels(Map<String, String> labels) {
        this.freezeCheck();
        this.labels.clear();
        this.labels.putAll(labels);
    }

    @Override
    public void addLabels(Map<String, String> labels) {
        this.freezeCheck();
        this.labels.putAll(labels);
    }

    @Override
    public void addLabel(String key, String value) {
        this.freezeCheck();
        if (StringUtils.isNotBlank((String)value)) {
            this.labels.put(key, value);
        }
    }

    @Override
    public Set<String> getImageNames() {
        return this.freezeWrap(this.imageNames);
    }

    @Override
    public void setImageNames(Set<String> imageNames) {
        this.freezeCheck();
        if (imageNames != null) {
            this.imageNames.clear();
            this.imageNames.addAll(imageNames);
        }
    }

    @Override
    public void addImageName(String imageName) {
        this.freezeCheck();
        if (StringUtils.isNotBlank((String)imageName)) {
            this.imageNames.add(imageName);
        }
    }

    @Override
    public List<String> getBuildArgs() {
        return this.freezeWrap(this.buildArgs);
    }

    @Override
    public void setBuildArgs(List<String> buildArgs) {
        this.freezeCheck();
        if (buildArgs != null) {
            this.buildArgs.clear();
            this.buildArgs.addAll(buildArgs);
        }
    }

    @Override
    public void addBuildArg(String buildArg) {
        this.freezeCheck();
        if (StringUtils.isNotBlank((String)buildArg)) {
            this.buildArgs.add(buildArg);
        }
    }

    @Override
    public List<String> getPreCommands() {
        return this.freezeWrap(this.preCommands);
    }

    @Override
    public void setPreCommands(List<String> preCommands) {
        this.freezeCheck();
        if (preCommands != null) {
            this.preCommands.clear();
            this.preCommands.addAll(preCommands);
        }
    }

    @Override
    public List<String> getPostCommands() {
        return this.freezeWrap(this.postCommands);
    }

    @Override
    public void setPostCommands(List<String> postCommands) {
        this.freezeCheck();
        if (postCommands != null) {
            this.postCommands.clear();
            this.postCommands.addAll(postCommands);
        }
    }

    @Override
    public Set<Registry> getRegistries() {
        return this.freezeWrap(this.registries);
    }

    @Override
    public void setRegistries(Set<Registry> registries) {
        this.freezeCheck();
        if (registries != null) {
            this.registries.clear();
            this.registries.addAll(registries);
        }
    }

    @Override
    public void addRegistry(Registry registry) {
        this.freezeCheck();
        if (null != registry) {
            this.registries.add(registry);
        }
    }

    @Override
    public boolean isUseLocalArtifact() {
        return this.useLocalArtifact == null || this.useLocalArtifact != false;
    }

    @Override
    public void setUseLocalArtifact(Boolean useLocalArtifact) {
        this.freezeCheck();
        this.useLocalArtifact = useLocalArtifact;
    }

    @Override
    public boolean isUseLocalArtifactSet() {
        return this.useLocalArtifact != null;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", (Object)this.active);
        props.put("templateDirectory", this.templateDirectory);
        props.put("skipTemplates", this.skipTemplates);
        props.put("useLocalArtifact", this.isUseLocalArtifact());
        props.put("baseImage", this.baseImage);
        props.put("imageNames", this.imageNames);
        props.put("buildArgs", this.buildArgs);
        props.put("labels", this.labels);
        props.put("preCommands", this.preCommands);
        props.put("postCommands", this.postCommands);
        this.asMap(full, props);
        List repos = this.registries.stream().map(r -> r.asMap(full)).collect(Collectors.toList());
        if (!repos.isEmpty()) {
            props.put("registries", repos);
        }
        props.put("extraProperties", this.getResolvedExtraProperties());
        return props;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

