/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

public class JavaRuntimeVersion
implements Version<JavaRuntimeVersion> {
    private static final Pattern PBO = Pattern.compile("(?:\\-([a-zA-Z0-9]+))?\\+(0|[1-9]\\d*)(?:\\-([\\-a-zA-Z0-9\\.]+))?");
    private static final Pattern PO = Pattern.compile("\\-([a-zA-Z0-9]+)(?:\\-([-a-zA-Z0-9.]+))?");
    private static final Pattern O = Pattern.compile("\\+\\-([-a-zA-Z0-9.]+)");
    private final String version;
    private final String prerelease;
    private final String build;
    private final String optional;
    private final Pattern pattern;

    private JavaRuntimeVersion(String version, String prerelease, String build, String optional, Pattern pattern) {
        this.version = version;
        this.prerelease = StringUtils.isNotBlank(prerelease) ? prerelease.trim() : null;
        this.build = StringUtils.isNotBlank(build) ? build.trim() : null;
        this.optional = StringUtils.isNotBlank(optional) ? optional.trim() : null;
        this.pattern = pattern;
    }

    public int feature() {
        String[] parts = this.version.split("\\.");
        return Integer.parseInt(parts[0]);
    }

    public int interim() {
        String[] parts = this.version.split("\\.");
        return parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
    }

    public int update() {
        String[] parts = this.version.split("\\.");
        return parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
    }

    public int patch() {
        String[] parts = this.version.split("\\.");
        return parts.length > 3 ? Integer.parseInt(parts[3]) : 0;
    }

    public boolean hasPrerelease() {
        return StringUtils.isNotBlank(this.prerelease);
    }

    public boolean hasBuild() {
        return StringUtils.isNotBlank(this.build);
    }

    public boolean hasOptional() {
        return StringUtils.isNotBlank(this.optional);
    }

    public String getVersion() {
        return this.version;
    }

    public String getPrerelease() {
        return this.prerelease;
    }

    public String getBuild() {
        return this.build;
    }

    public String getOptional() {
        return this.optional;
    }

    @Override
    public String toRpmVersion() {
        StringBuilder b = new StringBuilder();
        b.append(this.version);
        if (!this.hasPrerelease() && !this.hasBuild() && this.hasOptional()) {
            b.append("~").append(this.optional.replace("-", "_"));
        } else {
            if (this.hasPrerelease()) {
                b.append("~").append(this.prerelease.replace("-", "_"));
            }
            if (this.hasBuild()) {
                b.append("_").append(this.build.replace("-", "_"));
            }
            if (this.hasOptional()) {
                b.append("_").append(this.optional.replace("-", "_"));
            }
        }
        return b.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.version);
        if (!this.hasPrerelease() && !this.hasBuild() && this.hasOptional()) {
            b.append("+-").append(this.optional);
        } else {
            if (this.hasPrerelease()) {
                b.append("-").append(this.prerelease);
            }
            if (this.hasBuild()) {
                b.append("+").append(this.build);
            }
            if (this.hasOptional()) {
                b.append("-").append(this.optional);
            }
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaRuntimeVersion v = (JavaRuntimeVersion)o;
        return this.pattern.pattern().equals(v.pattern.pattern()) && Objects.equals(this.version, v.version) && Objects.equals(this.prerelease, v.prerelease) && Objects.equals(this.build, v.build) && Objects.equals(this.optional, v.optional);
    }

    public int hashCode() {
        return Objects.hash(this.pattern.pattern(), this.version, this.prerelease, this.build, this.optional);
    }

    @Override
    public int compareTo(JavaRuntimeVersion that) {
        int c = this.compareVersion(this.version, that.version);
        if (c != 0) {
            return c;
        }
        c = this.compareStrings(this.prerelease, that.prerelease);
        if (c != 0) {
            return c;
        }
        c = this.compareStringsInvert(this.build, that.build);
        if (c != 0) {
            return c;
        }
        return this.compareStringsInvert(this.optional, that.optional);
    }

    @Override
    public boolean equalsSpec(JavaRuntimeVersion version) {
        return this.pattern.pattern().equals(version.pattern.pattern());
    }

    private int compareVersion(String v1, String v2) {
        return this.compareTokens(v1.split("\\."), v2.split("\\."));
    }

    private int compareStrings(String s1, String s2) {
        if (StringUtils.isBlank(s1) && StringUtils.isBlank(s2)) {
            return 0;
        }
        if (StringUtils.isBlank(s1)) {
            if (StringUtils.isNotBlank(s2)) {
                return 1;
            }
        } else if (StringUtils.isBlank(s2)) {
            return -1;
        }
        return s1.compareTo(s2);
    }

    private int compareStringsInvert(String s1, String s2) {
        if (StringUtils.isBlank(s1) && StringUtils.isBlank(s2)) {
            return 0;
        }
        if (StringUtils.isBlank(s1)) {
            if (StringUtils.isNotBlank(s2)) {
                return -1;
            }
        } else if (StringUtils.isBlank(s2)) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    private int compareTokens(String[] t1, String[] t2) {
        int n = Math.min(t1.length, t2.length);
        for (int i = 0; i < n; ++i) {
            String s1 = t1[i];
            String s2 = t2[i];
            try {
                int c = this.compareAsNumbers(s1, s2);
                if (0 == c) continue;
                return c;
            }
            catch (NumberFormatException e) {
                int c = s1.compareTo(s2);
                if (0 == c) continue;
                return c;
            }
        }
        String[] rest = t1.length > t2.length ? t1 : t2;
        int e = rest.length;
        for (int i = n; i < e; ++i) {
            String o = rest[i];
            if ("0".equals(o)) continue;
            return t1.length - t2.length;
        }
        return 0;
    }

    private int compareAsNumbers(String s1, String s2) {
        int i1 = Integer.parseInt(s1);
        int i2 = Integer.parseInt(s2);
        return Integer.compare(i1, i2);
    }

    public static JavaRuntimeVersion defaultOf() {
        return JavaRuntimeVersion.of("0.0.0");
    }

    public static JavaRuntimeVersion of(String version) {
        StringUtils.requireNonBlank(version, "Argument 'version' must not be blank");
        char c = version.charAt(0);
        if (c < '0' || c > '9') {
            throw new IllegalArgumentException("Version does not start with a digit: '" + version + "'");
        }
        String v = JavaRuntimeVersion.take(version, 0, CollectionUtils.listOf(Character.valueOf('-'), Character.valueOf('+')));
        String p = null;
        String b = null;
        String o = null;
        if (v.length() + 1 < version.length()) {
            String s = version.substring(v.length());
            Matcher m = O.matcher(s);
            if (m.matches()) {
                return new JavaRuntimeVersion(v, p, b, m.group(1), O);
            }
            m = PO.matcher(s);
            if (m.matches()) {
                return new JavaRuntimeVersion(v, m.group(1), b, m.group(2), PO);
            }
            m = PBO.matcher(s);
            if (m.matches()) {
                p = m.group(1);
                b = m.group(2);
                o = m.group(3);
            }
        }
        return new JavaRuntimeVersion(v, p, b, o, PBO);
    }

    private static String take(String str, int index, List<Character> delims) {
        char c;
        StringBuilder b = new StringBuilder();
        for (int i = index; i < str.length() && !delims.contains(Character.valueOf(c = str.charAt(i))); ++i) {
            b.append(c);
        }
        return b.toString();
    }

    public static JavaRuntimeVersion of(String version, String tag, String build, String optional) {
        return JavaRuntimeVersion.of(version, tag, build, optional, PBO);
    }

    private static JavaRuntimeVersion of(String version, String tag, String build, String optional, Pattern pattern) {
        StringUtils.requireNonBlank(version, "Argument 'version' must not be blank");
        return new JavaRuntimeVersion(version, tag, build, optional, pattern);
    }
}

