/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitlab.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import feign.form.FormData;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jreleaser.sdk.gitlab.api.GlBranch;
import org.jreleaser.sdk.gitlab.api.GlFileUpload;
import org.jreleaser.sdk.gitlab.api.GlLink;
import org.jreleaser.sdk.gitlab.api.GlLinkRequest;
import org.jreleaser.sdk.gitlab.api.GlMilestone;
import org.jreleaser.sdk.gitlab.api.GlProject;
import org.jreleaser.sdk.gitlab.api.GlRelease;
import org.jreleaser.sdk.gitlab.api.GlUser;
import org.jreleaser.sdk.gitlab.internal.Page;

public interface GitlabAPI {
    @RequestLine(value="GET /user")
    public GlUser getCurrentUser();

    @RequestLine(value="GET /projects/{projectId}")
    @Headers(value={"Content-Type: application/json"})
    public GlProject getProject(@Param(value="projectId") String var1);

    @RequestLine(value="GET /users/{userId}/projects")
    public List<GlProject> getProject(@Param(value="userId") Integer var1, @QueryMap Map<String, Object> var2);

    @RequestLine(value="POST /projects")
    @Headers(value={"Content-Type: multipart/form-data"})
    public GlProject createProject(@Param(value="name") String var1, @Param(value="visibility") String var2);

    @RequestLine(value="GET /projects/{projectId}/releases/{tagName}")
    public GlRelease getRelease(@Param(value="projectId") Integer var1, @Param(value="tagName") String var2);

    @RequestLine(value="DELETE /projects/{projectId}/repository/tags/{tagName}")
    public void deleteTag(@Param(value="projectId") Integer var1, @Param(value="tagName") String var2);

    @RequestLine(value="DELETE /projects/{projectId}/releases/{tagName}")
    public void deleteRelease(@Param(value="projectId") Integer var1, @Param(value="tagName") String var2);

    @RequestLine(value="POST /projects/{projectId}/releases")
    @Headers(value={"Content-Type: application/json"})
    public void createRelease(GlRelease var1, @Param(value="projectId") Integer var2);

    @RequestLine(value="PUT /projects/{projectId}/releases/{tagName}")
    @Headers(value={"Content-Type: application/json"})
    public void updateRelease(GlRelease var1, @Param(value="projectId") Integer var2);

    @RequestLine(value="POST /projects/{projectId}/uploads")
    @Headers(value={"Content-Type: multipart/form-data"})
    public GlFileUpload uploadFile(@Param(value="projectId") Integer var1, @Param(value="file") FormData var2);

    @RequestLine(value="POST /projects/{projectId}/releases/{tagName}/assets/links")
    @Headers(value={"Content-Type: multipart/form-data"})
    public GlLink linkAsset(GlLinkRequest var1, @Param(value="projectId") Integer var2, @Param(value="tagName") String var3);

    @RequestLine(value="GET /projects/{projectId}/milestones")
    public List<GlMilestone> findMilestoneByTitle(@Param(value="projectId") Integer var1, @QueryMap Map<String, Object> var2);

    @RequestLine(value="PUT /projects/{projectId}/milestones/{milestoneId}")
    @Headers(value={"Content-Type: application/json"})
    public void updateMilestone(Map<String, Object> var1, @Param(value="projectId") Integer var2, @Param(value="milestoneId") Integer var3);

    @RequestLine(value="GET /search")
    @Headers(value={"Content-Type: application/json"})
    public List<GlUser> searchUser(@QueryMap Map<String, String> var1);

    @RequestLine(value="GET /projects/{projectId}/releases")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GlRelease>> listReleases0(@Param(value="projectId") String var1);

    @RequestLine(value="GET")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GlRelease>> listReleases1(URI var1);

    @RequestLine(value="GET /projects/{projectId}/repository/branches")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GlBranch>> listBranches0(@Param(value="projectId") String var1);

    @RequestLine(value="GET")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GlBranch>> listBranches1(URI var1);
}

