/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.forgejo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.Client;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormData;
import feign.form.FormEncoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.forgejo.api.Asset;
import org.jreleaser.sdk.forgejo.api.Branch;
import org.jreleaser.sdk.forgejo.api.ForgejoAPI;
import org.jreleaser.sdk.forgejo.api.Issue;
import org.jreleaser.sdk.forgejo.api.Label;
import org.jreleaser.sdk.forgejo.api.Milestone;
import org.jreleaser.sdk.forgejo.api.Organization;
import org.jreleaser.sdk.forgejo.api.Release;
import org.jreleaser.sdk.forgejo.api.Repository;
import org.jreleaser.sdk.forgejo.api.SearchUser;
import org.jreleaser.sdk.forgejo.api.User;
import org.jreleaser.sdk.forgejo.internal.Page;
import org.jreleaser.sdk.forgejo.internal.PaginatingDecoder;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

public class Forgejo {
    private static final String API_V1 = "/api/v1";
    private final Tika tika = new Tika();
    private final JReleaserContext context;
    private final ForgejoAPI api;

    public Forgejo(JReleaserContext context, String endpoint, String token, int connectTimeout, int readTimeout) {
        Objects.requireNonNull(context, "'context' must not be null");
        StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        StringUtils.requireNonBlank((String)endpoint, (String)"'endpoint' must not be blank");
        if (!endpoint.endsWith(API_V1)) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            endpoint = endpoint + API_V1;
        }
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.context = context;
        this.api = (ForgejoAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).client((Client)new ApacheHttpClient()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(objectMapper))).decoder((Decoder)new PaginatingDecoder((Decoder)new JacksonDecoder(objectMapper))).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("token %s", token)})).target(ForgejoAPI.class, endpoint);
    }

    public Repository findRepository(String owner, String repo) {
        this.context.getLogger().debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
        try {
            return this.api.getRepository(owner, repo);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    public List<org.jreleaser.model.spi.release.Release> listReleases(String owner, String repoName) {
        this.context.getLogger().debug(RB.$((String)"git.list.releases", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<org.jreleaser.model.spi.release.Release> releases = new ArrayList<org.jreleaser.model.spi.release.Release>();
        int pageCount = 0;
        CollectionUtils.MapBuilder params = CollectionUtils.map().e((Object)"draft", (Object)false).e((Object)"prerelease", (Object)false).e((Object)"limit", (Object)20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<Release>> page = this.api.listReleases(owner, repoName, (Map<String, Object>)params);
            page.getContent().stream().map(r -> new org.jreleaser.model.spi.release.Release(r.getName(), r.getTagName(), r.getHtmlUrl(), r.getPublishedAt())).forEach(releases::add);
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return releases;
    }

    public List<String> listBranches(String owner, String repoName) {
        this.context.getLogger().debug(RB.$((String)"git.list.branches", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<String> branches = new ArrayList<String>();
        int pageCount = 0;
        CollectionUtils.MapBuilder params = CollectionUtils.map().e((Object)"limit", (Object)20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<Branch>> page = this.api.listBranches(owner, repoName, (Map<String, Object>)params);
            page.getContent().stream().map(Branch::getName).forEach(branches::add);
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return branches;
    }

    public Map<String, Asset> listAssets(String owner, String repo, Release release) {
        this.context.getLogger().debug(RB.$((String)"git.list.assets.github", (Object[])new Object[0]), new Object[]{owner, repo, release.getId()});
        LinkedHashMap<String, Asset> assets = new LinkedHashMap<String, Asset>();
        for (Asset asset : this.api.listAssets(owner, repo, release.getId())) {
            assets.put(asset.getName(), asset);
        }
        return assets;
    }

    public Optional<Milestone> findMilestoneByName(String owner, String repo, String milestoneName) {
        this.context.getLogger().debug(RB.$((String)"git.milestone.lookup", (Object[])new Object[0]), new Object[]{milestoneName, owner, repo});
        return this.findMilestone(owner, repo, milestoneName, "open");
    }

    public Optional<Milestone> findClosedMilestoneByName(String owner, String repo, String milestoneName) {
        this.context.getLogger().debug(RB.$((String)"git.milestone.lookup.closed", (Object[])new Object[0]), new Object[]{milestoneName, owner, repo});
        return this.findMilestone(owner, repo, milestoneName, "closed");
    }

    private Optional<Milestone> findMilestone(String owner, String repo, String milestoneName, String state) {
        try {
            Milestone milestone = this.api.findMilestoneByTitle(owner, repo, milestoneName);
            if (null == milestone) {
                return Optional.empty();
            }
            return state.equals(milestone.getState()) ? Optional.of(milestone) : Optional.empty();
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    public void closeMilestone(String owner, String repo, Milestone milestone) {
        this.context.getLogger().debug(RB.$((String)"git.milestone.close", (Object[])new Object[0]), new Object[]{milestone.getTitle(), owner, repo});
        this.api.updateMilestone((Map<String, Object>)CollectionUtils.map().e((Object)"state", (Object)"closed"), owner, repo, milestone.getId());
    }

    public Repository createRepository(String owner, String repo) {
        this.context.getLogger().debug(RB.$((String)"git.repository.create", (Object[])new Object[0]), new Object[]{owner, repo});
        CollectionUtils.MapBuilder params = CollectionUtils.map().e((Object)"name", (Object)repo).e((Object)"private", (Object)false);
        Organization organization = this.resolveOrganization(owner);
        if (null != organization) {
            return this.api.createRepository((Map<String, Object>)params, owner);
        }
        return this.api.createRepository((Map<String, Object>)params);
    }

    private Organization resolveOrganization(String name) {
        try {
            return this.api.getOrganization(name);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    public Release findReleaseByTag(String owner, String repo, String tagName) {
        this.context.getLogger().debug(RB.$((String)"git.fetch.release.by.tag", (Object[])new Object[0]), new Object[]{owner, repo, tagName});
        try {
            return this.api.getReleaseByTagName(owner, repo, tagName);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    public void deleteRelease(String owner, String repo, String tagName, Integer id) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.delete.release.from.id", (Object[])new Object[0]), new Object[]{tagName, owner, repo, id});
        try {
            this.api.deleteRelease(owner, repo, id);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return;
            }
            throw e;
        }
    }

    public void deleteTag(String owner, String repo, String tagName) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.delete.tag.from", (Object[])new Object[0]), new Object[]{tagName, owner, repo});
        this.api.deleteTag(owner, repo, tagName);
    }

    public void deletePackage(String owner, String type, String name, String version) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"forgejo.delete.package", (Object[])new Object[0]), new Object[]{owner, type, name, version});
        this.api.deletePackage(owner, type, name, version);
    }

    public Release createRelease(String owner, String repo, Release release) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.create.release", (Object[])new Object[0]), new Object[]{owner, repo, release.getTagName()});
        return this.api.createRelease(release, owner, repo);
    }

    public void updateRelease(String owner, String repo, Integer id, Release release) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.update.release", (Object[])new Object[0]), new Object[]{owner, repo, release.getTagName()});
        this.api.updateRelease(release, owner, repo, id);
    }

    public void uploadAssets(String owner, String repo, Release release, Set<org.jreleaser.model.spi.release.Asset> assets) throws IOException {
        for (org.jreleaser.model.spi.release.Asset asset : assets) {
            if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
            this.uploadOrUpdateAsset(asset, owner, repo, release, "git.upload.asset", "git.upload.asset.failure");
        }
    }

    public void updateAssets(String owner, String repo, Release release, Set<org.jreleaser.model.spi.release.Asset> assets, Map<String, Asset> existingAssets) throws IOException {
        for (org.jreleaser.model.spi.release.Asset asset : assets) {
            if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
            this.context.getLogger().debug(" " + RB.$((String)"git.delete.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            try {
                this.api.deleteAsset(owner, repo, release.getId(), existingAssets.get(asset.getFilename()).getId());
            }
            catch (RestAPIException e) {
                this.context.getLogger().error(" " + RB.$((String)"git.delete.asset.failure", (Object[])new Object[0]), new Object[]{asset.getFilename()});
                throw e;
            }
            this.uploadOrUpdateAsset(asset, owner, repo, release, "git.update.asset", "git.update.asset.failure");
        }
    }

    private void uploadOrUpdateAsset(org.jreleaser.model.spi.release.Asset asset, String owner, String repo, Release release, String operationMessageKey, String operationErrorMessageKey) throws IOException {
        this.context.getLogger().info(" " + RB.$((String)operationMessageKey, (Object[])new Object[0]), new Object[]{asset.getFilename()});
        try {
            this.api.uploadAsset(owner, repo, release.getId(), this.toFormData(asset.getPath()));
        }
        catch (RestAPIException e) {
            this.context.getLogger().error(" " + RB.$((String)operationErrorMessageKey, (Object[])new Object[0]), new Object[]{asset.getFilename()});
            throw e;
        }
    }

    public Optional<org.jreleaser.model.spi.release.User> findUser(String email, String name, String host) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.user.lookup", (Object[])new Object[0]), new Object[]{name, email});
        SearchUser search = this.api.searchUser(CollectionUtils.mapOf((Object[])new Object[]{"q", email}));
        if (null != search.getData() && !search.getData().isEmpty()) {
            User user = search.getData().get(0);
            return Optional.of(new org.jreleaser.model.spi.release.User(user.getUsername(), email, host + user.getUsername()));
        }
        return Optional.empty();
    }

    public Label getOrCreateLabel(String owner, String name, String labelName, String labelColor, String description) {
        this.context.getLogger().debug(RB.$((String)"git.label.fetch", (Object[])new Object[]{labelName}));
        List<Label> labels = this.listLabels(owner, name);
        Optional<Label> label = labels.stream().filter(l -> l.getName().equals(labelName)).findFirst();
        if (label.isPresent()) {
            return label.get();
        }
        this.context.getLogger().debug(RB.$((String)"git.label.create", (Object[])new Object[]{labelName}));
        return this.api.createLabel(owner, name, labelName, labelColor, description);
    }

    public Optional<Issue> findIssue(String owner, String name, int issueNumber) {
        this.context.getLogger().debug(RB.$((String)"git.issue.fetch", (Object[])new Object[]{issueNumber}));
        try {
            return Optional.of(this.api.findIssue(owner, name, issueNumber));
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    public void addLabelToIssue(String owner, String name, Issue issue, Label label) {
        this.context.getLogger().debug(RB.$((String)"git.issue.label", (Object[])new Object[]{label.getName(), issue.getNumber()}));
        LinkedHashMap<String, List<Integer>> labels = new LinkedHashMap<String, List<Integer>>();
        List list = labels.computeIfAbsent("labels", k -> new ArrayList());
        list.addAll(issue.getLabels().stream().map(Label::getId).collect(Collectors.toList()));
        list.add(label.getId());
        this.api.labelIssue(labels, owner, name, issue.getNumber());
    }

    public void commentOnIssue(String owner, String name, Issue issue, String comment) {
        this.context.getLogger().debug(RB.$((String)"git.issue.comment", (Object[])new Object[]{issue.getNumber()}));
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("body", comment);
        this.api.commentIssue(params, owner, name, issue.getNumber());
    }

    public void setMilestoneOnIssue(String owner, String name, Issue issue, Milestone milestone) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("milestone", milestone.getId());
        this.api.updateIssue(params, owner, name, issue.getNumber());
    }

    private List<Label> listLabels(String owner, String repoName) {
        this.context.getLogger().debug(RB.$((String)"git.list.labels", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<Label> labels = new ArrayList<Label>();
        int pageCount = 0;
        CollectionUtils.MapBuilder params = CollectionUtils.map().e((Object)"limit", (Object)20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<Label>> page = this.api.listLabels(owner, repoName, (Map<String, Object>)params);
            labels.addAll((Collection)page.getContent());
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return labels;
    }

    private FormData toFormData(Path asset) throws IOException {
        return FormData.builder().fileName(asset.getFileName().toString()).contentType(MediaType.parse((String)this.tika.detect(asset)).toString()).data(Files.readAllBytes(asset)).build();
    }
}

