/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Parser;
import com.github.sbaudoin.yamllint.rules.LineRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class NewLines
extends LineRule {
    public static final String OPTION_TYPE = "type";

    public NewLines() {
        this.registerOption(OPTION_TYPE, Arrays.asList("unix", "dos", "platform"));
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Parser.Line line) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        String newLineChar = null;
        switch ((String)conf.get(OPTION_TYPE)) {
            case "dos": {
                newLineChar = "\r\n";
                break;
            }
            case "unix": {
                newLineChar = "\n";
                break;
            }
            default: {
                newLineChar = System.getProperty("line.separator");
            }
        }
        if (line.getStart() == 0 && line.getBuffer().length() > line.getEnd()) {
            int endIndex;
            assert (newLineChar != null);
            int n = endIndex = line.getEnd() + newLineChar.length() <= line.getBuffer().length() ? line.getEnd() + newLineChar.length() : line.getEnd() + 1;
            if (!newLineChar.equals(line.getBuffer().substring(line.getEnd(), endIndex))) {
                problems.add(new LintProblem(1, line.getEnd() - line.getStart() + 1, "wrong new line character: expected " + newLineChar.replace("\n", "\\n").replace("\r", "\\r")));
            }
        }
        return problems;
    }
}

