/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.AbstractLoggingCommand;
import org.jreleaser.cli.HaltExecutionException;
import org.jreleaser.cli.IO;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.engine.context.ContextCreator;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.environment.Environment;
import org.jreleaser.util.Env;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import picocli.CommandLine;

public abstract class AbstractModelCommand<C extends IO>
extends AbstractLoggingCommand<C> {
    @CommandLine.Option(names={"-c", "--config-file"}, paramLabel="<file>")
    Path configFile;
    @CommandLine.Option(names={"-grs", "--git-root-search"})
    Boolean gitRootSearch;
    @CommandLine.Option(names={"--strict"})
    Boolean strict;
    @CommandLine.Option(names={"-P", "--set-property"}, paramLabel="<key=value>")
    String[] properties;
    Path actualConfigFile;
    Path actualBasedir;

    @Override
    protected void collectCandidateDeprecatedArgs(Set<AbstractCommand.DeprecatedArg> args) {
        super.collectCandidateDeprecatedArgs(args);
        args.add(new AbstractCommand.DeprecatedArg("-grs", "--git-root-search", "1.5.0"));
    }

    @Override
    protected void execute() {
        this.resolveConfigFile();
        this.resolveBasedir();
        this.initLogger();
        PlatformUtils.resolveCurrentPlatform((JReleaserLogger)this.logger);
        this.logger.info("JReleaser {}", new Object[]{JReleaserVersion.getPlainVersion()});
        JReleaserVersion.banner((PrintWriter)this.logger.getTracer());
        this.logger.info(this.$("TEXT_config_file", new Object[0]), new Object[]{this.actualConfigFile});
        this.logger.increaseIndent();
        this.logger.info(this.$("TEXT_basedir_set", new Object[0]), new Object[]{this.actualBasedir.toAbsolutePath()});
        this.logger.info(this.$("TEXT_outputdir_set", new Object[0]), new Object[]{this.getOutputDirectory().toAbsolutePath()});
        this.logger.decreaseIndent();
        this.doExecute(this.createContext());
    }

    private void resolveConfigFile() {
        if (null != this.configFile) {
            this.actualConfigFile = this.configFile.normalize();
        } else {
            Path directory = Paths.get(".", new String[0]).normalize();
            Optional<Path> file = this.resolveConfigFileAt(directory);
            if (!file.isPresent() && null != this.basedir) {
                file = this.resolveConfigFileAt(this.basedir);
            }
            this.actualConfigFile = file.orElse(null);
        }
        if (null == this.actualConfigFile || !Files.exists(this.actualConfigFile, new LinkOption[0])) {
            this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(this.$("ERROR_missing_config_file", String.join((CharSequence)"|", this.getSupportedConfigFormats()))));
            this.spec.commandLine().usage(this.parent().getOut());
            throw new HaltExecutionException();
        }
    }

    private Optional<Path> resolveConfigFileAt(Path directory) {
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            Path file = directory.resolve("jreleaser." + parser.getPreferredFileExtension()).normalize();
            if (!Files.exists(file, new LinkOption[0])) continue;
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private void resolveBasedir() {
        String resolvedBasedir = Env.resolve((String)"BASEDIR", (String)(null != this.basedir ? this.basedir.toString() : ""));
        this.actualBasedir = (StringUtils.isNotBlank((String)resolvedBasedir) ? Paths.get(resolvedBasedir, new String[0]) : this.actualConfigFile.toAbsolutePath().getParent()).normalize();
        if (!Files.exists(this.actualBasedir, new LinkOption[0])) {
            this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(this.$("ERROR_missing_required_option", "--basedir=<basedir>")));
            this.spec.commandLine().usage(this.parent().getOut());
            throw new HaltExecutionException();
        }
    }

    protected abstract void doExecute(JReleaserContext var1);

    protected JReleaserContext createContext() {
        JReleaserModel model = ContextCreator.resolveModel((JReleaserLogger)this.logger, (Path)this.actualConfigFile);
        Environment.PropertiesPropertiesSource propertiesSource = new Environment.PropertiesPropertiesSource(this.collectProperties());
        model.getEnvironment().setPropertiesSource((Environment.PropertiesSource)propertiesSource);
        return ContextCreator.create((JReleaserLogger)this.logger, (JReleaserContext.Configurer)this.resolveConfigurer(this.actualConfigFile), (JReleaserContext.Mode)this.getMode(), (JReleaserCommand)this.getCommand(), (JReleaserModel)model, (Path)this.actualBasedir, (Path)this.getOutputDirectory(), (boolean)this.resolveBoolean("DRY_RUN", this.dryrun()), (boolean)this.resolveBoolean("GIT_ROOT_SEARCH", this.gitRootSearch()), (boolean)this.resolveBoolean("STRICT", this.strict()), this.collectSelectedPlatforms(), this.collectRejectedPlatforms());
    }

    protected boolean resolveBoolean(String key, Boolean value) {
        if (null != value) {
            return value;
        }
        String resolvedValue = Env.resolve((String)key, (String)"");
        return StringUtils.isNotBlank((String)resolvedValue) && Boolean.parseBoolean(resolvedValue);
    }

    protected List<String> resolveCollection(String key, List<String> values) {
        if (!values.isEmpty()) {
            return values;
        }
        String resolvedValue = Env.resolve((String)key, (String)"");
        if (StringUtils.isBlank((String)resolvedValue)) {
            return Collections.emptyList();
        }
        return Arrays.stream(resolvedValue.trim().split(",")).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    protected JReleaserContext.Configurer resolveConfigurer(Path configFile) {
        switch (StringUtils.getFilenameExtension((String)configFile.getFileName().toString())) {
            case "yml": 
            case "yaml": {
                return JReleaserContext.Configurer.CLI_YAML;
            }
            case "toml": {
                return JReleaserContext.Configurer.CLI_TOML;
            }
            case "json": {
                return JReleaserContext.Configurer.CLI_JSON;
            }
        }
        throw new IllegalArgumentException(this.$("ERROR_invalid_config_format", configFile.getFileName()));
    }

    @Override
    protected Path getOutputDirectory() {
        return FileUtils.resolveOutputDirectory((Path)this.actualBasedir, (Path)this.outputdir, (String)"out");
    }

    protected Boolean dryrun() {
        return false;
    }

    protected Boolean strict() {
        return this.strict;
    }

    protected Boolean gitRootSearch() {
        return this.gitRootSearch;
    }

    private Set<String> getSupportedConfigFormats() {
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            extensions.add("." + parser.getPreferredFileExtension());
        }
        return extensions;
    }

    protected JReleaserContext.Mode getMode() {
        return JReleaserContext.Mode.FULL;
    }

    protected abstract JReleaserCommand getCommand();

    protected List<String> collectSelectedPlatforms() {
        return Collections.emptyList();
    }

    protected List<String> collectRejectedPlatforms() {
        return Collections.emptyList();
    }

    protected Properties collectProperties() {
        Properties props = new Properties();
        if (null != this.properties && this.properties.length > 0) {
            for (String property : this.properties) {
                if (property.contains("=")) {
                    int d = property.indexOf(61);
                    if (d == 0 || d == this.properties.length - 1) {
                        throw new IllegalArgumentException(this.$("ERROR_invalid_property", property));
                    }
                    props.put(property.substring(0, d), property.substring(d + 1));
                    continue;
                }
                props.put(property, Boolean.TRUE);
            }
        }
        return props;
    }
}

