/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.assemble.JpackageAssembler;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Java;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.validation.assemble.AssemblersValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public final class JpackageAssemblerValidator {
    private static final String MAC_IDENTIFIER = "[a-zA-Z0-9][a-zA-Z0-9\\.\\-]*";
    private static final Pattern MAC_IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9\\.\\-]*");

    private JpackageAssemblerValidator() {
    }

    public static void validateJpackage(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, JpackageAssembler> jpackage = context.getModel().getAssemble().getJpackage();
        if (!jpackage.isEmpty()) {
            context.getLogger().debug("assemble.jpackage");
        }
        for (Map.Entry<String, JpackageAssembler> e : jpackage.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAssembly()) continue;
            JpackageAssemblerValidator.validateJpackage(context, mode, e.getValue(), errors);
        }
    }

    public static void postValidateJpackage(JReleaserContext context) {
        context.getLogger().debug("assemble.jpackage");
        Map<String, JpackageAssembler> jpackage = context.getModel().getAssemble().getJpackage();
        for (Map.Entry<String, JpackageAssembler> e : jpackage.entrySet()) {
            JpackageAssemblerValidator.postValidateJpackage(context, e.getValue());
        }
    }

    private static void validateJpackage(JReleaserContext context, JReleaserContext.Mode mode, JpackageAssembler assembler, Errors errors) {
        context.getLogger().debug("assemble.jpackage.{}", new Object[]{assembler.getName()});
        Validator.resolveActivatable(context, (Activatable)assembler, CollectionUtils.listOf((Object[])new String[]{"assemble.jpackage." + assembler.getName(), "assemble.jpackage"}), "NEVER");
        Project project = context.getModel().getProject();
        if (!assembler.resolveEnabled(project)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        JpackageAssembler.PlatformPackager packager = assembler.getResolvedPlatformPackager();
        JpackageAssembler.ApplicationPackage applicationPackage = assembler.getApplicationPackage();
        packager.enable();
        assembler.setPlatform(assembler.getPlatform().mergeValues(context.getModel().getPlatform()));
        boolean hasJavaArchive = false;
        if (StringUtils.isNotBlank((String)assembler.getJlink())) {
            JlinkAssembler jlink = context.getModel().getAssemble().findJlink(assembler.getJlink());
            hasJavaArchive = jlink.getJavaArchive().isSet();
            Path baseOutputDirectory = context.getAssembleDirectory().resolve(jlink.getName()).resolve(jlink.getType());
            String imageName = jlink.getResolvedImageName(context);
            ArrayList<Artifact> candidateRuntimeImages = new ArrayList<Artifact>();
            for (Artifact targetJdk : jlink.getTargetJdks()) {
                if (!context.isPlatformSelected(targetJdk)) continue;
                String platform = targetJdk.getPlatform();
                String platformReplaced = assembler.getPlatform().applyReplacements(platform);
                Path path = baseOutputDirectory.resolve("work-" + platform).resolve(imageName + "-" + platformReplaced).toAbsolutePath();
                candidateRuntimeImages.add(Artifact.of(path, platform));
            }
            if (!assembler.getRuntimeImages().isEmpty() && assembler.getRuntimeImages().size() != candidateRuntimeImages.size()) {
                errors.configuration(RB.$((String)"validation_jpackage_jlink_application", (Object[])new Object[]{assembler.getName()}));
            }
            int count = 0;
            for (Artifact runtimeImage : assembler.getRuntimeImages()) {
                Path path;
                Path rp = runtimeImage.getResolvedPath(context, assembler);
                Path tp = runtimeImage.getResolvedTransform(context, assembler);
                Path path2 = path = null != tp ? tp : rp;
                if (!candidateRuntimeImages.stream().anyMatch(a -> a.getPath().equals(path.toString()))) continue;
                ++count;
            }
            if (!assembler.getRuntimeImages().isEmpty() && count != candidateRuntimeImages.size()) {
                errors.configuration(RB.$((String)"validation_jpackage_jlink_application", (Object[])new Object[]{assembler.getName()}));
            }
            assembler.setJava(jlink.getJava());
            assembler.setMainJar(jlink.getMainJar());
            assembler.setJars(jlink.getJars());
            packager.setJdk(jlink.getJdk());
            if (StringUtils.isBlank((String)assembler.getExecutable())) {
                assembler.setExecutable(jlink.getExecutable());
            }
            for (Artifact runtimeImage : candidateRuntimeImages) {
                runtimeImage.resolveActiveAndSelected(context);
                assembler.addRuntimeImage(runtimeImage);
            }
        }
        if (!hasJavaArchive) {
            assembler.getMainJar().resolveActiveAndSelected(context);
        }
        context.getLogger().debug("assemble.jpackage.{}.java", new Object[]{assembler.getName()});
        if (!JpackageAssemblerValidator.validateJava(context, assembler, errors)) {
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            assembler.disable();
            return;
        }
        if (StringUtils.isBlank((String)assembler.getExecutable())) {
            assembler.setExecutable(assembler.getName());
        }
        if (assembler.getRuntimeImages().isEmpty()) {
            errors.configuration(RB.$((String)"validation_jpackage_runtime_images_missing", (Object[])new Object[]{assembler.getName()}));
            return;
        }
        int i = 0;
        for (Artifact runtimeImage : assembler.getRuntimeImages()) {
            JpackageAssemblerValidator.validateRuntimeImage(context, mode, assembler, runtimeImage, i++, errors);
        }
        Map<String, List<Artifact>> byPlatform = assembler.getRuntimeImages().stream().collect(Collectors.groupingBy(ri -> StringUtils.isBlank((String)ri.getPlatform()) ? "<nil>" : ri.getPlatform()));
        if (byPlatform.containsKey("<nil>")) {
            errors.configuration(RB.$((String)"validation_jpackage_runtime_image_platform", (Object[])new Object[]{assembler.getName()}));
        }
        byPlatform.forEach((p, jdks) -> {
            if (jdks.size() > 1) {
                errors.configuration(RB.$((String)"validation_jpackage_runtime_image_multiple_platforms", (Object[])new Object[]{assembler.getName(), p}));
            }
        });
        if (StringUtils.isBlank((String)packager.getJdk().getPath())) {
            String javaHome = System.getProperty("java.home");
            if (StringUtils.isBlank((String)javaHome)) {
                errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                return;
            }
            packager.getJdk().setPath(javaHome);
            packager.getJdk().setPlatform(PlatformUtils.getCurrentFull());
            packager.getJdk().resolveActiveAndSelected(context);
        }
        if (packager.getTypes().isEmpty()) {
            packager.setTypes(Collections.singletonList(packager.getValidTypes().get(0)));
        }
        if (StringUtils.isBlank((String)applicationPackage.getAppName())) {
            applicationPackage.setAppName(assembler.getName());
        }
        if (StringUtils.isBlank((String)applicationPackage.getAppVersion())) {
            applicationPackage.setAppVersion(project.getResolvedVersion());
        }
        String appVersion = applicationPackage.getResolvedAppVersion(context, assembler);
        try {
            SemanticVersion v = SemanticVersion.of((String)appVersion);
            if (StringUtils.isNotBlank((String)v.getBuild()) || StringUtils.isNotBlank((String)v.getTag())) {
                errors.configuration(RB.$((String)"validation_jpackage_invalid_appversion_t", (Object[])new Object[]{appVersion}));
            }
            if (PlatformUtils.isMac() && v.getMajor() <= 0) {
                errors.configuration(RB.$((String)"validation_jpackage_invalid_appversion_n", (Object[])new Object[]{appVersion}));
            }
        }
        catch (IllegalArgumentException e) {
            errors.configuration(RB.$((String)"validation_jpackage_invalid_appversion_n", (Object[])new Object[]{appVersion}));
        }
        if (StringUtils.isBlank((String)applicationPackage.getVendor())) {
            applicationPackage.setVendor(project.getVendor());
        }
        if (StringUtils.isBlank((String)applicationPackage.getVendor())) {
            errors.configuration(RB.$((String)"validation_jpackage_missing_vendor", (Object[])new Object[]{assembler.getName()}));
        }
        if (StringUtils.isBlank((String)applicationPackage.getCopyright())) {
            applicationPackage.setCopyright(project.getCopyright());
        }
        AssemblersValidator.validateJavaAssembler(context, mode, assembler, errors, false);
        if (StringUtils.isBlank((String)packager.getAppName())) {
            packager.setAppName(assembler.getApplicationPackage().getAppName());
        }
        if (packager instanceof JpackageAssembler.Linux) {
            JpackageAssemblerValidator.validateLinux(context, assembler, (JpackageAssembler.Linux)packager, errors);
        }
        if (packager instanceof JpackageAssembler.Osx) {
            JpackageAssemblerValidator.validateOsx(context, assembler, (JpackageAssembler.Osx)packager, errors);
        }
        if (packager instanceof JpackageAssembler.Windows) {
            JpackageAssemblerValidator.validateWindows(context, assembler, (JpackageAssembler.Windows)packager, errors);
        }
    }

    private static void validateOsx(JReleaserContext context, JpackageAssembler jpackage, JpackageAssembler.Osx packager, Errors errors) {
        if (StringUtils.isNotBlank((String)packager.getPackageIdentifier()) && !MAC_IDENTIFIER_PATTERN.matcher(packager.getPackageIdentifier()).matches()) {
            errors.configuration(RB.$((String)"validation_jpackage_invalid_mac_package_identifier", (Object[])new Object[]{packager.getPackageIdentifier(), MAC_IDENTIFIER}));
        }
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(packager.getAppName());
        }
        if (StringUtils.isNotBlank((String)packager.getPackageName()) && packager.getPackageName().length() > 16) {
            errors.configuration(RB.$((String)"validation_jpackage_invalid_mac_package_name", (Object[])new Object[]{packager.getPackageName()}));
        }
    }

    private static void validateLinux(JReleaserContext context, JpackageAssembler jpackage, JpackageAssembler.Linux packager, Errors errors) {
        if (StringUtils.isBlank((String)packager.getLicense())) {
            packager.setLicense(context.getModel().getProject().getLicense());
        }
    }

    private static void validateWindows(JReleaserContext context, JpackageAssembler jpackage, JpackageAssembler.Windows packager, Errors errors) {
    }

    private static boolean validateJava(JReleaserContext context, JpackageAssembler jpackage, Errors errors) {
        Project project = context.getModel().getProject();
        Java java = project.getLanguages().getJava();
        if (!jpackage.getJava().isEnabledSet() && java.isEnabledSet()) {
            jpackage.getJava().setEnabled(java.isEnabled());
        }
        if (!jpackage.getJava().isEnabledSet()) {
            jpackage.getJava().setEnabled(jpackage.getJava().isSet());
        }
        if (!jpackage.getJava().isEnabled()) {
            return false;
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getArtifactId())) {
            jpackage.getJava().setArtifactId(java.getArtifactId());
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getGroupId())) {
            jpackage.getJava().setGroupId(java.getGroupId());
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getVersion())) {
            jpackage.getJava().setVersion(java.getVersion());
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getMainModule())) {
            jpackage.getJava().setMainModule(java.getMainModule());
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getMainClass())) {
            jpackage.getJava().setMainClass(java.getMainClass());
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getGroupId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"jpackage." + jpackage.getName() + ".java.groupId"}));
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getMainClass())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"jpackage." + jpackage.getName() + ".java.mainClass"}));
        }
        return true;
    }

    private static void validateRuntimeImage(JReleaserContext context, JReleaserContext.Mode mode, JpackageAssembler jpackage, Artifact runtimeImage, int index, Errors errors) {
        if (mode == JReleaserContext.Mode.FULL) {
            return;
        }
        if (null == runtimeImage) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"jpackage." + jpackage.getName() + ".runtimeImage[" + index + "]"}));
            return;
        }
        if (!runtimeImage.resolveActiveAndSelected(context)) {
            return;
        }
        if (StringUtils.isBlank((String)runtimeImage.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"jpackage." + jpackage.getName() + ".runtimeImage[" + index + "].path"}));
        }
        if (StringUtils.isNotBlank((String)runtimeImage.getPlatform()) && !PlatformUtils.isSupported((String)runtimeImage.getPlatform().trim())) {
            context.getLogger().warn(RB.$((String)"validation_jpackage_platform", (Object[])new Object[]{jpackage.getName(), index, runtimeImage.getPlatform(), System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()}));
        }
    }

    private static void postValidateJpackage(JReleaserContext context, JpackageAssembler jpackage) {
        Project project = context.getModel().getProject();
        if (!jpackage.resolveEnabled(project)) {
            return;
        }
        JpackageAssembler.ApplicationPackage applicationPackage = jpackage.getApplicationPackage();
        if (StringUtils.isBlank((String)applicationPackage.getCopyright())) {
            applicationPackage.setCopyright(project.getCopyright());
        }
    }
}

