/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitlab;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.model.spi.deploy.maven.Deployable;
import org.jreleaser.sdk.commons.AbstractMavenDeployer;
import org.jreleaser.sdk.gitlab.Gitlab;
import org.jreleaser.sdk.gitlab.api.GlPackage;

public class GitlabMavenDeployer
extends AbstractMavenDeployer<org.jreleaser.model.api.deploy.maven.GitlabMavenDeployer, org.jreleaser.model.internal.deploy.maven.GitlabMavenDeployer> {
    private org.jreleaser.model.internal.deploy.maven.GitlabMavenDeployer deployer;

    public GitlabMavenDeployer(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.deploy.maven.GitlabMavenDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(org.jreleaser.model.internal.deploy.maven.GitlabMavenDeployer deployer) {
        this.deployer = deployer;
    }

    public String getType() {
        return "gitlab";
    }

    public void deploy(String name) throws DeployException {
        this.deployPackages();
    }

    protected void deleteExistingPackages(String baseUrl, String token, Set<Deployable> deployables) throws DeployException {
        Gitlab api = this.createApi(baseUrl, token);
        ArrayList<GlPackage> glPackages = new ArrayList<GlPackage>();
        if (!this.context.isDryrun()) {
            try {
                glPackages.addAll(api.listPackages(Integer.parseInt(this.deployer.getProjectIdentifier()), "maven"));
            }
            catch (IOException e) {
                this.context.getLogger().trace((Throwable)e);
                throw new DeployException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
            }
            for (Deployable deployable : deployables) {
                if (!deployable.getFilename().endsWith(".pom")) continue;
                this.deletePackage(api, deployable, glPackages);
            }
        }
    }

    private Gitlab createApi(String baseUrl, String token) throws DeployException {
        URL url = null;
        try {
            url = new URI(baseUrl).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new DeployException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        StringBuilder theUrl = new StringBuilder(url.getProtocol()).append("://").append(url.getHost());
        if (url.getPort() != -1) {
            theUrl.append(url.getPort());
        }
        try {
            return new Gitlab(this.context.asImmutable(), theUrl.toString(), token, this.deployer.getConnectTimeout(), this.deployer.getReadTimeout());
        }
        catch (Exception e) {
            this.context.getLogger().trace((Throwable)e);
            throw new DeployException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private void deletePackage(Gitlab api, Deployable deployable, List<GlPackage> glPackages) {
        try {
            String name = deployable.getGroupId().replace(".", "/") + "/" + deployable.getArtifactId();
            Optional<GlPackage> glPackage = glPackages.stream().filter(p -> p.getName().equals(name) && p.getVersion().equals(deployable.getVersion())).findFirst();
            glPackage.ifPresent(p -> api.deletePackage(Integer.parseInt(this.deployer.getProjectIdentifier()), p.getId()));
        }
        catch (Exception e) {
            this.context.getLogger().debug(RB.$((String)"ERROR_gitlab_delete_package", (Object[])new Object[]{this.deployer.getUsername(), "maven", deployable.getGroupId() + "-" + deployable.getArtifactId(), deployable.getVersion()}));
        }
    }
}

