/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.LinkedinAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class LinkedinAnnouncerValidator {
    private static final String DEFAULT_LINKEDIN_TPL = "src/jreleaser/templates/linkedin.tpl";

    private LinkedinAnnouncerValidator() {
    }

    public static void validateLinkedin(JReleaserContext context, LinkedinAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.linkedin");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.linkedin", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        announcer.setOwner(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.linkedin.owner", "LINKEDIN_OWNER"}), "announce.linkedin.owner", announcer.getOwner(), errors, true));
        announcer.setAccessToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.linkedin.access.token", "LINKEDIN_ACCESS_TOKEN"}), "announce.linkedin.accessToken", announcer.getAccessToken(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)announcer.getSubject())) {
            announcer.setSubject("{{projectNameCapitalized}} {{projectVersion}} released");
        }
        if (StringUtils.isBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_LINKEDIN_TPL), new LinkOption[0])) {
                announcer.setMessageTemplate(DEFAULT_LINKEDIN_TPL);
            } else {
                announcer.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)announcer.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"linkedin.messageTemplate", announcer.getMessageTemplate()}));
        }
        Validator.validateTimeout(announcer);
    }
}

