/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.sdkman;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.SdkmanPackager;
import org.jreleaser.model.internal.util.SdkmanHelper;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.sdkman.AnnounceSdkmanCommand;
import org.jreleaser.sdk.sdkman.MajorReleaseSdkmanCommand;
import org.jreleaser.sdk.sdkman.MinorReleaseSdkmanCommand;
import org.jreleaser.sdk.sdkman.SdkmanException;
import org.jreleaser.util.StringUtils;

public class SdkmanAnnouncer
implements Announcer<org.jreleaser.model.api.announce.SdkmanAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.SdkmanAnnouncer sdkman;

    public SdkmanAnnouncer(JReleaserContext context) {
        this.context = context;
        this.sdkman = context.getModel().getAnnounce().getSdkman();
    }

    public org.jreleaser.model.api.announce.SdkmanAnnouncer getAnnouncer() {
        return this.sdkman.asImmutable();
    }

    public String getName() {
        return "sdkman";
    }

    public boolean isEnabled() {
        return this.sdkman.isEnabled();
    }

    public void announce() throws AnnounceException {
        Map<String, Distribution> distributions = this.context.getModel().getActiveDistributions().stream().filter(d -> d.getSdkman().isEnabled()).filter(d -> !JReleaserCommand.supportsPublish((JReleaserCommand)this.context.getCommand()) || d.getSdkman().isPublished()).collect(Collectors.toMap(distribution -> {
            SdkmanPackager sdkman = distribution.getSdkman();
            return StringUtils.isNotBlank((String)sdkman.getCandidate()) ? sdkman.getCandidate().trim() : this.context.getModel().getProject().getName();
        }, distribution -> distribution));
        Boolean set = (Boolean)this.sdkman.getExtraProperties().get("__MAGIC_SET__");
        this.sdkman.getExtraProperties().remove("__MAGIC_SET__");
        if (distributions.isEmpty()) {
            if (null == set || !set.booleanValue()) {
                this.announceProject();
            } else {
                this.context.getLogger().debug(RB.$((String)"announcers.announcer.disabled", (Object[])new Object[0]));
            }
            return;
        }
        boolean failures = false;
        for (Map.Entry<String, Distribution> e : distributions.entrySet()) {
            String candidate = e.getKey();
            Distribution distribution2 = e.getValue();
            SdkmanPackager sdkman = distribution2.getSdkman();
            TemplateContext props = this.context.fullProps();
            props.setAll(distribution2.props());
            String releaseNotesUrl = Templates.resolveTemplate((String)sdkman.getReleaseNotesUrl(), (TemplateContext)props);
            String command = sdkman.getCommand().name().toLowerCase(Locale.ENGLISH);
            this.context.getLogger().info(RB.$((String)"sdkman.release.announce", (Object[])new Object[0]), new Object[]{command, candidate});
            try {
                ((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)AnnounceSdkmanCommand.builder(this.context.asImmutable()).connectTimeout(sdkman.getConnectTimeout())).readTimeout(sdkman.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).build().execute();
            }
            catch (SdkmanException x) {
                this.context.getLogger().warn(x.getMessage().trim());
                failures = true;
            }
        }
        if (failures) {
            throw new AnnounceException(RB.$((String)"ERROR_sdkman_announce", (Object[])new Object[0]));
        }
    }

    private void announceProject() throws AnnounceException {
        LinkedHashMap<String, String> platforms = new LinkedHashMap<String, String>();
        for (Distribution distribution : this.context.getModel().getActiveDistributions()) {
            if (!this.isDistributionSupported(distribution)) continue;
            SdkmanHelper.collectArtifacts((JReleaserContext)this.context, (Distribution)distribution, platforms);
        }
        if (platforms.isEmpty()) {
            this.context.getLogger().warn(RB.$((String)"sdkman.no.suitable.artifacts", (Object[])new Object[0]));
            return;
        }
        try {
            String candidate = StringUtils.isNotBlank((String)this.sdkman.getCandidate()) ? this.sdkman.getCandidate().trim() : this.context.getModel().getProject().getName();
            String releaseNotesUrl = Templates.resolveTemplate((String)this.sdkman.getReleaseNotesUrl(), (TemplateContext)this.context.fullProps());
            if (this.sdkman.isMajor()) {
                this.context.getLogger().info(RB.$((String)"sdkman.release.announce.major", (Object[])new Object[0]), new Object[]{candidate});
                ((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)MajorReleaseSdkmanCommand.builder(this.context.asImmutable()).connectTimeout(this.sdkman.getConnectTimeout())).readTimeout(this.sdkman.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : this.sdkman.getConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : this.sdkman.getConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).platforms(platforms).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).build().execute();
            } else {
                this.context.getLogger().info(RB.$((String)"sdkman.release.announce.minor", (Object[])new Object[0]), new Object[]{candidate});
                ((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)MinorReleaseSdkmanCommand.builder(this.context.asImmutable()).connectTimeout(this.sdkman.getConnectTimeout())).readTimeout(this.sdkman.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : this.sdkman.getConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : this.sdkman.getConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).platforms(platforms).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).build().execute();
            }
        }
        catch (SdkmanException e) {
            throw new AnnounceException((Throwable)e);
        }
    }

    private boolean isDistributionSupported(Distribution distribution) {
        return (distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.JLINK || distribution.getType() == Distribution.DistributionType.BINARY) && !StringUtils.isTrue(distribution.getExtraProperties().get("skipSdkman"));
    }
}

