/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.version;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jreleaser.bundle.RB;
import org.jreleaser.util.ObjectUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.JavaRuntimeVersion;
import org.jreleaser.version.Version;

public class SemanticVersion
implements Version<SemanticVersion> {
    private static final Pattern FULL_SEMVER_PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:([\\.\\-])((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private static final Pattern MAJOR_MINOR_PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:([\\.\\-])((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private static final Pattern MAJOR_PATTERN = Pattern.compile("^(0|[1-9]\\d*)(?:([\\.\\-])((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private final int major;
    private final int minor;
    private final int patch;
    private final String tagsep;
    private final String tag;
    private final String build;
    private final Pattern pattern;

    private SemanticVersion(int major, int minor, int patch, String tagsep, String tag, String build, Pattern pattern) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.tagsep = StringUtils.isNotBlank((String)tagsep) ? tagsep.trim() : null;
        this.tag = StringUtils.isNotBlank((String)tag) ? tag.trim() : null;
        this.build = StringUtils.isNotBlank((String)build) ? build.trim() : null;
        this.pattern = pattern;
        if (StringUtils.isNotBlank((String)tagsep)) {
            ObjectUtils.requireState((".".equals(tagsep) || "-".equals(tagsep) ? 1 : 0) != 0, (String)"Argument 'tagsep' must not be '.' or '-'");
        }
    }

    public boolean hasMinor() {
        return this.minor != -1;
    }

    public boolean hasPatch() {
        return this.patch != -1;
    }

    public boolean hasTag() {
        return StringUtils.isNotBlank((String)this.tag);
    }

    public boolean hasBuild() {
        return StringUtils.isNotBlank((String)this.build);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getTagsep() {
        return this.tagsep;
    }

    public String getTag() {
        return this.tag;
    }

    public String getBuild() {
        return this.build;
    }

    @Override
    public String toRpmVersion() {
        StringBuilder b = new StringBuilder();
        b.append(this.major);
        if (this.hasMinor()) {
            b.append(".").append(this.minor);
        }
        if (this.hasPatch()) {
            b.append(".").append(this.patch);
        }
        if (this.hasTag()) {
            b.append("~").append(this.tag.replace("-", "_"));
        }
        if (this.hasBuild()) {
            b.append("_").append(this.build.replace("-", "_"));
        }
        return b.toString();
    }

    @Override
    public boolean equalsSpec(SemanticVersion version) {
        return this.pattern.pattern().equals(version.pattern.pattern());
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.major);
        if (this.hasMinor()) {
            b.append(".").append(this.minor);
        }
        if (this.hasPatch()) {
            b.append(".").append(this.patch);
        }
        if (this.hasTag()) {
            b.append(this.tagsep).append(this.tag);
        }
        if (this.hasBuild()) {
            b.append("+").append(this.build);
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticVersion version = (SemanticVersion)o;
        return this.pattern.pattern().equals(version.pattern.pattern()) && this.major == version.major && this.minor == version.minor && this.patch == version.patch && Objects.equals(this.tag, version.tag) && Objects.equals(this.build, version.build);
    }

    public int hashCode() {
        return Objects.hash(this.pattern.pattern(), this.major, this.minor, this.patch, this.tag, this.build);
    }

    @Override
    public int compareTo(SemanticVersion other) {
        int result = this.major - other.major;
        if (result == 0 && (result = this.minor - other.minor) == 0) {
            result = this.patch - other.patch;
        }
        if (result == 0 && StringUtils.isNotBlank((String)this.tag)) {
            int n = result = StringUtils.isNotBlank((String)other.tag) ? this.tag.compareTo(other.tag) : -1;
        }
        if (result == 0 && StringUtils.isNotBlank((String)this.build)) {
            result = StringUtils.isNotBlank((String)other.build) ? this.build.compareTo(other.build) : -1;
        }
        return result;
    }

    public static int javaMajorVersion() {
        String jv = System.getProperty("java.version");
        if (jv.startsWith("1.")) {
            return 8;
        }
        return JavaRuntimeVersion.of(jv).feature();
    }

    public static SemanticVersion defaultOf() {
        return SemanticVersion.of("0.0.0");
    }

    public static SemanticVersion of(String version) {
        StringUtils.requireNonBlank((String)version, (String)"Argument 'version' must not be blank");
        Matcher m = FULL_SEMVER_PATTERN.matcher(version.trim());
        if (m.matches()) {
            String major = m.group(1);
            String minor = m.group(2);
            String patch = m.group(3);
            String tagsep = m.group(4);
            String tag = m.group(5);
            String build = m.group(6);
            return SemanticVersion.of(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch), StringUtils.isNotBlank((String)tagsep) ? tagsep : null, StringUtils.isNotBlank((String)tag) ? tag : null, StringUtils.isNotBlank((String)build) ? build : null);
        }
        m = MAJOR_MINOR_PATTERN.matcher(version);
        if (m.matches()) {
            String major = m.group(1);
            String minor = m.group(2);
            String tagsep = m.group(3);
            String tag = m.group(4);
            String build = m.group(5);
            return SemanticVersion.of(Integer.parseInt(major), Integer.parseInt(minor), StringUtils.isNotBlank((String)tagsep) ? tagsep : null, StringUtils.isNotBlank((String)tag) ? tag : null, StringUtils.isNotBlank((String)build) ? build : null);
        }
        m = MAJOR_PATTERN.matcher(version);
        if (m.matches()) {
            String major = m.group(1);
            String tagsep = m.group(2);
            String tag = m.group(3);
            String build = m.group(4);
            return SemanticVersion.of(Integer.parseInt(major), StringUtils.isNotBlank((String)tagsep) ? tagsep : null, StringUtils.isNotBlank((String)tag) ? tag : null, StringUtils.isNotBlank((String)build) ? build : null);
        }
        throw new IllegalArgumentException(RB.$((String)"ERROR_version_parse", (Object[])new Object[]{version}));
    }

    public static SemanticVersion of(int major, int minor, int patch, String tag, String build) {
        return SemanticVersion.of(major, minor, patch, ".", tag, build);
    }

    public static SemanticVersion of(int major, int minor, int patch, String tagsep, String tag, String build) {
        ObjectUtils.requireState((major > -1 ? 1 : 0) != 0, (String)"Argument 'major' must not be negative");
        ObjectUtils.requireState((minor > -1 ? 1 : 0) != 0, (String)"Argument 'minor' must not be negative");
        ObjectUtils.requireState((patch > -1 ? 1 : 0) != 0, (String)"Argument 'patch' must not be negative");
        return new SemanticVersion(major, minor, patch, tagsep, tag, build, FULL_SEMVER_PATTERN);
    }

    public static SemanticVersion of(int major, int minor, String tag, String build) {
        return SemanticVersion.of(major, minor, ".", tag, build);
    }

    public static SemanticVersion of(int major, int minor, String tagsep, String tag, String build) {
        ObjectUtils.requireState((major > -1 ? 1 : 0) != 0, (String)"Argument 'major' must not be negative");
        ObjectUtils.requireState((minor > -1 ? 1 : 0) != 0, (String)"Argument 'minor' must not be negative");
        return new SemanticVersion(major, minor, -1, tagsep, tag, build, MAJOR_MINOR_PATTERN);
    }

    public static SemanticVersion of(int major, String tag, String build) {
        return SemanticVersion.of(major, ".", tag, build);
    }

    public static SemanticVersion of(int major, String tagsep, String tag, String build) {
        ObjectUtils.requireState((major > -1 ? 1 : 0) != 0, (String)"Argument 'major' must not be negative");
        return new SemanticVersion(major, -1, -1, tagsep, tag, build, MAJOR_PATTERN);
    }
}

