/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.common.AbstractArtifact;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.StringUtils;

public final class Artifact
extends AbstractArtifact<Artifact>
implements Domain,
ExtraProperties,
Comparable<Artifact> {
    private static final long serialVersionUID = 4590895350785446198L;
    @JsonIgnore
    private final Map<Algorithm, String> hashes = new LinkedHashMap<Algorithm, String>();
    private String path;
    private String transform;
    @JsonIgnore
    private Path effectivePath;
    @JsonIgnore
    private Path resolvedPath;
    @JsonIgnore
    private Path resolvedTransform;
    @JsonIgnore
    private final org.jreleaser.model.api.common.Artifact immutable = new org.jreleaser.model.api.common.Artifact(){
        private static final long serialVersionUID = -5286060454190216979L;

        public Active getActive() {
            return Artifact.this.getActive();
        }

        public boolean isEnabled() {
            return Artifact.this.isEnabled();
        }

        public boolean isSelected() {
            return Artifact.this.isSelected();
        }

        public Path getEffectivePath() {
            return Artifact.this.effectivePath;
        }

        public Path getResolvedPath() {
            return Artifact.this.resolvedPath;
        }

        public String getPath() {
            return Artifact.this.path;
        }

        public String getHash() {
            return Artifact.this.getHash();
        }

        public String getHash(Algorithm algorithm) {
            return Artifact.this.getHash(algorithm);
        }

        public String getPlatform() {
            return Artifact.this.getPlatform();
        }

        public String getTransform() {
            return Artifact.this.transform;
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Artifact.this.asMap(full));
        }

        public String getPrefix() {
            return Artifact.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(Artifact.this.getExtraProperties());
        }
    };

    public org.jreleaser.model.api.common.Artifact asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Artifact source) {
        super.merge(source);
        this.effectivePath = this.merge(this.effectivePath, source.effectivePath);
        this.path = this.merge(this.path, source.path);
        this.transform = this.merge(this.transform, source.transform);
        this.resolvedPath = this.merge(this.resolvedPath, source.resolvedPath);
        this.resolvedTransform = this.merge(this.resolvedTransform, source.resolvedTransform);
        this.setHashes(source.hashes);
    }

    public boolean isOptional(JReleaserContext context) {
        Object value = this.getExtraProperties().get("optional");
        if (value instanceof CharSequence && value.toString().contains("{{")) {
            value = Templates.resolveTemplate((String)value.toString(), (TemplateContext)context.fullProps());
            this.getExtraProperties().put("optional", value);
        }
        return StringUtils.isTrue((Object)value);
    }

    public Path getEffectivePath() {
        return this.effectivePath;
    }

    public Path getResolvedPath() {
        return this.resolvedPath;
    }

    public Path getResolvedTransform() {
        return this.resolvedTransform;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        this.resolvedPath = null;
        this.effectivePath = null;
        this.resolvedTransform = null;
    }

    public String getHash() {
        return this.getHash(Algorithm.SHA_256);
    }

    public void setHash(String hash) {
        this.setHash(Algorithm.SHA_256, hash);
    }

    public String getHash(Algorithm algorithm) {
        return this.hashes.get(algorithm);
    }

    public void setHash(Algorithm algorithm, String hash) {
        if (StringUtils.isNotBlank((String)hash)) {
            this.hashes.put(algorithm, hash.trim());
        }
    }

    public Map<Algorithm, String> getHashes() {
        return Collections.unmodifiableMap(this.hashes);
    }

    void setHashes(Map<Algorithm, String> hashes) {
        this.hashes.clear();
        this.hashes.putAll(hashes);
    }

    public String getTransform() {
        return this.transform;
    }

    public void setTransform(String transform) {
        this.transform = transform;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("path", this.path);
        map.put("transform", this.transform);
        map.put("platform", this.getPlatform());
        map.put("extraProperties", this.getExtraProperties());
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact that = (Artifact)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    @Override
    public int compareTo(Artifact o) {
        if (null == o) {
            return -1;
        }
        return this.path.compareTo(o.path);
    }

    public void mergeExtraProperties(Map<String, Object> extraProperties) {
        extraProperties.forEach((k, v) -> {
            if (!this.getExtraProperties().containsKey(k)) {
                this.getExtraProperties().put((String)k, v);
            }
        });
    }

    public Path getEffectivePath(JReleaserContext context) {
        if (null == this.effectivePath) {
            Path rp = this.getResolvedPath(context);
            Path tp = this.getResolvedTransform(context);
            this.effectivePath = Artifacts.checkAndCopyFile(context, rp, tp, this.isOptional(context));
        }
        return this.effectivePath;
    }

    public Path getEffectivePath(JReleaserContext context, Distribution distribution) {
        if (null == this.effectivePath) {
            Path rp = this.getResolvedPath(context, distribution);
            Path tp = this.getResolvedTransform(context, distribution);
            this.effectivePath = Artifacts.checkAndCopyFile(context, rp, tp, this.isOptional(context));
        }
        return this.effectivePath;
    }

    public Path getEffectivePath(JReleaserContext context, Assembler<?> assembler) {
        if (null == this.effectivePath) {
            Path rp = this.getResolvedPath(context, assembler);
            Path tp = this.getResolvedTransform(context, assembler);
            this.effectivePath = Artifacts.checkAndCopyFile(context, rp, tp, this.isOptional(context));
        }
        return this.effectivePath;
    }

    public Path getResolvedPath(JReleaserContext context, Path basedir, boolean checkIfExists) {
        if (null == this.resolvedPath) {
            this.path = Artifacts.resolveForArtifact(this.path, context, this);
            this.resolvedPath = basedir.resolve(Paths.get(this.path, new String[0])).normalize();
            if (checkIfExists && !this.isOptional(context) && !Files.exists(this.resolvedPath, new LinkOption[0])) {
                throw new JReleaserException(RB.$((String)"ERROR_path_does_not_exist", (Object[])new Object[]{context.relativizeToBasedir(this.resolvedPath)}));
            }
        }
        return this.resolvedPath;
    }

    public Path getResolvedPath(JReleaserContext context) {
        return this.getResolvedPath(context, context.getBasedir(), context.getMode().validatePaths());
    }

    public Path getResolvedPath(JReleaserContext context, Distribution distribution) {
        if (null == this.resolvedPath) {
            this.path = Artifacts.resolveForArtifact(this.path, context, this, distribution);
            this.resolvedPath = context.getBasedir().resolve(Paths.get(this.path, new String[0])).normalize();
            if (context.getMode().validatePaths() && !this.isOptional(context) && !Files.exists(this.resolvedPath, new LinkOption[0])) {
                throw new JReleaserException(RB.$((String)"ERROR_path_does_not_exist", (Object[])new Object[]{context.relativizeToBasedir(this.resolvedPath)}));
            }
        }
        return this.resolvedPath;
    }

    public Path getResolvedPath(JReleaserContext context, Assembler<?> assembler) {
        if (null == this.resolvedPath) {
            this.path = Artifacts.resolveForArtifact(this.path, context, this, assembler);
            this.resolvedPath = context.getBasedir().resolve(Paths.get(this.path, new String[0])).normalize();
            if (context.getMode().validatePaths() && !this.isOptional(context) && !Files.exists(this.resolvedPath, new LinkOption[0])) {
                throw new JReleaserException(RB.$((String)"ERROR_path_does_not_exist", (Object[])new Object[]{context.relativizeToBasedir(this.resolvedPath)}));
            }
        }
        return this.resolvedPath;
    }

    public boolean resolvedPathExists() {
        return null != this.resolvedPath && Files.exists(this.resolvedPath, new LinkOption[0]);
    }

    public Path getResolvedTransform(JReleaserContext context, Path basedir) {
        if (null == this.resolvedTransform && StringUtils.isNotBlank((String)this.transform)) {
            this.transform = Artifacts.resolveForArtifact(this.transform, context, this);
            this.resolvedTransform = basedir.resolve(Paths.get(this.transform, new String[0])).normalize();
        }
        return this.resolvedTransform;
    }

    public Path getResolvedTransform(JReleaserContext context) {
        return this.getResolvedTransform(context, context.getArtifactsDirectory());
    }

    public Path getResolvedTransform(JReleaserContext context, Distribution distribution) {
        if (null == this.resolvedTransform && StringUtils.isNotBlank((String)this.transform)) {
            this.transform = Artifacts.resolveForArtifact(this.transform, context, this, distribution);
            this.resolvedTransform = context.getArtifactsDirectory().resolve(Paths.get(this.transform, new String[0])).normalize();
        }
        return this.resolvedTransform;
    }

    public Path getResolvedTransform(JReleaserContext context, Assembler<?> assembler) {
        if (null == this.resolvedTransform && StringUtils.isNotBlank((String)this.transform)) {
            this.transform = Artifacts.resolveForArtifact(this.transform, context, this, assembler);
            this.resolvedTransform = context.getArtifactsDirectory().resolve(Paths.get(this.transform, new String[0])).normalize();
        }
        return this.resolvedTransform;
    }

    public void mergeWith(Artifact other) {
        if (this == other) {
            return;
        }
        if (StringUtils.isBlank((String)this.getPlatform())) {
            this.setPlatform(other.getPlatform());
        }
        if (StringUtils.isBlank((String)this.transform)) {
            this.transform = other.transform;
        }
        this.mergeExtraProperties(other.getExtraProperties());
    }

    public Artifact copy() {
        Artifact copy = new Artifact();
        copy.mergeWith(this);
        return copy;
    }

    public static Set<Artifact> sortArtifacts(Set<Artifact> artifacts) {
        return artifacts.stream().sorted(Artifact.comparatorByPlatform()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Comparator<Artifact> comparatorByPlatform() {
        return (a1, a2) -> {
            String p1 = a1.getPlatform();
            String p2 = a2.getPlatform();
            if (StringUtils.isBlank((String)p1)) {
                p1 = "";
            }
            if (StringUtils.isBlank((String)p2)) {
                p2 = "";
            }
            return p1.compareTo(p2);
        };
    }

    public static Artifact of(Path resolvedPath, String platform, Map<String, Object> props) {
        Artifact artifact = new Artifact();
        artifact.path = resolvedPath.toAbsolutePath().toString();
        artifact.setPlatform(platform);
        artifact.resolvedPath = resolvedPath;
        artifact.effectivePath = resolvedPath;
        artifact.setExtraProperties(props);
        return artifact;
    }

    public static Artifact of(Path resolvedPath, Map<String, Object> props) {
        Artifact artifact = new Artifact();
        artifact.path = resolvedPath.toAbsolutePath().toString();
        artifact.resolvedPath = resolvedPath;
        artifact.effectivePath = resolvedPath;
        artifact.setExtraProperties(props);
        return artifact;
    }

    public static Artifact of(Path resolvedPath) {
        Artifact artifact = new Artifact();
        artifact.path = resolvedPath.toAbsolutePath().toString();
        artifact.resolvedPath = resolvedPath;
        artifact.effectivePath = resolvedPath;
        return artifact;
    }

    public static Artifact of(Path resolvedPath, String platform) {
        Artifact artifact = new Artifact();
        artifact.path = resolvedPath.toAbsolutePath().toString();
        artifact.setPlatform(platform);
        artifact.resolvedPath = resolvedPath;
        artifact.effectivePath = resolvedPath;
        return artifact;
    }
}

