/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.util.StringUtils;

public class VersionPattern
extends AbstractModelObject<VersionPattern> {
    private Type type = Type.SEMVER;
    private String format;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.freezeCheck();
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.freezeCheck();
        this.format = format;
    }

    public String toString() {
        String s = this.type.toString();
        switch (this.type) {
            case CALVER: 
            case CUSTOM: {
                if (!StringUtils.isNotBlank((String)this.format)) break;
                s = s + ":" + this.format;
            }
        }
        return s;
    }

    @Override
    public void merge(VersionPattern source) {
        if (source != null) {
            this.type = this.merge(this.type, source.type);
            this.format = this.merge(this.format, source.format);
        }
    }

    public static VersionPattern of(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        String[] parts = str.trim().split(":");
        VersionPattern vp = new VersionPattern();
        switch (parts.length) {
            case 1: {
                vp.setType(Type.of(parts[0]));
                break;
            }
            case 2: {
                vp.setType(Type.of(parts[0]));
                vp.setFormat(parts[1].trim());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return vp;
    }

    public static enum Type {
        SEMVER,
        CALVER,
        CHRONVER,
        JAVA_RUNTIME,
        JAVA_MODULE,
        CUSTOM;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static Type of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Type.valueOf(str.replaceAll(" ", "_").replaceAll("-", "_").toUpperCase().trim());
        }
    }
}

