/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.Templates;

public class Checksum
extends AbstractModelObject<Checksum>
implements Domain {
    public static final String KEY_SKIP_CHECKSUM = "skipChecksum";
    public static final String INDIVIDUAL_CHECKSUM = "individualChecksum";
    private final Set<Algorithm> algorithms = new LinkedHashSet<Algorithm>();
    private Boolean individual;
    private String name;
    private Boolean files;

    @Override
    public void merge(Checksum checksum) {
        this.freezeCheck();
        this.name = this.merge(this.name, checksum.name);
        this.individual = this.merge(this.individual, checksum.individual);
        this.files = this.merge(this.files, checksum.files);
        this.setAlgorithms(this.merge(this.algorithms, checksum.algorithms));
    }

    public String getResolvedName(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        context.getModel().getRelease().getGitService().fillProps(props, context.getModel());
        return Templates.resolveTemplate((String)this.name, props);
    }

    public String getResolvedName(JReleaserContext context, Algorithm algorithm) {
        String resolvedName = context.getModel().getChecksum().getResolvedName(context);
        int pos = resolvedName.lastIndexOf(".");
        resolvedName = pos != -1 ? resolvedName.substring(0, pos) + "_" + algorithm.formatted() + resolvedName.substring(pos) : resolvedName + "." + algorithm.formatted();
        return resolvedName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.freezeCheck();
        this.name = name;
    }

    public Boolean isIndividual() {
        return this.individual != null && this.individual != false;
    }

    public void setIndividual(Boolean individual) {
        this.freezeCheck();
        this.individual = individual;
    }

    public boolean isIndividualSet() {
        return this.individual != null;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.freezeWrap(this.algorithms);
    }

    public void setAlgorithms(Set<Algorithm> algorithms) {
        this.freezeCheck();
        this.algorithms.clear();
        this.algorithms.addAll(algorithms);
    }

    public Boolean isFiles() {
        return this.files == null || this.files != false;
    }

    public boolean isFilesSet() {
        return this.files != null;
    }

    public void setFiles(Boolean files) {
        this.freezeCheck();
        this.files = files;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("name", this.name);
        props.put("individual", this.isIndividual());
        props.put("algorithms", this.algorithms);
        props.put("files", this.isFiles());
        return props;
    }
}

