/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.model.Environment;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.ArchiveResolver;
import org.jreleaser.model.validation.JlinkResolver;
import org.jreleaser.model.validation.JpackageResolver;
import org.jreleaser.model.validation.NativeImageResolver;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;

public abstract class AssemblersResolver
extends Validator {
    public static void resolveAssemblers(JReleaserContext context, Errors errors) {
        Environment environment = context.getModel().getEnvironment();
        if (environment.getBooleanProperty("skipAssembleResolvers")) {
            return;
        }
        context.getLogger().debug("assemble");
        if (!environment.getBooleanProperty("skipArchiveResolver")) {
            ArchiveResolver.resolveArchiveOutputs(context, errors);
        }
        if (!environment.getBooleanProperty("skipJlinkResolver")) {
            JlinkResolver.resolveJlinkOutputs(context, errors);
        }
        if (!environment.getBooleanProperty("skipJpackageResolver")) {
            JpackageResolver.resolveJpackageOutputs(context, errors);
        }
        if (!environment.getBooleanProperty("skipNativeImageResolver")) {
            NativeImageResolver.resolveNativeImageOutputs(context, errors);
        }
    }
}

