/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Map;
import org.jreleaser.model.GitService;

public class Github
extends GitService {
    public static final String NAME = "github";
    private Boolean draft;
    private String discussionCategoryName;

    public Github() {
        super(NAME, true);
        this.setHost("github.com");
        this.setApiEndpoint("https://api.github.com");
        this.setRepoUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}");
        this.setRepoCloneUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}.git");
        this.setCommitUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/commits");
        this.setSrcUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/blob/{{repoBranch}}");
        this.setDownloadUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/download/{{tagName}}/{{artifactFile}}");
        this.setReleaseNotesUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/tag/{{tagName}}");
        this.setLatestReleaseUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/latest");
        this.setIssueTrackerUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/issues");
    }

    void setAll(Github service) {
        super.setAll(service);
        this.draft = service.draft;
        this.discussionCategoryName = service.discussionCategoryName;
    }

    public boolean isDraft() {
        return this.draft != null && this.draft != false;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public boolean isDraftSet() {
        return this.draft != null;
    }

    public String getDiscussionCategoryName() {
        return this.discussionCategoryName;
    }

    public void setDiscussionCategoryName(String discussionCategoryName) {
        this.discussionCategoryName = discussionCategoryName;
    }

    @Override
    public String getReverseRepoHost() {
        return "com.github";
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> map = super.asMap(full);
        map.put("draft", this.isDraft());
        map.put("discussionCategoryName", this.discussionCategoryName);
        return map;
    }
}

