/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.workflow;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.context.ModelValidator;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.TimeUtils;
import org.jreleaser.workflow.Workflow;
import org.jreleaser.workflow.WorkflowItem;

class WorkflowImpl
implements Workflow {
    private final JReleaserContext context;
    private final List<WorkflowItem> items = new ArrayList<WorkflowItem>();

    public WorkflowImpl(JReleaserContext context, List<WorkflowItem> items) {
        this.context = context;
        ModelValidator.validate((JReleaserContext)context);
        this.items.addAll(items);
    }

    @Override
    public void execute() {
        AtomicReference<RuntimeException> exception = new AtomicReference<RuntimeException>();
        Instant start = Instant.now();
        this.context.getLogger().info(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{this.context.isDryrun()});
        this.logFilters("workflow.included.assemblers", this.context.getIncludedAssemblers());
        this.logFilters("workflow.excluded.assemblers", this.context.getExcludedAssemblers());
        this.logFilters("workflow.included.distributions", this.context.getIncludedDistributions());
        this.logFilters("workflow.excluded.distributions", this.context.getExcludedDistributions());
        this.logFilters("workflow.included.packagers", this.context.getIncludedPackagers());
        this.logFilters("workflow.excluded.packagers", this.context.getExcludedPackagers());
        this.logFilters("workflow.included.uploader.types", this.context.getIncludedUploaderTypes());
        this.logFilters("workflow.excluded.uploader.types", this.context.getExcludedUploaderTypes());
        this.logFilters("workflow.included.uploader.names", this.context.getIncludedUploaderNames());
        this.logFilters("workflow.excluded.uploader.names", this.context.getExcludedUploaderNames());
        this.logFilters("workflow.included.announcers", this.context.getIncludedAnnouncers());
        this.logFilters("workflow.excluded.announcers", this.context.getExcludedAnnouncers());
        for (WorkflowItem item : this.items) {
            try {
                item.invoke(this.context);
            }
            catch (RuntimeException e) {
                exception.compareAndSet(null, e);
                break;
            }
        }
        Instant end = Instant.now();
        double duration = (double)Duration.between(start, end).toMillis() / 1000.0;
        this.context.getLogger().reset();
        this.context.report();
        if (null != exception.get()) {
            this.context.getLogger().error(RB.$((String)"workflow.failure", (Object[])new Object[0]), new Object[]{TimeUtils.formatDuration((double)duration)});
            this.context.getLogger().trace((Throwable)exception.get());
            throw (RuntimeException)exception.get();
        }
        this.context.getLogger().info(RB.$((String)"workflow.success", (Object[])new Object[0]), new Object[]{TimeUtils.formatDuration((double)duration)});
    }

    private void logFilters(String key, List<String> input) {
        if (!input.isEmpty()) {
            this.context.getLogger().info(RB.$((String)key, (Object[])new Object[]{input}));
        }
    }
}

