/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Parser;
import com.github.sbaudoin.yamllint.rules.LineRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class NewLines
extends LineRule {
    public static final String OPTION_TYPE = "type";

    public NewLines() {
        this.registerOption(OPTION_TYPE, Arrays.asList("unix", "dos"));
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Parser.Line line) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (line.getStart() == 0 && line.getBuffer().length() > line.getEnd()) {
            if ("dos".equals(conf.get(OPTION_TYPE))) {
                if (line.getEnd() == 0 && line.getBuffer().charAt(0) == '\n' || !"\r\n".equals(line.getBuffer().substring(line.getEnd() - 1, line.getEnd() + 1))) {
                    problems.add(new LintProblem(1, line.getEnd() - line.getStart() + 1, "wrong new line character: expected \\r\\n"));
                }
            } else if (line.getEnd() > 0 && line.getBuffer().charAt(line.getEnd() - 1) == '\r') {
                problems.add(new LintProblem(1, line.getEnd() - line.getStart(), "wrong new line character: expected \\n"));
            }
        }
        return problems;
    }
}

