/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.util;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class SdkmanHelper {
    private static final String UNIVERSAL = "UNIVERSAL";
    private static final String MAC_ARM_64 = "MAC_ARM64";
    private static final String MAC_OSX = "MAC_OSX";
    private static final String LINUX_32 = "LINUX_32";
    private static final String LINUX_64 = "LINUX_64";
    private static final String LINUX_ARM_32 = "LINUX_ARM32";
    private static final String LINUX_ARM_64 = "LINUX_ARM64";
    private static final String WINDOWS_64 = "WINDOWS_64";

    private SdkmanHelper() {
    }

    public static void collectArtifacts(JReleaserContext context, Distribution distribution, Map<String, String> platforms) {
        for (Artifact artifact : distribution.getArtifacts()) {
            if (!artifact.isActive()) continue;
            if (!artifact.getPath().endsWith(FileType.ZIP.extension())) {
                context.getLogger().debug(RB.$((String)"sdkman.no.artifacts.match", (Object[])new Object[0]), new Object[]{artifact.getEffectivePath(context, distribution).getFileName()});
                continue;
            }
            if (StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipSdkman"))) {
                context.getLogger().debug(RB.$((String)"sdkman.artifact.explicit.skip", (Object[])new Object[0]), new Object[]{artifact.getEffectivePath(context, distribution).getFileName()});
                continue;
            }
            String platform = SdkmanHelper.mapPlatform(artifact.getPlatform());
            if (StringUtils.isBlank((String)platform)) {
                context.getLogger().warn(RB.$((String)"sdkman.platform.unsupported", (Object[])new Object[0]), new Object[]{artifact.getPlatform()});
                continue;
            }
            String url = SdkmanHelper.artifactUrl(context, distribution, artifact);
            if (platforms.containsKey(platform)) {
                context.getLogger().warn(RB.$((String)"sdkman.platform.replacement", (Object[])new Object[0]), new Object[]{platform, url, platforms.get(platform)});
            }
            platforms.put(platform, url);
        }
    }

    private static String mapPlatform(String platform) {
        if (StringUtils.isBlank((String)platform)) {
            return UNIVERSAL;
        }
        if (PlatformUtils.isMac((String)platform) || platform.contains("mac")) {
            return PlatformUtils.isArm((String)platform) ? MAC_ARM_64 : MAC_OSX;
        }
        if (PlatformUtils.isWindows((String)platform)) {
            return WINDOWS_64;
        }
        if (PlatformUtils.isLinux((String)platform)) {
            if (PlatformUtils.isIntel32((String)platform)) {
                return LINUX_32;
            }
            if (PlatformUtils.isIntel64((String)platform)) {
                return LINUX_64;
            }
            if (PlatformUtils.isArm32((String)platform)) {
                return LINUX_ARM_32;
            }
            if (PlatformUtils.isArm64((String)platform)) {
                return LINUX_ARM_64;
            }
            return LINUX_32;
        }
        return null;
    }

    private static String artifactUrl(JReleaserContext context, Distribution distribution, Artifact artifact) {
        return Artifacts.resolveDownloadUrl(context, context.getModel().getAnnounce().getSdkman(), distribution, artifact);
    }
}

