/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.model.util.SdkmanHelper;
import org.jreleaser.packagers.AbstractPackagerProcessor;
import org.jreleaser.sdk.sdkman.MajorReleaseSdkmanCommand;
import org.jreleaser.sdk.sdkman.MinorReleaseSdkmanCommand;
import org.jreleaser.sdk.sdkman.SdkmanException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class SdkmanPackagerProcessor
extends AbstractPackagerProcessor<Sdkman> {
    public SdkmanPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Sdkman sdkman = distribution.getSdkman();
        LinkedHashMap platforms = new LinkedHashMap();
        SdkmanHelper.collectArtifacts((JReleaserContext)this.context, (Distribution)distribution, platforms);
        try {
            String candidate = StringUtils.isNotBlank((String)sdkman.getCandidate()) ? sdkman.getCandidate().trim() : this.context.getModel().getProject().getName();
            String releaseNotesUrl = Templates.resolveTemplate((String)sdkman.getReleaseNotesUrl(), props);
            switch (sdkman.getCommand()) {
                case MAJOR: {
                    this.context.getLogger().info(RB.$((String)"sdkman.publish.major", (Object[])new Object[0]), new Object[]{candidate});
                    ((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)MajorReleaseSdkmanCommand.builder((JReleaserLogger)this.context.getLogger()).connectTimeout(sdkman.getConnectTimeout())).readTimeout(sdkman.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).platforms(platforms).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).skipAnnounce(true)).build().execute();
                    break;
                }
                case MINOR: {
                    this.context.getLogger().info(RB.$((String)"sdkman.publish.minor", (Object[])new Object[0]), new Object[]{candidate});
                    ((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)MinorReleaseSdkmanCommand.builder((JReleaserLogger)this.context.getLogger()).connectTimeout(sdkman.getConnectTimeout())).readTimeout(sdkman.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).platforms(platforms).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).skipAnnounce(true)).build().execute();
                }
            }
            sdkman.setPublished(true);
        }
        catch (SdkmanException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        props.put("sdkmanCandidate", ((Sdkman)this.packager).getCandidate());
        props.put("sdkmanReleaseNotesUrl", Templates.resolveTemplate((String)((Sdkman)this.packager).getReleaseNotesUrl(), props));
    }
}

