/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitea;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Optional;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.releaser.spi.AbstractReleaser;
import org.jreleaser.model.releaser.spi.Asset;
import org.jreleaser.model.releaser.spi.ReleaseException;
import org.jreleaser.model.releaser.spi.Repository;
import org.jreleaser.model.releaser.spi.User;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.git.ReleaseUtils;
import org.jreleaser.sdk.gitea.Gitea;
import org.jreleaser.sdk.gitea.api.GtMilestone;
import org.jreleaser.sdk.gitea.api.GtRelease;
import org.jreleaser.sdk.gitea.api.GtRepository;
import org.jreleaser.util.StringUtils;

public class GiteaReleaser
extends AbstractReleaser {
    public GiteaReleaser(JReleaserContext context, List<Asset> assets) {
        super(context, assets);
    }

    protected void createTag() throws ReleaseException {
        ReleaseUtils.createTag((JReleaserContext)this.context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createRelease() throws ReleaseException {
        org.jreleaser.model.Gitea gitea = this.resolveGiteaFromModel();
        this.context.getLogger().info(RB.$((String)"git.releaser.releasing", (Object[])new Object[0]), new Object[]{gitea.getResolvedRepoUrl(this.context.getModel())});
        String tagName = gitea.getEffectiveTagName(this.context.getModel());
        try {
            String branch = gitea.getBranch();
            List branchNames = GitSdk.of((JReleaserContext)this.context).getRemoteBranches();
            if (!branchNames.contains(branch)) {
                throw new ReleaseException(RB.$((String)"ERROR_git_release_branch_not_exists", (Object[])new Object[]{branch, branchNames}));
            }
            String changelog = this.context.getChangelog();
            Gitea api = new Gitea(this.context.getLogger(), gitea.getApiEndpoint(), gitea.getResolvedToken(), gitea.getConnectTimeout(), gitea.getReadTimeout());
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.lookup", (Object[])new Object[0]), new Object[]{tagName, gitea.getCanonicalRepoName()});
            GtRelease release = api.findReleaseByTag(gitea.getOwner(), gitea.getName(), tagName);
            boolean snapshot = this.context.getModel().getProject().isSnapshot();
            if (null == release) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.not.found", (Object[])new Object[0]), new Object[]{tagName});
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                this.createRelease(api, tagName, changelog, snapshot);
                return;
            }
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.exists", (Object[])new Object[0]), new Object[]{tagName});
            if (gitea.isOverwrite() || snapshot) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.delete", (Object[])new Object[0]), new Object[]{tagName});
                if (!this.context.isDryrun()) {
                    api.deleteRelease(gitea.getOwner(), gitea.getName(), tagName, release.getId());
                }
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                this.createRelease(api, tagName, changelog, true);
                return;
            }
            if (gitea.isUpdate()) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.update", (Object[])new Object[0]), new Object[]{tagName});
                if (this.context.isDryrun()) return;
                GtRelease updater = new GtRelease();
                updater.setPrerelease(gitea.getPrerelease().isEnabled());
                updater.setDraft(gitea.isDraft());
                if (gitea.getUpdateSections().contains(UpdateSection.TITLE)) {
                    this.context.getLogger().info(RB.$((String)"git.releaser.release.update.title", (Object[])new Object[0]), new Object[]{gitea.getEffectiveReleaseName()});
                    updater.setName(gitea.getEffectiveReleaseName());
                }
                if (gitea.getUpdateSections().contains(UpdateSection.BODY)) {
                    this.context.getLogger().info(RB.$((String)"git.releaser.release.update.body", (Object[])new Object[0]));
                    updater.setBody(changelog);
                }
                api.updateRelease(gitea.getOwner(), gitea.getName(), release.getId(), updater);
                if (!gitea.getUpdateSections().contains(UpdateSection.ASSETS)) return;
                api.uploadAssets(gitea.getOwner(), gitea.getName(), release, this.assets);
                return;
            }
            if (this.context.isDryrun()) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                this.createRelease(api, tagName, changelog, false);
                return;
            }
            throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_cannot_release", (Object[])new Object[]{StringUtils.capitalize((String)gitea.getServiceName()), tagName}));
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace(e.getStatus() + " " + e.getReason());
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
        catch (IOException | IllegalStateException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
    }

    protected org.jreleaser.model.Gitea resolveGiteaFromModel() {
        return this.context.getModel().getRelease().getGitea();
    }

    protected Repository.Kind resolveRepositoryKind() {
        return Repository.Kind.OTHER;
    }

    public Repository maybeCreateRepository(String owner, String repo, String password) throws IOException {
        org.jreleaser.model.Gitea gitea = this.resolveGiteaFromModel();
        this.context.getLogger().debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
        Gitea api = new Gitea(this.context.getLogger(), gitea.getApiEndpoint(), password, gitea.getConnectTimeout(), gitea.getReadTimeout());
        GtRepository repository = api.findRepository(owner, repo);
        if (null == repository) {
            repository = api.createRepository(owner, repo);
        }
        return new Repository(this.resolveRepositoryKind(), owner, repo, repository.getHtmlUrl(), repository.getCloneUrl());
    }

    public Optional<User> findUser(String email, String name) {
        org.jreleaser.model.Gitea gitea = this.resolveGiteaFromModel();
        try {
            String host = gitea.getHost();
            String endpoint = gitea.getApiEndpoint();
            host = endpoint.startsWith("https") ? "https://" + host : "http://" + host;
            if (!host.endsWith("/")) {
                host = host + "/";
            }
            return new Gitea(this.context.getLogger(), gitea.getApiEndpoint(), gitea.getResolvedToken(), gitea.getConnectTimeout(), gitea.getReadTimeout()).findUser(email, name, host);
        }
        catch (IOException | RestAPIException e) {
            this.context.getLogger().trace(e);
            this.context.getLogger().debug(RB.$((String)"git.releaser.user.not.found", (Object[])new Object[0]), new Object[]{email});
            return Optional.empty();
        }
    }

    private void createRelease(Gitea api, String tagName, String changelog, boolean deleteTags) throws IOException {
        Optional<GtMilestone> milestone;
        org.jreleaser.model.Gitea gitea = this.resolveGiteaFromModel();
        if (this.context.isDryrun()) {
            for (Asset asset : this.assets) {
                if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
                this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            }
            return;
        }
        if (deleteTags) {
            this.deleteTags(api, gitea.getOwner(), gitea.getName(), tagName);
        }
        if (deleteTags || !gitea.isSkipTag()) {
            this.context.getLogger().debug(RB.$((String)"git.releaser.repository.tag", (Object[])new Object[0]), new Object[]{tagName});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true, this.context);
        }
        GtRelease release = new GtRelease();
        release.setName(gitea.getEffectiveReleaseName());
        release.setTagName(tagName);
        release.setTargetCommitish(gitea.getBranch());
        release.setBody(changelog);
        release = api.createRelease(gitea.getOwner(), gitea.getName(), release);
        api.uploadAssets(gitea.getOwner(), gitea.getName(), release, this.assets);
        if (gitea.getMilestone().isClose().booleanValue() && !this.context.getModel().getProject().isSnapshot() && (milestone = api.findMilestoneByName(gitea.getOwner(), gitea.getName(), gitea.getMilestone().getEffectiveName())).isPresent()) {
            api.closeMilestone(gitea.getOwner(), gitea.getName(), milestone.get());
        }
    }

    private void deleteTags(Gitea api, String owner, String repo, String tagName) {
        try {
            api.deleteTag(owner, repo, tagName);
        }
        catch (RestAPIException restAPIException) {
            // empty catch block
        }
    }
}

