/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Map;
import org.jreleaser.model.AbstractRepositoryTool;
import org.jreleaser.model.ChocolateyBucket;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.Env;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Chocolatey
extends AbstractRepositoryTool {
    public static final String NAME = "chocolatey";
    public static final String CHOCOLATEY_API_KEY = "CHOCOLATEY_API_KEY";
    private final ChocolateyBucket bucket = new ChocolateyBucket();
    private String username;
    private String apiKey;
    private String title;
    private Boolean remoteBuild;

    public Chocolatey() {
        super(NAME);
    }

    void setAll(Chocolatey choco) {
        super.setAll(choco);
        this.username = choco.username;
        this.apiKey = choco.apiKey;
        this.title = choco.title;
        this.remoteBuild = choco.remoteBuild;
        this.setBucket(choco.bucket);
    }

    public String getResolvedApiKey() {
        return Env.resolve((String)CHOCOLATEY_API_KEY, (String)this.apiKey);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isRemoteBuild() {
        return this.remoteBuild != null && this.remoteBuild != false;
    }

    public void setRemoteBuild(Boolean remoteBuild) {
        this.remoteBuild = remoteBuild;
    }

    public boolean isRemoteBuildSet() {
        return this.remoteBuild != null;
    }

    public ChocolateyBucket getBucket() {
        return this.bucket;
    }

    public void setBucket(ChocolateyBucket bucket) {
        this.bucket.setAll(bucket);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("username", this.username);
        props.put("apiKey", StringUtils.isNotBlank((String)this.getResolvedApiKey()) ? "************" : "**unset**");
        props.put("remoteBuild", this.isRemoteBuild());
        props.put("title", this.title);
        props.put("bucket", this.bucket.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.bucket;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isWindows((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return distribution.getType() != Distribution.DistributionType.SINGLE_JAR && distribution.getType() != Distribution.DistributionType.NATIVE_IMAGE && distribution.getType() != Distribution.DistributionType.NATIVE_PACKAGE && distribution.getType() != Distribution.DistributionType.BINARY;
    }
}

