/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.Token;

public abstract class Rule {
    private List<String> ignore = new ArrayList<String>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String level = "error";
    private Map<String, Object> options = new HashMap<String, Object>();
    private Map<String, Object> defaults = new HashMap<String, Object>();
    private Map<String, Boolean> listedOptions = new HashMap<String, Boolean>();

    public String getId() {
        return this.getClass().getName().replaceAll(".*\\.", "").replaceAll("([A-Z])", "-$1").substring(1).toLowerCase();
    }

    public void setIgnore(List<String> ignore) {
        this.ignore = ignore;
    }

    public boolean ignores(File file) {
        if (file == null) {
            return false;
        }
        for (String pattern : this.ignore) {
            if (!file.getPath().matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public Object getDefaultOptionValue(String option) {
        if (this.defaults.containsKey(option)) {
            return this.defaults.get(option);
        }
        throw new IllegalArgumentException("Unknown option: " + option);
    }

    public boolean isListOption(String option) {
        if (this.defaults.containsKey(option)) {
            return this.listedOptions.get(option);
        }
        throw new IllegalArgumentException("Unknown option: " + option);
    }

    public abstract TYPE getType();

    public String validate(Map<String, Object> conf) {
        return null;
    }

    protected LintProblem spacesAfter(Token token, Token next, @Nullable Integer min, @Nullable Integer max, String minDesc, String maxDesc) {
        int myMax;
        int myMin = min == null ? -1 : min;
        int n = myMax = max == null ? -1 : max;
        if (next != null && token.getEndMark().getLine() == next.getStartMark().getLine()) {
            int spaces = next.getStartMark().getIndex() - token.getEndMark().getIndex();
            if (myMax != -1 && spaces > myMax) {
                return new LintProblem(token.getStartMark().getLine() + 1, next.getStartMark().getColumn(), maxDesc);
            }
            if (myMin != -1 && spaces < myMin) {
                return new LintProblem(token.getStartMark().getLine() + 1, next.getStartMark().getColumn() + 1, minDesc);
            }
        }
        return null;
    }

    protected LintProblem spacesBefore(Token token, Token prev, @Nullable Integer min, @Nullable Integer max, String minDesc, String maxDesc) {
        int myMax;
        int myMin = min == null ? -1 : min;
        int n = myMax = max == null ? -1 : max;
        if (prev != null && prev.getEndMark().getLine() == token.getStartMark().getLine() && (prev.getEndMark().getPointer() == 0 || prev.getEndMark().getBuffer()[prev.getEndMark().getPointer() - 1] != 10)) {
            int spaces = token.getStartMark().getPointer() - prev.getEndMark().getPointer();
            if (myMax != -1 && spaces > myMax) {
                return new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn(), maxDesc);
            }
            if (myMin != -1 && spaces < myMin) {
                return new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, minDesc);
            }
        }
        return null;
    }

    protected boolean isExplicitKey(Token token) {
        return token.getStartMark().getPointer() < token.getEndMark().getPointer() && token.getStartMark().getBuffer()[token.getStartMark().getPointer()] == 63;
    }

    protected int getLineIndent(Token token) {
        int start;
        int content = start = this.rfind(token.getStartMark().getBuffer(), 10, 0, token.getStartMark().getPointer()) + 1;
        while (token.getStartMark().getBuffer()[content] == 32) {
            ++content;
        }
        return content - start;
    }

    protected boolean isWhitespace(int i) {
        return Arrays.binarySearch(new int[]{9, 10, 11, 12, 13, 32}, i) >= 0;
    }

    protected int find(int[] haystack, int needle, int start, int end) {
        if (start > haystack.length - 1 || end > haystack.length || start < 0 || end < 0) {
            throw new ArrayIndexOutOfBoundsException("start or end index beyond the array boundaries");
        }
        for (int i = start; i < end; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    protected int rfind(int[] haystack, int needle, int start, int end) {
        if (start > haystack.length - 1 || end > haystack.length || start < 0 || end < 0) {
            throw new ArrayIndexOutOfBoundsException("start or end index beyond the array boundaries");
        }
        for (int i = end - 1; i >= start; --i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    protected int getRealEndLine(Token token) {
        int endLine = token.getEndMark().getLine() + 1;
        if (!(token instanceof ScalarToken)) {
            return endLine;
        }
        for (int pos = token.getEndMark().getPointer() - 1; pos >= token.getStartMark().getPointer() - 1 && this.isWhitespace(token.getEndMark().getBuffer()[pos]); --pos) {
            if (token.getEndMark().getBuffer()[pos] != 10) continue;
            --endLine;
        }
        return endLine;
    }

    protected boolean isDigit(String str) {
        if (str == null || "".equals(str)) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void registerOption(String name, Object value) {
        if (value instanceof List) {
            if (((List)value).isEmpty()) throw new IllegalArgumentException("Empty list passed, you must explicitly specify a default value");
            this.registerOption(name, value, ((List)value).get(0));
            return;
        } else {
            this.registerOption(name, value, value);
        }
    }

    protected void registerOption(String name, Object type, Object defaultValue) {
        this.options.put(name, type);
        this.defaults.put(name, defaultValue);
        this.listedOptions.put(name, false);
    }

    protected void registerListOption(String name, List<?> value) {
        this.registerListOption(name, value, value);
    }

    protected void registerListOption(String name, List<?> type, List<?> defaultValue) {
        this.options.put(name, type);
        this.defaults.put(name, defaultValue);
        this.listedOptions.put(name, true);
    }

    public static enum TYPE {
        TOKEN,
        COMMENT,
        LINE;

    }
}

