/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.LinkedHashSet;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.Set;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.HaltExecutionException;
import org.jreleaser.cli.Main;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.JReleaserLogger;
import picocli.CommandLine;

@CommandLine.Command(name="init")
public class Init
extends AbstractCommand {
    @CommandLine.Option(names={"-o", "--overwrite"})
    boolean overwrite;
    @CommandLine.Option(names={"-f", "--format"})
    String format;
    @CommandLine.ParentCommand
    Main parent;
    private Path outputDirectory;

    @Override
    protected Main parent() {
        return this.parent;
    }

    @Override
    protected void execute() {
        try {
            this.outputDirectory = null != this.basedir ? this.basedir : Paths.get(".", new String[0]).normalize();
            this.initLogger();
            if (!this.getSupportedConfigFormats().contains(this.format)) {
                this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(this.$("jreleaser.init.ERROR_invalid_format", String.join((CharSequence)"|", this.getSupportedConfigFormats()))));
                this.spec.commandLine().usage(this.parent.out);
                throw new HaltExecutionException();
            }
            Path outputFile = this.outputDirectory.resolve("jreleaser." + this.format);
            Reader template = TemplateUtils.resolveTemplate((JReleaserLogger)this.logger, (String)("jreleaser." + this.format + ".tpl"));
            StringWriter sw = new StringWriter();
            try (Scanner scanner = new Scanner(template);){
                while (scanner.hasNextLine()) {
                    sw.write(scanner.nextLine() + System.lineSeparator());
                }
            }
            String content = sw.toString();
            LocalDate now = LocalDate.now();
            content = content.replaceAll("@year@", now.getYear() + "");
            this.logger.info(this.$("jreleaser.init.TEXT_writing_file", new Object[0]), new Object[]{outputFile.toAbsolutePath()});
            try {
                Files.write(outputFile, content.getBytes(), this.overwrite ? StandardOpenOption.CREATE : StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (FileAlreadyExistsException e) {
                this.logger.error(this.$("jreleaser.init.ERROR_file_exists", new Object[0]), new Object[]{outputFile.toAbsolutePath()});
                return;
            }
            if (!this.quiet) {
                this.logger.info(this.$("jreleaser.init.TEXT_success", new Object[0]), new Object[]{this.outputDirectory.toAbsolutePath()});
            }
        }
        catch (IOException | IllegalStateException e) {
            throw new JReleaserException(this.$("ERROR_unexpected_error", new Object[0]), (Throwable)e);
        }
    }

    private Set<String> getSupportedConfigFormats() {
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            extensions.add(parser.getPreferredFileExtension());
        }
        return extensions;
    }

    @Override
    protected Path getOutputDirectory() {
        return this.outputDirectory;
    }
}

