/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryTool;
import org.jreleaser.model.Plug;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.model.Slot;
import org.jreleaser.model.SnapTap;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Snap
extends AbstractRepositoryTool {
    public static final String NAME = "snap";
    private final Set<String> localPlugs = new LinkedHashSet<String>();
    private final Set<String> localSlots = new LinkedHashSet<String>();
    private final List<Plug> plugs = new ArrayList<Plug>();
    private final List<Slot> slots = new ArrayList<Slot>();
    private final SnapTap snap = new SnapTap();
    private String base = "core20";
    private String grade = "stable";
    private String confinement = "strict";
    private String exportedLogin;
    private Boolean remoteBuild;

    public Snap() {
        super(NAME);
    }

    @Override
    public Set<String> getSupportedExtensions() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(".tar.gz");
        set.add(".tgz");
        set.add(".tar");
        return set;
    }

    void setAll(Snap snap) {
        super.setAll(snap);
        this.base = snap.base;
        this.grade = snap.grade;
        this.confinement = snap.confinement;
        this.exportedLogin = snap.exportedLogin;
        this.remoteBuild = snap.remoteBuild;
        this.setLocalPlugs(snap.localPlugs);
        this.setLocalSlots(snap.localSlots);
        this.setPlugs(snap.plugs);
        this.setSlots(snap.slots);
        this.setSnap(snap.snap);
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public String getConfinement() {
        return this.confinement;
    }

    public void setConfinement(String confinement) {
        this.confinement = confinement;
    }

    public Set<String> getLocalPlugs() {
        return this.localPlugs;
    }

    public void setLocalPlugs(Set<String> localPlugs) {
        this.localPlugs.clear();
        this.localPlugs.addAll(localPlugs);
    }

    public void addLocalPlugs(Set<String> localPlugs) {
        this.localPlugs.addAll(localPlugs);
    }

    public void addLocalPlug(String localPlug) {
        if (StringUtils.isNotBlank((String)localPlug)) {
            this.localPlugs.add(localPlug.trim());
        }
    }

    public void removeLocalPlug(String localPlug) {
        if (StringUtils.isNotBlank((String)localPlug)) {
            this.localPlugs.remove(localPlug.trim());
        }
    }

    public Set<String> getLocalSlots() {
        return this.localSlots;
    }

    public void setLocalSlots(Set<String> localSlots) {
        this.localSlots.clear();
        this.localSlots.addAll(localSlots);
    }

    public void addLocalSlots(Set<String> localSlots) {
        this.localSlots.addAll(localSlots);
    }

    public void addLocalSlot(String localSlot) {
        if (StringUtils.isNotBlank((String)localSlot)) {
            this.localSlots.add(localSlot.trim());
        }
    }

    public void removeLocalSlot(String localSlot) {
        if (StringUtils.isNotBlank((String)localSlot)) {
            this.localSlots.remove(localSlot.trim());
        }
    }

    public List<Plug> getPlugs() {
        return this.plugs;
    }

    public void setPlugs(List<Plug> plugs) {
        this.plugs.clear();
        this.plugs.addAll(plugs);
    }

    public void addPlugs(List<Plug> plugs) {
        this.plugs.addAll(plugs);
    }

    public void addPlug(Plug plug) {
        if (null != plug) {
            this.plugs.add(plug);
        }
    }

    public void removePlug(Plug plug) {
        if (null != plug) {
            this.plugs.remove(plug);
        }
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public void setSlots(List<Slot> slots) {
        this.slots.clear();
        this.slots.addAll(slots);
    }

    public void addSlots(List<Slot> slots) {
        this.slots.addAll(slots);
    }

    public void addSlot(Slot slot) {
        if (null != slot) {
            this.slots.add(slot);
        }
    }

    public void removeSlot(Slot slot) {
        if (null != slot) {
            this.slots.remove(slot);
        }
    }

    public String getExportedLogin() {
        return this.exportedLogin;
    }

    public void setExportedLogin(String exportedLogin) {
        this.exportedLogin = exportedLogin;
    }

    public boolean isRemoteBuild() {
        return this.remoteBuild != null && this.remoteBuild != false;
    }

    public void setRemoteBuild(Boolean remoteBuild) {
        this.remoteBuild = remoteBuild;
    }

    public boolean isRemoteBuildSet() {
        return this.remoteBuild != null;
    }

    public SnapTap getSnap() {
        return this.snap;
    }

    public void setSnap(SnapTap snap) {
        this.snap.setAll(snap);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("base", this.base);
        props.put("grade", this.grade);
        props.put("confinement", this.confinement);
        props.put("exportedLogin", this.exportedLogin);
        props.put("remoteBuild", this.isRemoteBuild());
        props.put(NAME, this.snap.asMap(full));
        props.put("localPlugs", this.localPlugs);
        props.put("localSlots", this.localSlots);
        props.put("plugs", this.plugs);
        props.put("slots", this.slots);
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.snap;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isUnix((String)platform);
    }
}

