/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.CustomPropertyDefinition;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SubtypeResolver;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonSubTypesResolver
implements SubtypeResolver,
CustomDefinitionProviderV2 {
    public List<ResolvedType> findSubtypes(ResolvedType declaredType, SchemaGenerationContext context) {
        JsonSubTypes subtypesAnnotation = declaredType.getErasedType().getAnnotation(JsonSubTypes.class);
        return this.lookUpSubtypesFromAnnotation(declaredType, subtypesAnnotation, context.getTypeContext());
    }

    public List<ResolvedType> findTargetTypeOverrides(MemberScope<?, ?> property) {
        if (property.getType() == null) {
            return null;
        }
        JsonSubTypes subtypesAnnotation = (JsonSubTypes)property.getAnnotationConsideringFieldAndGetter(JsonSubTypes.class);
        return this.lookUpSubtypesFromAnnotation(property.getType(), subtypesAnnotation, property.getContext());
    }

    public List<ResolvedType> lookUpSubtypesFromAnnotation(ResolvedType declaredType, JsonSubTypes subtypesAnnotation, TypeContext context) {
        if (subtypesAnnotation == null) {
            return null;
        }
        return Stream.of(subtypesAnnotation.value()).map(entry -> this.resolveSubtype(declaredType, (JsonSubTypes.Type)entry, context)).collect(Collectors.toList());
    }

    private ResolvedType resolveSubtype(ResolvedType declaredType, JsonSubTypes.Type annotatedSubtype, TypeContext context) {
        try {
            return context.resolveSubtype(declaredType, annotatedSubtype.value());
        }
        catch (IllegalArgumentException ex) {
            return context.resolve((Type)annotatedSubtype.value(), new Type[0]);
        }
    }

    public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
        JsonTypeInfo typeInfoAnnotation;
        Class targetSuperType = javaType.getErasedType();
        do {
            if ((typeInfoAnnotation = targetSuperType.getAnnotation(JsonTypeInfo.class)) == null) {
                typeInfoAnnotation = Stream.of(targetSuperType.getInterfaces()).map(superInterface -> superInterface.getAnnotation(JsonTypeInfo.class)).filter(Objects::nonNull).findFirst().orElse(null);
            }
            targetSuperType = targetSuperType.getSuperclass();
        } while (typeInfoAnnotation == null && targetSuperType != null);
        if (typeInfoAnnotation == null || javaType.getErasedType().getDeclaredAnnotation(JsonSubTypes.class) != null) {
            return null;
        }
        ObjectNode definition = this.createSubtypeDefinition(javaType, typeInfoAnnotation, null, context);
        if (definition == null) {
            return null;
        }
        return new CustomDefinition(definition, CustomDefinition.DefinitionType.STANDARD, CustomDefinition.AttributeInclusion.NO);
    }

    public CustomPropertyDefinition provideCustomPropertySchemaDefinition(MemberScope<?, ?> scope, SchemaGenerationContext context) {
        JsonTypeInfo typeInfoAnnotation = (JsonTypeInfo)scope.getAnnotationConsideringFieldAndGetter(JsonTypeInfo.class);
        if (typeInfoAnnotation == null || scope.getType().getErasedType().getDeclaredAnnotation(JsonSubTypes.class) != null) {
            return null;
        }
        Object attributes = scope instanceof FieldScope ? AttributeCollector.collectFieldAttributes((FieldScope)((FieldScope)scope), (SchemaGenerationContext)context) : (scope instanceof MethodScope ? AttributeCollector.collectMethodAttributes((MethodScope)((MethodScope)scope), (SchemaGenerationContext)context) : null);
        ObjectNode definition = this.createSubtypeDefinition(scope.getType(), typeInfoAnnotation, (ObjectNode)attributes, context);
        if (definition == null) {
            return null;
        }
        return new CustomPropertyDefinition(definition, CustomDefinition.AttributeInclusion.NO);
    }

    private String getTypeIdentifier(ResolvedType javaType, JsonTypeInfo typeInfoAnnotation) {
        String typeIdentifier;
        Class erasedTargetType = javaType.getErasedType();
        switch (typeInfoAnnotation.use()) {
            case NAME: {
                typeIdentifier = Optional.ofNullable(erasedTargetType.getAnnotation(JsonTypeName.class)).map(JsonTypeName::value).filter(name -> !name.isEmpty()).orElseGet(() -> JsonSubTypesResolver.getUnqualifiedClassName(erasedTargetType));
                break;
            }
            case CLASS: {
                typeIdentifier = erasedTargetType.getName();
                break;
            }
            default: {
                typeIdentifier = null;
            }
        }
        return typeIdentifier;
    }

    private static String getUnqualifiedClassName(Class<?> erasedTargetType) {
        Class<?> declaringClass = erasedTargetType.getDeclaringClass();
        if (declaringClass == null) {
            return erasedTargetType.getSimpleName();
        }
        return JsonSubTypesResolver.getUnqualifiedClassName(declaringClass) + '$' + erasedTargetType.getSimpleName();
    }

    private ObjectNode createSubtypeDefinition(ResolvedType javaType, JsonTypeInfo typeInfoAnnotation, ObjectNode attributesToInclude, SchemaGenerationContext context) {
        String typeIdentifier = this.getTypeIdentifier(javaType, typeInfoAnnotation);
        if (typeIdentifier == null) {
            return null;
        }
        ObjectNode definition = context.getGeneratorConfig().createObjectNode();
        switch (typeInfoAnnotation.include()) {
            case WRAPPER_ARRAY: {
                definition.put(context.getKeyword(SchemaKeyword.TAG_TYPE), context.getKeyword(SchemaKeyword.TAG_TYPE_ARRAY));
                ArrayNode itemsArray = definition.withArray(context.getKeyword(SchemaKeyword.TAG_ITEMS));
                itemsArray.addObject().put(context.getKeyword(SchemaKeyword.TAG_TYPE), context.getKeyword(SchemaKeyword.TAG_TYPE_STRING)).put(context.getKeyword(SchemaKeyword.TAG_CONST), typeIdentifier);
                if (attributesToInclude == null || attributesToInclude.isEmpty()) {
                    itemsArray.add((JsonNode)context.createStandardDefinitionReference(javaType, (CustomDefinitionProviderV2)this));
                    break;
                }
                itemsArray.addObject().withArray(context.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)context.createStandardDefinitionReference(javaType, (CustomDefinitionProviderV2)this)).add((JsonNode)attributesToInclude);
                break;
            }
            case WRAPPER_OBJECT: {
                definition.put(context.getKeyword(SchemaKeyword.TAG_TYPE), context.getKeyword(SchemaKeyword.TAG_TYPE_OBJECT));
                ObjectNode propertiesNode = definition.with(context.getKeyword(SchemaKeyword.TAG_PROPERTIES));
                if (attributesToInclude == null || attributesToInclude.isEmpty()) {
                    propertiesNode.set(typeIdentifier, (JsonNode)context.createStandardDefinitionReference(javaType, (CustomDefinitionProviderV2)this));
                    break;
                }
                propertiesNode.with(typeIdentifier).withArray(context.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)context.createStandardDefinitionReference(javaType, (CustomDefinitionProviderV2)this)).add((JsonNode)attributesToInclude);
                break;
            }
            case PROPERTY: 
            case EXISTING_PROPERTY: {
                String propertyName = Optional.ofNullable(typeInfoAnnotation.property()).filter(name -> !name.isEmpty()).orElseGet(() -> typeInfoAnnotation.use().getDefaultPropertyName());
                ObjectNode additionalPart = definition.withArray(context.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)context.createStandardDefinitionReference(javaType, (CustomDefinitionProviderV2)this)).addObject();
                if (attributesToInclude != null && !attributesToInclude.isEmpty()) {
                    additionalPart.setAll(attributesToInclude);
                }
                additionalPart.put(context.getKeyword(SchemaKeyword.TAG_TYPE), context.getKeyword(SchemaKeyword.TAG_TYPE_OBJECT)).with(context.getKeyword(SchemaKeyword.TAG_PROPERTIES)).with(propertyName).put(context.getKeyword(SchemaKeyword.TAG_CONST), typeIdentifier);
                break;
            }
            default: {
                return null;
            }
        }
        return definition;
    }
}

