/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.jmolpanel.JmolPanel;

class RecentFilesDialog
extends JDialog
implements ActionListener,
WindowListener {
    String selectedFileName = null;
    private static final int MAX_FILES = 10;
    private JButton okButton;
    private JButton cancelButton;
    private JButton clearButton;
    String[] files = new String[10];
    JList<String> fileList;
    Properties props = new Properties();

    public RecentFilesDialog(Frame frame) {
        super(frame, GT.$("Recent Files"), true);
        this.getFiles();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.okButton = this.addButton(jPanel, GT.$("Open"));
        this.cancelButton = this.addButton(jPanel, GT.$("Cancel"));
        this.clearButton = this.addButton(jPanel, GT.$("Clear"));
        this.getContentPane().add("South", jPanel);
        this.fileList = new JList<String>(this.files);
        this.fileList.setSelectedIndex(0);
        this.fileList.setSelectionMode(0);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = RecentFilesDialog.this.fileList.locationToIndex(mouseEvent.getPoint())) >= 0 && n < RecentFilesDialog.this.files.length && RecentFilesDialog.this.files[n] != null) {
                    RecentFilesDialog.this.selectedFileName = RecentFilesDialog.this.files[n];
                    RecentFilesDialog.this.close();
                }
            }
        };
        this.fileList.addMouseListener(mouseAdapter);
        this.getContentPane().add("Center", this.fileList);
        this.setLocation(100, 100);
        this.pack();
    }

    private JButton addButton(JPanel jPanel, String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jPanel.add(jButton);
        return jButton;
    }

    private void getFiles() {
        this.props = JmolPanel.historyFile.getProperties();
        int n = 0;
        while (n < 10) {
            this.files[n] = this.props.getProperty("recentFilesFile" + n);
            ++n;
        }
    }

    public void addFile(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < 10) {
            if (string.equals(this.files[n2])) {
                n = n2;
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        if (n > 0) {
            n2 = n;
            while (n2 < 9) {
                this.files[n2] = this.files[n2 + 1];
                ++n2;
            }
        }
        n2 = 8;
        while (n2 >= 0) {
            this.files[n2 + 1] = this.files[n2];
            --n2;
        }
        this.files[0] = string;
        this.fileList.setListData((String[])this.files);
        this.fileList.setSelectedIndex(0);
        this.pack();
        this.saveList();
    }

    public void saveList() {
        int n = 0;
        while (n < 10) {
            if (this.files[n] != null) {
                this.props.setProperty("recentFilesFile" + n, this.files[n]);
            }
            ++n;
        }
        JmolPanel.historyFile.addProperties(this.props);
    }

    public String getFile() {
        return this.selectedFileName;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.cancel();
        this.close();
    }

    void cancel() {
        this.selectedFileName = null;
    }

    void clear() {
        this.files = new String[10];
        this.fileList.setListData((String[])this.files);
        int n = 0;
        while (n < 10) {
            this.props.setProperty("recentFilesFile" + n, "");
            ++n;
        }
        JmolPanel.historyFile.addProperties(this.props);
        this.cancel();
    }

    void close() {
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            int n = this.fileList.getSelectedIndex();
            if (n < this.files.length) {
                this.selectedFileName = this.files[n];
                this.close();
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancel();
            this.close();
        } else if (actionEvent.getSource() == this.clearButton) {
            this.clear();
            this.close();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void notifyFileOpen(String string) {
        if (string != null && !string.equals("Jmol Model Kit")) {
            this.addFile(string);
        }
    }
}

