/*
 * Decompiled with CFR 0.152.
 */
package org.molecularplayground;

import java.awt.Dimension;
import java.awt.Graphics;
import javajs.util.PT;
import javax.swing.JPanel;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolViewer;
import org.jmol.c.CBK;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.jsonkiosk.BannerFrame;
import org.openscience.jmol.app.jsonkiosk.JsonNioClient;
import org.openscience.jmol.app.jsonkiosk.JsonNioServer;
import org.openscience.jmol.app.jsonkiosk.JsonNioService;
import org.openscience.jmol.app.jsonkiosk.KioskFrame;

public class MPJmolApp
implements JsonNioClient {
    protected Viewer viewer;
    private static int MP_VERSION = 1;
    protected JsonNioServer service;
    private BannerFrame bannerFrame;
    private KioskFrame kioskFrame;
    private boolean contentDisabled;
    private boolean haveStarted = false;

    public static void main(String[] stringArray) {
        new MPJmolApp(stringArray.length > 0 ? Integer.parseInt(stringArray[0]) : 31416);
    }

    public MPJmolApp() {
        this(31416);
    }

    public MPJmolApp(int n) {
        this.startJsonNioKiosk(n);
    }

    private void startJsonNioKiosk(int n) {
        KioskPanel kioskPanel = new KioskPanel();
        this.bannerFrame = new BannerFrame(1024, 75);
        this.kioskFrame = new KioskFrame(0, 75, 1024, 693, kioskPanel);
        try {
            String string;
            this.setBannerLabel("click below and type exitJmol[enter] to quit");
            String string2 = "set allowgestures;set allowKeyStrokes;set zoomLarge false;set frank off;set antialiasdisplay off;";
            String string3 = "cd \"\"; " + this.viewer.getFileAsString3("MPJmolAppConfig.spt", false, null) + ";";
            Logger.info("startJsonNioKiosk on port " + n);
            Logger.info(string3);
            if (string3.indexOf("java.io") >= 0) {
                string3 = "";
            }
            if ((string = PT.rep(string3.toLowerCase(), " ", "")).indexOf("niocontentpath=") < 0) {
                String string4 = String.valueOf(System.getProperty("user.dir").replace('\\', '/')) + "/Content-Cache/%ID%/%ID%.json";
                string3 = String.valueOf(string3) + "NIOcontentPath=\"" + string4 + "\";";
            }
            if (string.indexOf("nioterminatormessage=") < 0) {
                string3 = String.valueOf(string3) + "NIOterminatorMessage='MP_DONE';";
            }
            if (string.indexOf("nioresetmessage=") < 0) {
                string3 = String.valueOf(string3) + "NIOresetMessage='MP_RESET';";
            }
            if (string.indexOf("niobannerenabled=") < 0) {
                string3 = String.valueOf(string3) + "NIObannerEnabled=true;";
            }
            string3 = string.indexOf("niocontentscript=") >= 0 ? String.valueOf(string3) + "NIOcontentDisabled=true;" : String.valueOf(string3) + "NIOcontentScript='';NIOcontentDisabled=false;";
            if (string.indexOf("niomotiondisabled=") < 0) {
                string3 = String.valueOf(string3) + "NIOmotionDisabled=false;";
            }
            Logger.info("startJsonNioKiosk: " + string2 + string3);
            this.viewer.scriptWait(String.valueOf(string2) + string3);
            this.contentDisabled = JsonNioService.getJmolValueAsString(this.viewer, "NIOcontentDisabled").equals("true");
            Logger.info("startJsonNioKiosk: contentDisabled=" + this.contentDisabled);
            this.service = JmolPanel.getJsonNioServer();
            if (this.service == null) {
                Logger.info("Cannot start JsonNioServer");
                System.exit(1);
            }
            this.service.startService(n, this, this.viewer, "-MP", MP_VERSION);
            this.viewer.script("load $caffeine");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.service == null) {
                this.nioClosed(null);
            }
            this.service.close();
        }
    }

    @Override
    public synchronized void nioRunContent(JsonNioServer jsonNioServer) {
        if (this.contentDisabled && (jsonNioServer == null || !this.haveStarted)) {
            String string = jsonNioServer == null ? "; message testing nioRun2; cd \"\"; script \"" + JsonNioService.getJmolValueAsString(this.viewer, "NIOcontentScript") + "\"" : "";
            this.haveStarted = true;
            string = String.valueOf(string) + ";cd \"\";cd;script \"" + JsonNioService.getJmolValueAsString(this.viewer, "NIOcontentScript") + "\"";
            System.out.println("nioRunContent " + Thread.currentThread() + " " + string);
            this.viewer.script(string);
            System.out.println("nioRunContent done");
        }
    }

    @Override
    public void setBannerLabel(String string) {
        this.bannerFrame.setLabel(string);
    }

    @Override
    public void nioClosed(JsonNioServer jsonNioServer) {
        try {
            this.viewer.dispose();
            this.bannerFrame.dispose();
            this.kioskFrame.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(0);
    }

    class KioskPanel
    extends JPanel
    implements JmolCallbackListener {
        private final Dimension currentSize = new Dimension();

        KioskPanel() {
            MPJmolApp.this.viewer = (Viewer)JmolViewer.allocateViewer(this, new SmarterJmolAdapter(), null, null, null, "", null);
            MPJmolApp.this.viewer.setJmolCallbackListener(this);
            MPJmolApp.this.viewer.setBooleanProperty("isKiosk", true);
        }

        @Override
        public void paint(Graphics graphics) {
            this.getSize(this.currentSize);
            MPJmolApp.this.viewer.renderScreenImage((Object)graphics, this.currentSize.width, this.currentSize.height);
        }

        @Override
        public boolean notifyEnabled(CBK cBK) {
            switch (cBK) {
                case ECHO: 
                case MESSAGE: 
                case SCRIPT: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void notifyCallback(CBK cBK, Object[] objectArray) {
            if (MPJmolApp.this.service == null || MPJmolApp.this.viewer == null) {
                return;
            }
            String string = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
            switch (cBK) {
                case ECHO: 
                case MESSAGE: 
                case SCRIPT: {
                    MPJmolApp.this.service.scriptCallback(string);
                    JmolCallbackListener jmolCallbackListener = (JmolCallbackListener)MPJmolApp.this.viewer.getProperty("DATA_API", "getAppConsole", null);
                    if (jmolCallbackListener == null) break;
                    jmolCallbackListener.notifyCallback(cBK, objectArray);
                    break;
                }
            }
        }

        @Override
        public void setCallbackFunction(String string, String string2) {
        }
    }
}

