/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.symmetry.CIPChirality;
import org.jmol.symmetry.CIPData;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Node;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.Viewer;

public class CIPDataSmiles
extends CIPData {
    String smiles = null;
    private Node[] nodes = new Node[6];

    @Override
    boolean isSmiles() {
        return true;
    }

    public CIPDataSmiles setAtomsForSmiles(Viewer viewer, String string) throws Exception {
        this.vwr = viewer;
        this.smiles = string;
        this.atoms = viewer.getSmilesAtoms(string);
        this.bsAtoms = BSUtil.newBitSet2(0, this.atoms.length);
        this.bsMolecule = (BS)this.bsAtoms.clone();
        this.init();
        return this;
    }

    @Override
    protected BS[] getList(String string) throws Exception {
        return this.vwr.getSubstructureSetArrayForNodes(string, (Node[])this.atoms, 2);
    }

    @Override
    protected BS match(String string) throws Exception {
        return this.vwr.getSmartsMatchForNodes(string, (Node[])this.atoms);
    }

    @Override
    int getBondOrder(SimpleEdge simpleEdge) {
        return ((SmilesBond)simpleEdge).getRealCovalentOrder();
    }

    @Override
    int isCis(CIPChirality.CIPAtom cIPAtom, CIPChirality.CIPAtom cIPAtom2, CIPChirality.CIPAtom cIPAtom3, CIPChirality.CIPAtom cIPAtom4) {
        int n = this.getStereoEdge(cIPAtom2.atom, cIPAtom.atom);
        int n2 = this.getStereoEdge(cIPAtom3.atom, cIPAtom4.atom);
        return n == 0 || n2 == 0 ? 0 : (n != n2 ? 14 : 13);
    }

    private int getStereoEdge(SimpleNode simpleNode, SimpleNode simpleNode2) {
        SimpleEdge[] simpleEdgeArray = simpleNode.getEdges();
        int n = 0;
        int n2 = simpleEdgeArray.length;
        while (--n2 >= 0) {
            SmilesBond smilesBond = (SmilesBond)simpleEdgeArray[n2];
            n = smilesBond.getCovalentOrder();
            switch (n) {
                case 1025: {
                    return smilesBond.getOtherNode(simpleNode) == simpleNode2 == (smilesBond.getAtom1() == simpleNode) ? 1041 : n;
                }
                case 1041: {
                    return simpleEdgeArray[n2].getOtherNode(simpleNode) == simpleNode2 == (smilesBond.getAtom1() == simpleNode) ? 1025 : n;
                }
            }
        }
        return 0;
    }

    @Override
    int isPositiveTorsion(CIPChirality.CIPAtom cIPAtom, CIPChirality.CIPAtom cIPAtom2, CIPChirality.CIPAtom cIPAtom3, CIPChirality.CIPAtom cIPAtom4) {
        SmilesAtom smilesAtom = this.findCumulativeCenter(cIPAtom2, cIPAtom3);
        if (smilesAtom == null) {
            return 0;
        }
        Node[] nodeArray = smilesAtom.stereo.getAlleneAtoms(smilesAtom, (SmilesAtom)cIPAtom2.atom);
        if (nodeArray == null) {
            return 0;
        }
        smilesAtom.stereo.setTopoCoordinates(smilesAtom, null, null, nodeArray);
        float f = Measure.computeTorsion(nodeArray[0].getXYZ(), nodeArray[1].getXYZ(), nodeArray[2].getXYZ(), nodeArray[3].getXYZ(), true);
        return f > 0.0f == (cIPAtom.atom.getIndex() == nodeArray[0].getIndex() && cIPAtom4.atom.getIndex() == nodeArray[3].getIndex() || cIPAtom.atom.getIndex() == nodeArray[1].getIndex() && cIPAtom4.atom.getIndex() == nodeArray[2].getIndex()) ? 18 : 17;
    }

    private SmilesAtom findCumulativeCenter(CIPChirality.CIPAtom cIPAtom, CIPChirality.CIPAtom cIPAtom2) {
        SimpleNode simpleNode = cIPAtom.atom;
        SimpleNode simpleNode2 = null;
        SimpleNode simpleNode3 = null;
        while (simpleNode != null && simpleNode != cIPAtom2.atom) {
            SimpleEdge[] simpleEdgeArray = simpleNode.getEdges();
            int n = simpleEdgeArray.length;
            while (--n >= 0) {
                if (simpleEdgeArray[n].getCovalentOrder() != 2 || (simpleNode2 = simpleEdgeArray[n].getOtherNode(simpleNode)) == simpleNode3) continue;
                SmilesAtom smilesAtom = (SmilesAtom)simpleNode2;
                if (smilesAtom.stereo == null) continue;
                return smilesAtom;
            }
            simpleNode3 = simpleNode;
            simpleNode = simpleNode2;
        }
        return null;
    }

    @Override
    boolean setCoord(SimpleNode simpleNode, CIPChirality.CIPAtom[] cIPAtomArray) {
        SmilesAtom smilesAtom = (SmilesAtom)simpleNode;
        if (smilesAtom.stereo == null) {
            return false;
        }
        Edge[] edgeArray = smilesAtom.getEdges();
        int n = edgeArray.length;
        while (--n >= 0) {
            this.nodes[n] = (Node)edgeArray[n].getOtherNode(smilesAtom);
        }
        smilesAtom.stereo.setTopoCoordinates(smilesAtom, null, null, this.nodes);
        return true;
    }

    public String[] getSmilesChiralityArray() {
        Lst<String> lst = new Lst<String>();
        int n = 0;
        while (n < this.atoms.length) {
            SmilesAtom smilesAtom = (SmilesAtom)this.atoms[n];
            int n2 = smilesAtom.getPatternIndex();
            if (n2 >= 0) {
                String string = smilesAtom.getCIPChirality(false);
                lst.addLast(string);
            }
            ++n;
        }
        return lst.toArray(new String[lst.size()]);
    }
}

