/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.Atom;
import org.jmol.util.C;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public abstract class ___Exporter {
    protected boolean solidOnly;
    protected Viewer vwr;
    protected TransformManager tm;
    protected double privateKey;
    protected JmolRendererInterface export3D;
    protected OC out;
    protected String fileName;
    protected String commandLineOptions;
    protected GData gdata;
    protected short backgroundColix;
    protected int screenWidth;
    protected int screenHeight;
    protected int slabZ;
    protected int depthZ;
    protected V3 lightSource;
    protected P3 fixedRotationCenter;
    protected P3 referenceCenter;
    protected P3 cameraPosition;
    protected float cameraDistance;
    protected float apertureAngle;
    protected float scalePixelsPerAngstrom;
    protected float exportScale = 1.0f;
    int exportType;
    protected static final float degreesPerRadian = 57.29578f;
    protected final P3 tempP1 = new P3();
    protected final P3 tempP2 = new P3();
    protected final P3 tempP3 = new P3();
    protected final P3 center = new P3();
    protected final V3 tempV1 = new V3();
    protected final V3 tempV2 = new V3();
    private boolean isWebGL;
    protected String commentChar;
    private final P3 tempC = new P3();
    private int nText;
    private int nImage;
    public short lineWidthMad;

    boolean initializeOutput(Viewer viewer, double d, GData gData, Map<String, Object> map) {
        return this.initOutput(viewer, d, gData, map);
    }

    protected boolean initOutput(Viewer viewer, double d, GData gData, Map<String, Object> map) {
        this.vwr = viewer;
        this.tm = viewer.tm;
        this.isWebGL = map.get("type").equals("JS");
        this.gdata = gData;
        this.privateKey = d;
        this.backgroundColix = viewer.getObjectColix(0);
        this.center.setT(this.tm.fixedRotationCenter);
        this.exportScale = viewer.getFloat(0x2200000E);
        if (this.exportScale == 0.0f) {
            this.exportScale = 10.0f;
        }
        Logger.info("__Exporter exportScale: " + this.exportScale);
        if (this.screenWidth <= 0 || this.screenHeight <= 0) {
            this.screenWidth = viewer.getScreenWidth();
            this.screenHeight = viewer.getScreenHeight();
        }
        this.slabZ = gData.slab;
        this.depthZ = gData.depth;
        this.lightSource = gData.getLightSource();
        P3[] p3Array = viewer.tm.getCameraFactors();
        this.referenceCenter = p3Array[0];
        this.cameraPosition = p3Array[1];
        this.fixedRotationCenter = p3Array[2];
        this.cameraDistance = p3Array[3].x;
        this.apertureAngle = p3Array[3].y;
        this.scalePixelsPerAngstrom = p3Array[3].z;
        this.out = (OC)map.get("outputChannel");
        this.commandLineOptions = (String)map.get("params");
        if (this.out != null) {
            this.fileName = this.out.getFileName();
        }
        this.outputHeader();
        return true;
    }

    protected abstract void outputHeader();

    protected void output(String string) {
        this.out.append(string);
    }

    protected int getByteCount() {
        return this.out.getByteCount();
    }

    protected void outputComment(String string) {
        if (this.commentChar != null) {
            this.output(String.valueOf(this.commentChar) + string + "\n");
        }
    }

    protected static void setTempVertex(T3 t3, T3 t32, T3 t33) {
        t33.setT(t3);
        if (t32 != null) {
            t33.add(t32);
        }
    }

    protected void outputVertices(T3[] t3Array, int n, T3 t3) {
        int n2 = 0;
        while (n2 < n) {
            if (!Float.isNaN(t3Array[n2].x)) {
                this.outputVertex(t3Array[n2], t3);
                this.output("\n");
            }
            ++n2;
        }
    }

    protected void outputVertex(T3 t3, T3 t32) {
        ___Exporter.setTempVertex(t3, t32, this.tempV1);
        this.output(this.tempV1);
    }

    protected abstract void output(T3 var1);

    protected void outputJmolPerspective() {
        this.outputComment(this.getJmolPerspective());
    }

    protected String getJmolPerspective() {
        if (this.commentChar == null) {
            return "";
        }
        SB sB = new SB();
        sB.append(this.commentChar).append("Jmol perspective:");
        sB.append("\n").append(this.commentChar).append("screen width height dim: " + this.screenWidth + " " + this.screenHeight + " " + this.vwr.getScreenDim());
        sB.append("\n").append(this.commentChar).append("perspectiveDepth: " + this.vwr.tm.perspectiveDepth);
        sB.append("\n").append(this.commentChar).append("cameraDistance(angstroms): " + this.cameraDistance);
        sB.append("\n").append(this.commentChar).append("aperatureAngle(degrees): " + this.apertureAngle);
        sB.append("\n").append(this.commentChar).append("scalePixelsPerAngstrom: " + this.scalePixelsPerAngstrom);
        sB.append("\n").append(this.commentChar).append("light source: " + this.lightSource);
        sB.append("\n").append(this.commentChar).append("lighting: " + this.vwr.getLightingState().replace('\n', ' '));
        sB.append("\n").append(this.commentChar).append("center: " + this.center);
        sB.append("\n").append(this.commentChar).append("rotationRadius: " + this.vwr.getFloat(0x2200002C));
        sB.append("\n").append(this.commentChar).append("boundboxCenter: " + this.vwr.getBoundBoxCenter());
        sB.append("\n").append(this.commentChar).append("translationOffset: " + this.tm.getTranslationScript());
        sB.append("\n").append(this.commentChar).append("zoom: " + this.vwr.tm.zmPct);
        sB.append("\n").append(this.commentChar).append("moveto command: " + this.vwr.getOrientationText(4129, null, null));
        sB.append("\n");
        return sB.toString();
    }

    protected void outputFooter() {
    }

    protected String finalizeOutput() {
        return this.finalizeOutput2();
    }

    protected String finalizeOutput2() {
        this.outputFooter();
        if (this.out == null) {
            return null;
        }
        String string = this.out.closeChannel();
        if (this.fileName == null) {
            return string;
        }
        if (string != null) {
            Logger.info(string);
            return "ERROR EXPORTING FILE: " + string;
        }
        return "OK " + this.out.getByteCount() + " " + this.export3D.getExportName() + " " + this.fileName;
    }

    protected String getExportDate() {
        return this.vwr.apiPlatform.getDateFormat(null);
    }

    protected String rgbFractionalFromColix(short s) {
        return this.rgbFractionalFromArgb(this.gdata.getColorArgbOrGray(s));
    }

    protected String getTriadC(T3 t3) {
        return this.getTriad(t3);
    }

    protected String getTriad(T3 t3) {
        return String.valueOf(___Exporter.round(t3.x)) + " " + ___Exporter.round(t3.y) + " " + ___Exporter.round(t3.z);
    }

    protected String rgbFractionalFromArgb(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        this.tempC.set(n2 == 0 ? 0.0f : (float)(n2 + 1) / 256.0f, n3 == 0 ? 0.0f : (float)(n3 + 1) / 256.0f, n4 == 0 ? 0.0f : (float)(n4 + 1) / 256.0f);
        return this.getTriadC(this.tempC);
    }

    protected static String translucencyFractionalFromColix(short s) {
        return ___Exporter.round(C.getColixTranslucencyFractional(s));
    }

    protected static String opacityFractionalFromColix(short s) {
        return ___Exporter.round(1.0f - C.getColixTranslucencyFractional(s));
    }

    protected static String opacityFractionalFromArgb(int n) {
        int n2 = n >> 24 & 0xFF;
        return ___Exporter.round(n2 == 0 ? 0.0f : (float)(n2 + 1) / 256.0f);
    }

    protected static String round(double d) {
        String string;
        return d == 0.0 ? "0" : (d == 1.0 ? "1" : ((string = "" + (double)Math.round(d * 1000.0) / 1000.0).startsWith("0.") ? string.substring(1) : (string.startsWith("-0.") ? "-" + string.substring(2) : (string.endsWith(".0") ? string.substring(0, string.length() - 2) : string))));
    }

    protected static String round(T3 t3) {
        return String.valueOf(___Exporter.round(t3.x)) + " " + ___Exporter.round(t3.y) + " " + ___Exporter.round(t3.z);
    }

    protected Lst<Short> getColorList(int n, short[] sArray, int n2, BS bS, Map<Short, Integer> map) {
        int n3;
        int n4 = 0;
        Lst<Short> lst = new Lst<Short>();
        boolean bl = bS == null;
        int n5 = n3 = bl ? n2 - 1 : bS.nextSetBit(0);
        while (n5 >= 0) {
            Short s = sArray[n5];
            if (!map.containsKey(s)) {
                lst.addLast(s);
                map.put(s, n + n4++);
            }
            int n6 = n5 = bl ? n5 - 1 : bS.nextSetBit(n5 + 1);
        }
        return lst;
    }

    protected static MeshSurface getConeMesh(P3 p3, M3 m3, short s) {
        MeshSurface meshSurface = new MeshSurface();
        int n = 10;
        int n2 = 360 / n;
        meshSurface.colix = s;
        meshSurface.vc = n2 + 1;
        meshSurface.vs = new P3[meshSurface.vc];
        meshSurface.pc = n2;
        meshSurface.pis = AU.newInt2(meshSurface.pc);
        int n3 = 0;
        while (n3 < n2) {
            meshSurface.pis[n3] = new int[]{n3, (n3 + 1) % n2, n2};
            ++n3;
        }
        double d = (double)n / 180.0 * Math.PI;
        int n4 = 0;
        while (n4 < n2) {
            float f = (float)Math.cos((double)n4 * d);
            float f2 = (float)Math.sin((double)n4 * d);
            meshSurface.vs[n4] = P3.new3(f, f2, 0.0f);
            ++n4;
        }
        meshSurface.vs[n2] = P3.new3(0.0f, 0.0f, 1.0f);
        if (m3 != null) {
            meshSurface.normals = new V3[meshSurface.vc];
            n4 = 0;
            while (n4 < meshSurface.vc) {
                m3.rotate(meshSurface.vs[n4]);
                meshSurface.normals[n4] = V3.newV(meshSurface.vs[n4]);
                meshSurface.normals[n4].normalize();
                meshSurface.vs[n4].add(p3);
                ++n4;
            }
        }
        return meshSurface;
    }

    protected M3 getRotationMatrix(P3 p3, P3 p32, float f) {
        M3 m3;
        M3 m32 = new M3();
        if (p32.x == p3.x && p32.y == p3.y) {
            m3 = M3.newM3(null);
            if (p3.z > p32.z) {
                m3.m22 = -1.0f;
                m3.m11 = -1.0f;
            }
        } else {
            this.tempV1.sub2(p32, p3);
            this.tempV2.set(0.0f, 0.0f, 1.0f);
            this.tempV2.cross(this.tempV2, this.tempV1);
            this.tempV1.cross(this.tempV1, this.tempV2);
            Quat quat = Quat.getQuaternionFrameV(this.tempV2, this.tempV1, null, false);
            m3 = quat.getMatrix();
        }
        m32.m00 = f;
        m32.m11 = f;
        m32.m22 = p32.distance(p3);
        m3.mul(m32);
        return m3;
    }

    protected M3 getRotationMatrix(P3 p3, P3 p32, float f, P3 p33, P3 p34) {
        M3 m3 = new M3();
        m3.m00 = p33.distance(p3) * f;
        m3.m11 = p34.distance(p3) * f;
        m3.m22 = p32.distance(p3) * 2.0f;
        Quat quat = Quat.getQuaternionFrame(p3, p33, p34);
        M3 m32 = quat.getMatrix();
        m32.mul(m3);
        return m32;
    }

    abstract void drawAtom(Atom var1, float var2);

    abstract void drawCircle(int var1, int var2, int var3, int var4, short var5, boolean var6);

    abstract boolean drawEllipse(P3 var1, P3 var2, P3 var3, short var4, boolean var5);

    void drawSurface(MeshSurface meshSurface, short s) {
        int n;
        int n2 = meshSurface.vc;
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        int n4 = meshSurface.pc;
        BS bS = meshSurface.bsPolygons;
        int n5 = meshSurface.haveQuads ? 4 : 3;
        int[][] nArray = meshSurface.pis;
        boolean bl = bS == null;
        int n6 = n = bl ? n4 - 1 : bS.nextSetBit(0);
        while (n6 >= 0) {
            n3 += n5 == 4 && nArray[n6].length == 4 ? 2 : 1;
            int n7 = n6 = bl ? n6 - 1 : bS.nextSetBit(n6 + 1);
        }
        if (n3 == 0) {
            return;
        }
        T3[] t3Array = meshSurface.getVertices();
        T3[] t3Array2 = meshSurface.normals;
        boolean bl2 = s != 0;
        short[] sArray = bl2 ? null : meshSurface.vcs;
        short[] sArray2 = bl2 ? meshSurface.pcs : null;
        Hashtable<Short, Integer> hashtable = null;
        Lst<Short> lst = null;
        if (!this.isWebGL) {
            hashtable = new Hashtable<Short, Integer>();
            if (sArray2 != null) {
                lst = this.getColorList(0, sArray2, n4, bS, hashtable);
            } else if (sArray != null) {
                lst = this.getColorList(0, sArray, n2, null, hashtable);
            }
        }
        this.outputSurface(t3Array, t3Array2, sArray, nArray, sArray2, n2, n4, n3, bS, n5, s, lst, hashtable, meshSurface.offset);
    }

    protected void outputSurface(T3[] t3Array, T3[] t3Array2, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BS bS, int n4, short s, Lst<Short> lst, Map<Short, Integer> map, P3 p3) {
    }

    abstract void drawPixel(short var1, int var2, int var3, int var4, int var5);

    abstract void drawTextPixel(int var1, int var2, int var3, int var4);

    abstract void fillConeScreen(short var1, byte var2, int var3, P3 var4, P3 var5, boolean var6);

    abstract void drawCylinder(P3 var1, P3 var2, short var3, short var4, byte var5, int var6, int var7);

    abstract void fillCylinderScreenMad(short var1, byte var2, int var3, P3 var4, P3 var5);

    abstract void fillCylinderScreen(short var1, byte var2, int var3, P3 var4, P3 var5, P3 var6, P3 var7, float var8);

    abstract void fillEllipsoid(P3 var1, P3[] var2, short var3, int var4, int var5, int var6, int var7, M3 var8, double[] var9, M4 var10, P3[] var11);

    void drawFilledCircle(short s, short s2, int n, int n2, int n3, int n4) {
        if (s != 0) {
            this.drawCircle(n2, n3, n4, n, s, false);
        }
        if (s2 != 0) {
            this.drawCircle(n2, n3, n4, n, s2, true);
        }
    }

    abstract void fillSphere(short var1, int var2, P3 var3);

    protected abstract void fillTriangle(short var1, T3 var2, T3 var3, T3 var4, boolean var5);

    protected int fixScreenZ(int n) {
        return n <= 3 ? n + (int)this.tm.cameraDistance : n;
    }

    void plotImage(int n, int n2, int n3, Object object, short s, int n4, int n5) {
        this.outputComment("start image " + ++this.nImage);
        this.gdata.plotImage(n, n2, n3, object, this.export3D, s, n4, n5);
        this.outputComment("end image " + this.nImage);
    }

    void plotText(int n, int n2, int n3, short s, String string, Font font) {
        this.outputComment("start text " + ++this.nText + ": " + string);
        this.gdata.plotText(n, n2, n3, this.gdata.getColorArgbOrGray(s), 0, string, font, this.export3D);
        this.outputComment("end text " + this.nText + ": " + string);
    }
}

