/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.api.GenericBinaryDocument;
import javajs.util.LimitedLineReader;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.Interface;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class Resolver {
    private static final String classBase = "org.jmol.adapter.readers.";
    private static final String[] readerSets = new String[]{"aflow.", ";AFLOW;", "cif.", ";Cif;Cif2;MMCif;MMTF;MagCif", "molxyz.", ";Mol3D;Mol;Xyz;", "more.", ";BinaryDcd;Gromacs;Jcampdx;MdCrd;MdTop;Mol2;TlsDataOnly;", "quantum.", ";Adf;Csf;Dgrid;GamessUK;GamessUS;Gaussian;GaussianFchk;GaussianWfn;Jaguar;Molden;MopacGraphf;GenNBO;NWChem;Psi;Qchem;QCJSON;WebMO;MO;", "pdb.", ";Pdb;Pqr;P2n;JmolData;", "pymol.", ";PyMOL;", "simple.", ";Alchemy;Ampac;Cube;FoldingXyz;GhemicalMM;HyperChem;Jme;JSON;Mopac;MopacArchive;Tinker;Input;", "spartan.", ";Spartan;SpartanSmol;Odyssey;", "xtal.", ";Abinit;Aims;Bilbao;Castep;Cgd;Crystal;Dmol;Espresso;Gulp;Jana;Magres;Shelx;Siesta;VaspOutcar;VaspPoscar;Wien2k;Xcrysden;", "xml.", ";XmlArgus;XmlCml;XmlChem3d;XmlMolpro;XmlOdyssey;XmlXsd;XmlVasp;XmlQE;"};
    private static final String CML_NAMESPACE_URI = "http://www.xml-cml.org/schema";
    private static final int LEADER_CHAR_MAX = 64;
    private static final String[] sptRecords = new String[]{"spt", "# Jmol state", "# Jmol script", "JmolManifest"};
    private static final String[] m3dStartRecords = new String[]{"Alchemy", "STRUCTURE  1.00     1"};
    private static final String[] cubeFileStartRecords = new String[]{"Cube", "JVXL", "#JVXL"};
    private static final String[] mol2Records = new String[]{"Mol2", "mol2", "@<TRIPOS>"};
    private static final String[] webmoFileStartRecords = new String[]{"WebMO", "[HEADER]"};
    private static final String[] moldenFileStartRecords = new String[]{"Molden", "[Molden", "MOLDEN", "[MOLDEN"};
    private static final String[] dcdFileStartRecords = new String[]{"BinaryDcd", "T\u0000\u0000\u0000CORD", "\u0000\u0000\u0000TCORD"};
    private static final String[] tlsDataOnlyFileStartRecords = new String[]{"TlsDataOnly", "REFMAC\n\nTL", "REFMAC\r\n\r\n", "REFMAC\r\rTL"};
    private static final String[] inputFileStartRecords = new String[]{"Input", "#ZMATRIX", "%mem=", "AM1", "$rungauss"};
    private static final String[] magresFileStartRecords = new String[]{"Magres", "#$magres", "# magres"};
    private static final String[] pymolStartRecords = new String[]{"PyMOL", "}q"};
    private static final String[] janaStartRecords = new String[]{"Jana", "Version Jana"};
    private static final String[] jsonStartRecords = new String[]{"JSON", "{\"mol\":"};
    private static final String[] jcampdxStartRecords = new String[]{"Jcampdx", "##TITLE"};
    private static final String[] jmoldataStartRecords = new String[]{"JmolData", "REMARK   6 Jmol"};
    private static final String[] pqrStartRecords = new String[]{"Pqr", "REMARK   1 PQR", "REMARK    The B-factors"};
    private static final String[] p2nStartRecords = new String[]{"P2n", "REMARK   1 P2N"};
    private static final String[] cif2StartRecords = new String[]{"Cif2", "#\\#CIF_2"};
    private static final String[] xmlStartRecords = new String[]{"Xml", "<?xml"};
    private static final String[] cfiStartRecords = new String[]{"Input", "$CFI"};
    private static final String[][] fileStartsWithRecords = new String[][]{xmlStartRecords, sptRecords, m3dStartRecords, cubeFileStartRecords, mol2Records, webmoFileStartRecords, moldenFileStartRecords, dcdFileStartRecords, tlsDataOnlyFileStartRecords, inputFileStartRecords, magresFileStartRecords, pymolStartRecords, janaStartRecords, jsonStartRecords, jcampdxStartRecords, jmoldataStartRecords, pqrStartRecords, p2nStartRecords, cif2StartRecords, cfiStartRecords};
    private static final String[] mmcifLineStartRecords = new String[]{"MMCif", "_entry.id", "_database_PDB_", "_pdbx_", "_chem_comp.pdbx_type", "_audit_author.name", "_atom_site."};
    private static final String[] cifLineStartRecords = new String[]{"Cif", "data_", "_publ"};
    private static final String[] pdbLineStartRecords = new String[]{"Pdb", "HEADER", "OBSLTE", "TITLE ", "CAVEAT", "COMPND", "SOURCE", "KEYWDS", "EXPDTA", "AUTHOR", "REVDAT", "SPRSDE", "JRNL  ", "REMARK ", "DBREF ", "SEQADV", "SEQRES", "MODRES", "HELIX ", "SHEET ", "TURN  ", "CRYST1", "ORIGX1", "ORIGX2", "ORIGX3", "SCALE1", "SCALE2", "SCALE3", "ATOM  ", "HETATM", "MODEL ", "LINK  ", "USER  MOD "};
    private static final String[] cgdLineStartRecords = new String[]{"Cgd", "EDGE ", "edge "};
    private static final String[] shelxLineStartRecords = new String[]{"Shelx", "TITL ", "ZERR ", "LATT ", "SYMM ", "CELL "};
    private static final String[] ghemicalMMLineStartRecords = new String[]{"GhemicalMM", "!Header mm1gp", "!Header gpr"};
    private static final String[] jaguarLineStartRecords = new String[]{"Jaguar", "  |  Jaguar version"};
    private static final String[] mdlLineStartRecords = new String[]{"Mol", "$MDL "};
    private static final String[] spartanSmolLineStartRecords = new String[]{"SpartanSmol", "INPUT="};
    private static final String[] csfLineStartRecords = new String[]{"Csf", "local_transform"};
    private static final String[] mdTopLineStartRecords = new String[]{"MdTop", "%FLAG TITLE"};
    private static final String[] hyperChemLineStartRecords = new String[]{"HyperChem", "mol 1"};
    private static final String[] vaspOutcarLineStartRecords = new String[]{"VaspOutcar", " vasp.", " INCAR:"};
    private static final String[][] lineStartsWithRecords = new String[][]{mmcifLineStartRecords, cifLineStartRecords, pdbLineStartRecords, cgdLineStartRecords, shelxLineStartRecords, ghemicalMMLineStartRecords, jaguarLineStartRecords, mdlLineStartRecords, spartanSmolLineStartRecords, csfLineStartRecords, mol2Records, mdTopLineStartRecords, hyperChemLineStartRecords, vaspOutcarLineStartRecords};
    private static final String[] bilbaoContainsRecords = new String[]{"Bilbao", ">Bilbao Crystallographic Server<"};
    private static final String[] xmlContainsRecords = new String[]{"Xml", "<?xml", "<atom", "<molecule", "<reaction", "<cml", "<bond", ".dtd\"", "<list>", "<entry", "<identifier", "http://www.xml-cml.org/schema/cml2/core"};
    private static final String[] gaussianContainsRecords = new String[]{"Gaussian", "Entering Gaussian System", "Entering Link 1", "1998 Gaussian, Inc."};
    private static final String[] ampacContainsRecords = new String[]{"Ampac", "AMPAC Version"};
    private static final String[] mopacContainsRecords = new String[]{"Mopac", "MOPAC 93 (c) Fujitsu", "MOPAC FOR LINUX (PUBLIC DOMAIN VERSION)", "MOPAC:  VERSION  6", "MOPAC   7", "MOPAC2", "MOPAC (PUBLIC"};
    private static final String[] qchemContainsRecords = new String[]{"Qchem", "Welcome to Q-Chem", "A Quantum Leap Into The Future Of Chemistry"};
    private static final String[] gamessUKContainsRecords = new String[]{"GamessUK", "GAMESS-UK", "G A M E S S - U K"};
    private static final String[] gamessUSContainsRecords = new String[]{"GamessUS", "GAMESS", "$CONTRL"};
    private static final String[] spartanBinaryContainsRecords = new String[]{"SpartanSmol", "|PropertyArchive", "_spartan", "spardir", "BEGIN Directory Entry Molecule"};
    private static final String[] spartanContainsRecords = new String[]{"Spartan", "Spartan", "converted archive file"};
    private static final String[] adfContainsRecords = new String[]{"Adf", "Amsterdam Density Functional"};
    private static final String[] psiContainsRecords = new String[]{"Psi", "    PSI  3", "PSI3:"};
    private static final String[] nwchemContainsRecords = new String[]{"NWChem", " argument  1 = "};
    private static final String[] uicrcifContainsRecords = new String[]{"Cif", "Crystallographic Information File"};
    private static final String[] dgridContainsRecords = new String[]{"Dgrid", "BASISFILE   created by DGrid"};
    private static final String[] crystalContainsRecords = new String[]{"Crystal", "*                                CRYSTAL", "TORINO", "DOVESI"};
    private static final String[] dmolContainsRecords = new String[]{"Dmol", "DMol^3"};
    private static final String[] gulpContainsRecords = new String[]{"Gulp", "GENERAL UTILITY LATTICE PROGRAM"};
    private static final String[] espressoContainsRecords = new String[]{"Espresso", "Program PWSCF", "Program PHONON"};
    private static final String[] siestaContainsRecords = new String[]{"Siesta", "MD.TypeOfRun", "SolutionMethod", "MeshCutoff", "WELCOME TO SIESTA"};
    private static final String[] xcrysDenContainsRecords = new String[]{"Xcrysden", "PRIMVEC", "CONVVEC", "PRIMCOORD", "ANIMSTEP"};
    private static final String[] mopacArchiveContainsRecords = new String[]{"MopacArchive", "SUMMARY OF PM"};
    private static final String[] abinitContainsRecords = new String[]{"Abinit", "http://www.abinit.org", "Catholique", "Louvain"};
    private static final String[] qcJsonContainsRecords = new String[]{"QCJSON", "\"QCJSON"};
    private static final String[] gaussianFchkContainsRecords = new String[]{"GaussianFchk", "Number of point charges in /Mol/"};
    private static final String[] inputContainsRecords = new String[]{"Input", " ATOMS cartesian", "$molecule", "&zmat", "geometry={", "$DATA", "%coords", "GEOM=PQS", "geometry units angstroms"};
    private static final String[] aflowContainsRecords = new String[]{"AFLOW", "/AFLOWDATA/"};
    private static final String[] magCifContainsRecords = new String[]{"MagCif", "_space_group_magn"};
    private static final String[][] headerContainsRecords = new String[][]{sptRecords, bilbaoContainsRecords, xmlContainsRecords, gaussianContainsRecords, ampacContainsRecords, mopacContainsRecords, gamessUKContainsRecords, gamessUSContainsRecords, spartanBinaryContainsRecords, spartanContainsRecords, qchemContainsRecords, mol2Records, adfContainsRecords, psiContainsRecords, nwchemContainsRecords, uicrcifContainsRecords, dgridContainsRecords, crystalContainsRecords, dmolContainsRecords, gulpContainsRecords, espressoContainsRecords, siestaContainsRecords, xcrysDenContainsRecords, mopacArchiveContainsRecords, abinitContainsRecords, gaussianFchkContainsRecords, inputContainsRecords, aflowContainsRecords, magCifContainsRecords, qcJsonContainsRecords};

    public static final String getReaderClassBase(String string) {
        String string2 = String.valueOf(string) + "Reader";
        if (string.startsWith("Xml")) {
            return "org.jmol.adapter.readers.xml." + string2;
        }
        String string3 = ";" + string + ";";
        int n = 1;
        while (n < readerSets.length) {
            if (readerSets[n].indexOf(string3) >= 0) {
                return classBase + readerSets[n - 1] + string2;
            }
            n += 2;
        }
        return "org.jmol.adapter.readers.???." + string2;
    }

    static String getFileType(BufferedReader bufferedReader) {
        try {
            return Resolver.determineAtomSetCollectionReader(bufferedReader, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Object getAtomCollectionReader(String string, String string2, Object object, Map<String, Object> map, int n) throws Exception {
        String string3;
        string = FileManager.fixDOSName(string);
        String string4 = null;
        if (string2 == null) {
            string2 = (String)map.get("filter");
            int n2 = string2 == null ? -1 : string2.toLowerCase().indexOf("filetype");
            String string5 = string2 = n2 < 0 ? null : string2.substring(n2 + 8, (String.valueOf(string2) + ";").indexOf(";", n2)).replace('=', ' ').trim();
        }
        if (string2 != null) {
            string3 = Resolver.getReaderFromType(string2);
            if (string3 == null) {
                string3 = Resolver.getReaderFromType("Xml" + string2);
            }
            if (string3 == null) {
                string4 = "unrecognized file format type " + string2;
            } else {
                Logger.info("The Resolver assumes " + string3);
            }
        } else {
            string3 = Resolver.determineAtomSetCollectionReader(object, true);
            if (string3.charAt(0) == '\n' && (string2 = (String)map.get("defaultType")) != null && (string2 = Resolver.getReaderFromType(string2)) != null) {
                string3 = string2;
            }
            if (string3.charAt(0) == '\n') {
                string4 = "unrecognized file format for file\n" + string + "\n" + Resolver.split(string3, 50);
            } else if (string3.equals("spt")) {
                string4 = "NOTE: file recognized as a script file: " + string + "\n";
            } else if (!string.equals("ligand")) {
                Logger.info("The Resolver thinks " + string3);
            }
        }
        if (string4 != null) {
            SmarterJmolAdapter.close(object);
            return string4;
        }
        map.put("ptFile", n);
        if (n <= 0) {
            map.put("readerName", string3);
        }
        if (string3.indexOf("Xml") == 0) {
            string3 = "Xml";
        }
        return Resolver.getReader(string3, map);
    }

    public static Object getReader(String string, Map<String, Object> map) {
        AtomSetCollectionReader atomSetCollectionReader = null;
        String string2 = null;
        String string3 = null;
        string2 = Resolver.getReaderClassBase(string);
        atomSetCollectionReader = (AtomSetCollectionReader)Interface.getInterface(string2, (Viewer)map.get("vwr"), "reader");
        if (atomSetCollectionReader == null) {
            string3 = String.valueOf(JC.READER_NOT_FOUND) + string2;
            Logger.error(string3);
            return string3;
        }
        return atomSetCollectionReader;
    }

    private static final String getReaderFromType(String string) {
        if (";zmatrix;cfi;c;vfi;v;mnd;jag;adf;gms;g;gau;mp;nw;orc;pqs;qc;".indexOf(string = ";" + string.toLowerCase() + ";") >= 0) {
            return "Input";
        }
        int n = readerSets.length;
        while (--n >= 0) {
            String string2;
            int n2;
            if ((n2 = (string2 = readerSets[n--]).toLowerCase().indexOf(string)) < 0) continue;
            return string2.substring(n2 + 1, string2.indexOf(";", n2 + 2));
        }
        return null;
    }

    private static String split(String string, int n) {
        String string2 = "";
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            n4 = Math.min(n3 + n, n2);
            string2 = String.valueOf(string2) + string.substring(n3, n4) + "\n";
            n3 = n4;
        }
        return string2;
    }

    public static Object DOMResolve(Map<String, Object> map) throws Exception {
        String string = Resolver.getXmlType((String)map.get("nameSpaceInfo"));
        if (Logger.debugging) {
            Logger.debug("The Resolver thinks " + string);
        }
        map.put("readerName", string);
        return Resolver.getReader("XmlReader", map);
    }

    private static String determineAtomSetCollectionReader(Object object, boolean bl) throws Exception {
        LimitedLineReader limitedLineReader;
        String string;
        String string2;
        if (object instanceof GenericBinaryDocument) {
            GenericBinaryDocument genericBinaryDocument = (GenericBinaryDocument)object;
            String string3 = Resolver.getBinaryType(genericBinaryDocument.getInputStream());
            return string3 == null ? "binary file type not recognized" : string3;
        }
        if (object instanceof InputStream) {
            string2 = Resolver.getBinaryType((InputStream)object);
            if (string2 != null) {
                return string2;
            }
            object = Rdr.getBufferedReader(new BufferedInputStream((InputStream)object), null);
        }
        if ((string = (limitedLineReader = new LimitedLineReader((BufferedReader)object, 16384)).getHeader(64).trim()).indexOf("PNG") == 1 && string.indexOf("PNGJ") >= 0) {
            return "pngj";
        }
        if (string.indexOf("PNG") == 1 || string.indexOf("JPG") == 1 || string.indexOf("JFIF") == 6) {
            return "spt";
        }
        if (string.indexOf("\"num_pairs\"") >= 0) {
            return "dssr";
        }
        string2 = Resolver.checkFileStart(string);
        if (string2 != null) {
            return string2.equals("Xml") ? Resolver.getXmlType(limitedLineReader.getHeader(0)) : string2;
        }
        String[] stringArray = new String[16];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = limitedLineReader.readLineWithNewline();
            if (stringArray[n2].length() > 0) {
                ++n;
            }
            ++n2;
        }
        string2 = Resolver.checkSpecial1(n, stringArray, string);
        if (string2 != null) {
            return string2;
        }
        string2 = Resolver.checkLineStarts(stringArray);
        if (string2 != null) {
            return string2;
        }
        string2 = Resolver.checkHeaderContains(limitedLineReader.getHeader(0));
        if (string2 != null) {
            return string2;
        }
        string2 = Resolver.checkSpecial2(stringArray);
        if (string2 != null) {
            return string2;
        }
        return bl ? "\n" + stringArray[0] + "\n" + stringArray[1] + "\n" + stringArray[2] + "\n" : null;
    }

    public static String getBinaryType(InputStream inputStream) {
        return Rdr.isPickleS(inputStream) ? "PyMOL" : ((Rdr.getMagic(inputStream, 1)[0] & 0xDE) == 222 ? "MMTF" : null);
    }

    private static String checkFileStart(String string) {
        int n = 0;
        while (n < fileStartsWithRecords.length) {
            String[] stringArray = fileStartsWithRecords[n];
            int n2 = 1;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2];
                if (string.startsWith(string2)) {
                    return stringArray[0];
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private static final String checkSpecial1(int n, String[] stringArray, String string) {
        if (n == 1 && stringArray[0].length() > 0 && PT.isDigit(stringArray[0].charAt(0))) {
            return "Jme";
        }
        if (Resolver.checkMopacGraphf(stringArray)) {
            return "MopacGraphf";
        }
        if (Resolver.checkOdyssey(stringArray)) {
            return "Odyssey";
        }
        switch (Resolver.checkMol(stringArray)) {
            case 1: 
            case 3: 
            case 2000: 
            case 3000: {
                return "Mol";
            }
        }
        switch (Resolver.checkXyz(stringArray)) {
            case 1: {
                return "Xyz";
            }
            case 2: {
                return "Bilbao";
            }
        }
        if (Resolver.checkAlchemy(stringArray[0])) {
            return "Alchemy";
        }
        if (Resolver.checkFoldingXyz(stringArray)) {
            return "FoldingXyz";
        }
        if (Resolver.checkCube(stringArray)) {
            return "Cube";
        }
        if (Resolver.checkWien2k(stringArray)) {
            return "Wien2k";
        }
        if (Resolver.checkAims(stringArray)) {
            return "Aims";
        }
        if (Resolver.checkGenNBO(stringArray, string)) {
            return "GenNBO";
        }
        return null;
    }

    private static boolean checkAims(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("mol 1")) {
                return false;
            }
            String[] stringArray2 = PT.getTokens(stringArray[n]);
            if (stringArray2.length != 0 && (stringArray2[0].startsWith("atom") && stringArray2.length > 4 && Float.isNaN(PT.parseFloat(stringArray2[4])) || stringArray2[0].startsWith("multipole") && stringArray2.length >= 6 || stringArray2[0].startsWith("lattice_vector") && stringArray2.length >= 4)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean checkAlchemy(String string) {
        int n = string.indexOf("ATOMS");
        if (n >= 0 && string.indexOf("BONDS") > n) {
            try {
                int n2 = Integer.parseInt(string.substring(0, n).trim());
                return n2 > 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkCube(String[] stringArray) {
        try {
            int n = 2;
            block2: while (true) {
                if (n > 5) {
                    return true;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n]);
                int n2 = stringTokenizer.countTokens();
                if (n2 != 4 && (n != 2 || n2 != 5)) {
                    return false;
                }
                Integer.parseInt(stringTokenizer.nextToken());
                int n3 = 3;
                while (true) {
                    if (--n3 < 0) {
                        if (n2 == 5) {
                            Integer.parseInt(stringTokenizer.nextToken());
                        }
                        ++n;
                        continue block2;
                    }
                    Float.parseFloat(stringTokenizer.nextToken());
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean checkFoldingXyz(String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0].trim(), " \t");
        if (stringTokenizer.countTokens() < 2) {
            return false;
        }
        try {
            Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        String string = stringArray[1].trim();
        if (string.length() == 0) {
            string = stringArray[2].trim();
        }
        if ((stringTokenizer = new StringTokenizer(string, " \t")).countTokens() == 0) {
            return false;
        }
        try {
            Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static boolean checkGenNBO(String[] stringArray, String string) {
        return string.indexOf("$GENNBO") >= 0 || stringArray[1].startsWith(" Basis set information needed for plotting orbitals") || stringArray[1].indexOf("s in the AO basis:") >= 0 || stringArray[1].indexOf("***** NBO ") >= 0 || stringArray[2].indexOf(" N A T U R A L   A T O M I C   O R B I T A L") >= 0;
    }

    private static int checkMol(String[] stringArray) {
        String string = ("X" + stringArray[3]).trim().toUpperCase();
        if (string.length() < 7 || string.indexOf(".") >= 0) {
            return 0;
        }
        if (string.endsWith("V2000")) {
            return 2000;
        }
        if (string.endsWith("V3000")) {
            return 3000;
        }
        try {
            int n = Integer.parseInt(stringArray[3].substring(0, 3).trim());
            int n2 = Integer.parseInt(stringArray[3].substring(3, 6).trim());
            return n > 0 && n2 >= 0 && stringArray[0].indexOf("@<TRIPOS>") != 0 && stringArray[1].indexOf("@<TRIPOS>") != 0 && stringArray[2].indexOf("@<TRIPOS>") != 0 ? 3 : 0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static boolean checkMopacGraphf(String[] stringArray) {
        return stringArray[0].indexOf("MOPAC-Graphical data") > 2;
    }

    private static boolean checkOdyssey(String[] stringArray) {
        int n;
        block5: {
            n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].startsWith("C ") && stringArray[n].length() != 0) break;
                ++n;
            }
            if (n >= stringArray.length || stringArray[n].charAt(0) != ' ' || (n += 2) + 1 >= stringArray.length) {
                return false;
            }
            try {
                int n2 = Integer.parseInt(stringArray[n].substring(2).trim());
                int n3 = Integer.parseInt(stringArray[n].substring(0, 2).trim());
                int n4 = Integer.parseInt(stringArray[++n].substring(0, 2).trim());
                if (n2 >= 0 && n2 <= 5 && n4 > 0 && n3 <= 5) break block5;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        float[] fArray = AtomSetCollectionReader.getTokensFloat(stringArray[n], null, 5);
        return !Float.isNaN(fArray[1]) && !Float.isNaN(fArray[2]) && !Float.isNaN(fArray[3]) && Float.isNaN(fArray[4]);
    }

    private static boolean checkWien2k(String[] stringArray) {
        return stringArray[2].startsWith("MODE OF CALC=") || stringArray[2].startsWith("             RELA") || stringArray[2].startsWith("             NREL");
    }

    private static int checkXyz(String[] stringArray) {
        try {
            Integer.parseInt(stringArray[0].trim());
            try {
                Integer.parseInt(stringArray[2].trim());
            }
            catch (NumberFormatException numberFormatException) {
                return 1;
            }
            return 2;
        }
        catch (NumberFormatException numberFormatException) {
            if (stringArray[0].indexOf("Bilbao Crys") >= 0) {
                return 2;
            }
            return 0;
        }
    }

    private static String checkLineStarts(String[] stringArray) {
        int n = 0;
        while (n < lineStartsWithRecords.length) {
            String[] stringArray2 = lineStartsWithRecords[n];
            int n2 = 1;
            while (n2 < stringArray2.length) {
                String string = stringArray2[n2];
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (stringArray[n3].startsWith(string)) {
                        return stringArray2[0];
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private static String checkHeaderContains(String string) throws Exception {
        int n = 0;
        while (n < headerContainsRecords.length) {
            String[] stringArray = headerContainsRecords[n];
            int n2 = 1;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2];
                if (string.indexOf(string2) >= 0) {
                    String string3 = stringArray[0];
                    if (!string3.equals("Xml")) {
                        return string3;
                    }
                    if (string.indexOf("/AFLOWDATA/") >= 0 || string.indexOf("-- Structure PRE --") >= 0) {
                        return "AFLOW";
                    }
                    return string.indexOf("<!DOCTYPE HTML PUBLIC") < 0 && string.indexOf("XHTML") < 0 && (string.indexOf("xhtml") < 0 || string.indexOf("<cml") >= 0) ? Resolver.getXmlType(string) : null;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private static String getXmlType(String string) throws Exception {
        if (string.indexOf("http://www.molpro.net/") >= 0) {
            return "XmlMolpro";
        }
        if (string.indexOf("odyssey") >= 0) {
            return "XmlOdyssey";
        }
        if (string.indexOf("C3XML") >= 0) {
            return "XmlChem3d";
        }
        if (string.indexOf("arguslab") >= 0) {
            return "XmlArgus";
        }
        if (string.indexOf("jvxl") >= 0 || string.indexOf(CML_NAMESPACE_URI) >= 0 || string.indexOf("cml:") >= 0 || string.indexOf("<cml>") >= 0) {
            return "XmlCml";
        }
        if (string.indexOf("XSD") >= 0) {
            return "XmlXsd";
        }
        if (string.indexOf(">vasp") >= 0) {
            return "XmlVasp";
        }
        if (string.indexOf("<GEOMETRY_INFO>") >= 0) {
            return "XmlQE";
        }
        return "XmlCml(unidentified)";
    }

    private static final String checkSpecial2(String[] stringArray) {
        if (Resolver.checkGromacs(stringArray)) {
            return "Gromacs";
        }
        if (Resolver.checkCrystal(stringArray)) {
            return "Crystal";
        }
        String string = Resolver.checkCastepVasp(stringArray);
        if (string != null) {
            return string;
        }
        return null;
    }

    private static boolean checkCrystal(String[] stringArray) {
        String string = stringArray[1].trim();
        if (string.equals("SLAB") || string.equals("MOLECULE") || string.equals("CRYSTAL") || string.equals("POLYMER") || (string = stringArray[3]).equals("SLAB") || string.equals("MOLECULE") || string.equals("POLYMER")) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].trim().equals("OPTGEOM") || stringArray[n].trim().equals("FREQCALC") || stringArray[n].contains("DOVESI") || stringArray[n].contains("TORINO") || stringArray[n].contains("http://www.crystal.unito.it") || stringArray[n].contains("Pcrystal") || stringArray[n].contains("MPPcrystal") || stringArray[n].contains("crystal executable")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean checkGromacs(String[] stringArray) {
        if (PT.parseInt(stringArray[1]) == Integer.MIN_VALUE) {
            return false;
        }
        int n = -1;
        int n2 = 2;
        while (n2 < 16 && n != 0) {
            n = stringArray[n2].length();
            if (n != 69 && n != 45 && n != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static String checkCastepVasp(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].toUpperCase();
            if (string.indexOf("FREQUENCIES IN         CM-1") == 1 || string.contains("CASTEP") || string.startsWith("%BLOCK LATTICE_ABC") || string.startsWith("%BLOCK LATTICE_CART") || string.startsWith("%BLOCK POSITIONS_FRAC") || string.startsWith("%BLOCK POSITIONS_ABS") || string.contains("<-- E")) {
                return "Castep";
            }
            if (n >= 6 && n < 10 && (string.startsWith("DIRECT") || string.startsWith("CARTESIAN"))) {
                return "VaspPoscar";
            }
            ++n;
        }
        return null;
    }
}

