/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T4;
import javajs.util.V3;
import org.jmol.modelset.TickInfo;
import org.jmol.script.SV;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptError;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptExpr;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Logger;

public abstract class ScriptParam
extends ScriptError {
    public Map<String, SV> contextVariables;
    public ScriptContext thisContext;
    public int iToken;
    public int theTok;
    public T theToken;
    public T[] st;
    public int slen;
    public P3 fractionalPoint;
    public boolean coordinatesAreFractional;
    public boolean isBondSet;

    public T getToken(int i) throws ScriptException {
        if (!this.checkToken(i)) {
            this.error(13);
        }
        this.theToken = this.st[i];
        this.theTok = this.theToken.tok;
        return this.theToken;
    }

    public int tokAt(int i) {
        return i < this.slen && this.st[i] != null ? this.st[i].tok : 0;
    }

    protected boolean checkToken(int i) {
        this.iToken = i;
        return this.iToken < this.slen;
    }

    public Object getParameter(String key, int tokType, boolean nullAsString) {
        Object v = this.getContextVariableAsVariable(key, false);
        if (v == null) {
            if (nullAsString) {
                v = this.vwr.getP(key);
            } else {
                v = this.vwr.getPOrNull(key);
                if (v == null) {
                    return null;
                }
            }
        }
        switch (tokType) {
            case 1073742190: {
                return SV.getVariable(v);
            }
            case 4: {
                if (!(v instanceof Lst)) break;
                Lst sv = (Lst)v;
                SB sb = new SB();
                for (int i = 0; i < sv.size(); ++i) {
                    sb.append(((SV)sv.get(i)).asString()).appendC('\n');
                }
                return sb.toString();
            }
        }
        return SV.oValue(v);
    }

    protected Object getVarParameter(String var, boolean orReturnName) {
        SV v = this.getContextVariableAsVariable(var, false);
        if (v != null) {
            return orReturnName ? v.asString() : SV.oValue(v);
        }
        Object val = this.vwr.getP(var);
        return orReturnName && ("" + val).length() == 0 ? var : val;
    }

    public SV getContextVariableAsVariable(String var, boolean isLocal) {
        if (var.equals("expressionBegin")) {
            return null;
        }
        if (var.equalsIgnoreCase("_caller")) {
            ScriptContext sc = this.thisContext;
            while (sc != null) {
                if (sc.isFunction) {
                    return SV.newV(6, sc.vars);
                }
                sc = sc.parentContext;
            }
            return SV.newV(6, new Hashtable());
        }
        var = var.toLowerCase();
        return this.contextVariables != null && this.contextVariables.containsKey(var) ? this.contextVariables.get(var) : (isLocal || this.thisContext == null ? null : this.thisContext.getVariable(var));
    }

    public String paramAsStr(int i) throws ScriptException {
        this.getToken(i);
        if (this.theToken == null) {
            this.error(13);
        }
        return SV.sValue(this.theToken);
    }

    public String stringParameter(int index) throws ScriptException {
        if (!this.checkToken(index) || this.getToken((int)index).tok != 4) {
            this.error(41);
        }
        return (String)this.theToken.value;
    }

    public String[] stringParameterSet(int i) throws ScriptException {
        int tok;
        switch (this.tokAt(i)) {
            case 4: {
                Object o;
                String s = this.stringParameter(i);
                if (s.startsWith("[\"") && (o = this.vwr.evaluateExpression(s)) instanceof String) {
                    return PT.split((String)o, "\n");
                }
                return new String[]{s};
            }
            case 1073742195: {
                i += 2;
                break;
            }
            case 0x10000040: {
                ++i;
                break;
            }
            case 7: {
                return SV.strListValue(this.getToken(i));
            }
            default: {
                this.invArg();
            }
        }
        Lst<String> v = new Lst<String>();
        while ((tok = this.tokAt(i)) != 0x10000041) {
            switch (tok) {
                case 0x10000030: {
                    break;
                }
                case 4: {
                    v.addLast(this.stringParameter(i));
                    break;
                }
                default: {
                    this.invArg();
                }
            }
            ++i;
        }
        this.iToken = i;
        int n = v.size();
        String[] sParams = new String[n];
        for (int j = 0; j < n; ++j) {
            sParams[j] = (String)v.get(j);
        }
        return sParams;
    }

    public String objectNameParameter(int index) throws ScriptException {
        if (!this.checkToken(index)) {
            this.error(37);
        }
        return this.paramAsStr(index);
    }

    protected P3 atomCenterOrCoordinateParameter(int i, Object[] ret) throws ScriptException {
        switch (this.getToken((int)i).tok) {
            case 10: 
            case 1073742325: {
                BS bs = ((ScriptEval)this).atomExpression(this.st, i, 0, true, false, ret, true);
                if (bs == null) {
                    if (ret == null || !(ret[0] instanceof P3)) {
                        this.invArg();
                    }
                    return (P3)ret[0];
                }
                if (ret != null) {
                    if (ret.length == 2 && ret[1] instanceof BS) {
                        bs = BSUtil.copy(bs);
                        bs.and((BS)ret[1]);
                    }
                    ret[0] = bs;
                }
                return bs.cardinality() == 1 ? this.vwr.ms.at[bs.nextSetBit(0)] : this.vwr.ms.getAtomSetCenter(bs);
            }
            case 8: 
            case 1073742332: {
                return this.getPoint3f(i, true);
            }
        }
        this.invArg();
        return null;
    }

    public boolean isCenterParameter(int i) {
        int tok = this.tokAt(i);
        return tok == 1073742330 || tok == 1073742332 || tok == 1073742325 || tok == 8 || tok == 10;
    }

    public P3 centerParameter(int i, Object[] ret) throws ScriptException {
        return this.centerParameterForModel(i, Integer.MIN_VALUE, ret);
    }

    protected P3 centerParameterForModel(int i, int modelIndex, Object[] ret) throws ScriptException {
        P3 center = null;
        if (this.checkToken(i)) {
            switch (this.getToken((int)i).tok) {
                case 1073742330: {
                    String id = this.objectNameParameter(++i);
                    int index = Integer.MIN_VALUE;
                    if (this.tokAt(i + 1) == 0x10000040) {
                        index = ((SV)((ScriptExpr)this).parameterExpressionList(-i - 1, -1, true).get(0)).asInt();
                        if (this.getToken((int)(--this.iToken)).tok != 0x10000041) {
                            this.invArg();
                        }
                    }
                    if (this.chk) {
                        return new P3();
                    }
                    if (this.tokAt(i + 1) == 0x40000200 && (this.tokAt(i + 2) == 0x44000003 || this.tokAt(i + 2) == 0x44000006)) {
                        index = Integer.MAX_VALUE;
                        this.iToken = i + 2;
                    }
                    if ((center = ((ScriptEval)this).getObjectCenter(id, index, modelIndex)) != null) break;
                    this.errorStr(12, id);
                    break;
                }
                case 8: 
                case 10: 
                case 1073742325: 
                case 1073742332: {
                    if (ret == null) {
                        ret = new Object[1];
                    }
                    center = this.atomCenterOrCoordinateParameter(i, ret);
                }
            }
        }
        if (center == null) {
            this.error(11);
        }
        return center;
    }

    public P4 planeParameter(int i) throws ScriptException {
        boolean isNegated;
        V3 vTemp = new V3();
        V3 vTemp2 = new V3();
        T4 plane = null;
        if (this.tokAt(i) == 134217750) {
            ++i;
        }
        boolean bl = isNegated = this.tokAt(i) == 0x100000A0;
        if (isNegated) {
            ++i;
        }
        if (i < this.slen) {
            switch (this.getToken((int)i).tok) {
                case 9: {
                    plane = P4.newPt((P4)this.theToken.value);
                    break;
                }
                case 1073742330: {
                    String id = this.objectNameParameter(++i);
                    if (this.chk) {
                        return new P4();
                    }
                    plane = ((ScriptEval)this).getPlaneForObject(id, vTemp);
                    break;
                }
                case 1111492629: {
                    if (!this.checkToken(++i) || this.getToken((int)i++).tok != 268435860) {
                        this.evalError("x=?", null);
                    }
                    plane = P4.new4(1.0f, 0.0f, 0.0f, -this.floatParameter(i));
                    break;
                }
                case 1111492630: {
                    if (!this.checkToken(++i) || this.getToken((int)i++).tok != 268435860) {
                        this.evalError("y=?", null);
                    }
                    plane = P4.new4(0.0f, 1.0f, 0.0f, -this.floatParameter(i));
                    break;
                }
                case 1111492631: {
                    if (!this.checkToken(++i) || this.getToken((int)i++).tok != 268435860) {
                        this.evalError("z=?", null);
                    }
                    plane = P4.new4(0.0f, 0.0f, 1.0f, -this.floatParameter(i));
                    break;
                }
                case 4: 
                case 0x40000000: {
                    String str = this.paramAsStr(i);
                    if (str.equalsIgnoreCase("xy")) {
                        plane = P4.new4(0.0f, 0.0f, isNegated ? -1.0f : 1.0f, 0.0f);
                        break;
                    }
                    if (str.equalsIgnoreCase("xz")) {
                        plane = P4.new4(0.0f, isNegated ? -1.0f : 1.0f, 0.0f, 0.0f);
                        break;
                    }
                    if (!str.equalsIgnoreCase("yz")) break;
                    plane = P4.new4(isNegated ? -1.0f : 1.0f, 0.0f, 0.0f, 0.0f);
                    break;
                }
                case 8: 
                case 1073742332: {
                    if (!this.isPoint3f(i)) {
                        plane = this.getPoint4f(i);
                        break;
                    }
                }
                case 10: 
                case 1073742325: {
                    P3 pt1 = this.atomCenterOrCoordinateParameter(i, null);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10000030) {
                        ++this.iToken;
                    }
                    P3 pt2 = this.atomCenterOrCoordinateParameter(this.iToken, null);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10000030) {
                        ++this.iToken;
                    }
                    if (this.isFloatParameter(this.iToken)) {
                        float frac = this.floatParameter(this.iToken);
                        plane = new P4();
                        vTemp.sub2(pt2, pt1);
                        vTemp.scale(frac * 2.0f);
                        Measure.getBisectingPlane(pt1, vTemp, vTemp2, vTemp, (P4)plane);
                    } else {
                        P3 pt3 = this.atomCenterOrCoordinateParameter(this.iToken, null);
                        i = this.iToken;
                        V3 norm = new V3();
                        float w = Measure.getNormalThroughPoints(pt1, pt2, pt3, norm, vTemp);
                        plane = new P4();
                        plane.set4(norm.x, norm.y, norm.z, w);
                    }
                    if (this.chk || !Logger.debugging) break;
                    Logger.debug(" defined plane: " + plane);
                }
            }
        }
        if (plane == null) {
            this.errorMore(38, "{a b c d}", "\"xy\" \"xz\" \"yz\" \"x=...\" \"y=...\" \"z=...\"", "$xxxxx");
        }
        if (isNegated) {
            plane.scale4(-1.0f);
        }
        return plane;
    }

    public P4 hklParameter(int i) throws ScriptException {
        P3 pt;
        P4 p;
        if (!this.chk && this.vwr.getCurrentUnitCell() == null) {
            this.error(33);
        }
        if ((p = this.getHklPlane(pt = (P3)this.getPointOrPlane(i, false, true, false, true, 3, 3))) == null) {
            this.error(3);
        }
        if (!this.chk && Logger.debugging) {
            Logger.debug("defined plane: " + p);
        }
        return p;
    }

    public P4 getHklPlane(P3 pt) {
        P3 pt1 = P3.new3(pt.x == 0.0f ? 1.0f : 1.0f / pt.x, 0.0f, 0.0f);
        P3 pt2 = P3.new3(0.0f, pt.y == 0.0f ? 1.0f : 1.0f / pt.y, 0.0f);
        P3 pt3 = P3.new3(0.0f, 0.0f, pt.z == 0.0f ? 1.0f : 1.0f / pt.z);
        if (pt.x == 0.0f && pt.y == 0.0f && pt.z == 0.0f) {
            return null;
        }
        if (pt.x == 0.0f && pt.y == 0.0f) {
            pt1.set(1.0f, 0.0f, pt3.z);
            pt2.set(0.0f, 1.0f, pt3.z);
        } else if (pt.y == 0.0f && pt.z == 0.0f) {
            pt2.set(pt1.x, 0.0f, 1.0f);
            pt3.set(pt1.x, 1.0f, 0.0f);
        } else if (pt.z == 0.0f && pt.x == 0.0f) {
            pt3.set(0.0f, pt2.y, 1.0f);
            pt1.set(1.0f, pt2.y, 0.0f);
        } else if (pt.x == 0.0f) {
            pt1.set(1.0f, pt2.y, 0.0f);
        } else if (pt.y == 0.0f) {
            pt2.set(0.0f, 1.0f, pt3.z);
        } else if (pt.z == 0.0f) {
            pt3.set(pt1.x, 0.0f, 1.0f);
        }
        this.vwr.toCartesian(pt1, false);
        this.vwr.toCartesian(pt2, false);
        this.vwr.toCartesian(pt3, false);
        return Measure.getPlaneThroughPoints(pt1, pt2, pt3, new V3(), new V3(), new P4());
    }

    public Object getPointOrPlane(int index, boolean integerOnly, boolean allowFractional, boolean doConvert, boolean implicitFractional, int minDim, int maxDim) throws ScriptException {
        float[] coord = new float[6];
        int[] code555 = new int[6];
        boolean useCell555P4 = false;
        int n = 0;
        this.coordinatesAreFractional = implicitFractional;
        if (this.tokAt(index) == 8) {
            if (minDim <= 3 && maxDim >= 3) {
                return this.getToken((int)index).value;
            }
            this.invArg();
        }
        if (this.tokAt(index) == 9) {
            if (minDim <= 4 && maxDim >= 4) {
                return this.getToken((int)index).value;
            }
            this.invArg();
        }
        int multiplier = 1;
        block10: for (int i = index; i < this.st.length; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x10000030: 
                case 0x10000060: 
                case 0x10000080: 
                case 1073742332: {
                    continue block10;
                }
                case 0x40000202: {
                    break block10;
                }
                case 0x100000A0: {
                    multiplier = -1;
                    continue block10;
                }
                case 1073742363: {
                    if (n == 6) {
                        this.invArg();
                    }
                    coord[n++] = this.theToken.intValue;
                    multiplier = -1;
                    continue block10;
                }
                case 2: 
                case 1073742362: {
                    if (n == 6) {
                        this.invArg();
                    }
                    if (implicitFractional && this.theToken.intValue > 999999999) {
                        useCell555P4 = true;
                    }
                    code555[n] = this.theToken.intValue;
                    coord[n++] = this.theToken.intValue * multiplier;
                    multiplier = 1;
                    continue block10;
                }
                case 0x100000B0: 
                case 1073742358: {
                    if (!allowFractional) {
                        this.invArg();
                    }
                    if (this.theTok == 0x100000B0) {
                        this.getToken(++i);
                    }
                    if (--n < 0 || integerOnly) {
                        this.invArg();
                    }
                    if (this.theToken.value instanceof Integer || this.theTok == 2) {
                        int n2 = n++;
                        coord[n2] = coord[n2] / (float)(this.theToken.intValue == Integer.MAX_VALUE ? (Integer)this.theToken.value : this.theToken.intValue);
                    } else if (this.theToken.value instanceof Float) {
                        int n3 = n++;
                        coord[n3] = coord[n3] / ((Float)this.theToken.value).floatValue();
                    }
                    this.coordinatesAreFractional = true;
                    continue block10;
                }
                case 0x40000000: 
                case 1073742357: {
                    coord[n++] = Float.NaN;
                    continue block10;
                }
                case 3: 
                case 1073742359: {
                    if (integerOnly) {
                        this.invArg();
                    }
                    if (n == 6) {
                        this.invArg();
                    }
                    coord[n++] = ((Float)this.theToken.value).floatValue();
                    continue block10;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (n < minDim || n > maxDim) {
            this.invArg();
        }
        if (n == 3) {
            if (useCell555P4) {
                return P4.new4(coord[0], coord[1], coord[2], code555[0] % 1000 * 1000 + code555[1] % 1000 + 1000000);
            }
            P3 pt = P3.new3(coord[0], coord[1], coord[2]);
            if (this.coordinatesAreFractional && doConvert) {
                this.fractionalPoint = P3.newP(pt);
                if (!this.chk) {
                    this.vwr.toCartesian(pt, false);
                }
            }
            return pt;
        }
        if (n == 4) {
            if (this.coordinatesAreFractional) {
                this.invArg();
            }
            P4 plane = P4.new4(coord[0], coord[1], coord[2], coord[3]);
            return plane;
        }
        return coord;
    }

    public boolean isPoint3f(int i) {
        int itok = this.tokAt(i);
        if (itok == 0) {
            return false;
        }
        boolean isOK = itok == 8;
        if (isOK || itok == 9 || this.isFloatParameter(i + 1) && this.isFloatParameter(i + 2) && this.isFloatParameter(i + 3) && this.isFloatParameter(i + 4)) {
            return isOK;
        }
        this.ignoreError = true;
        int t = this.iToken;
        isOK = true;
        try {
            this.getPoint3f(i, true);
        }
        catch (Exception e) {
            isOK = false;
        }
        this.ignoreError = false;
        this.iToken = t;
        return isOK;
    }

    public P3 getPoint3f(int i, boolean allowFractional) throws ScriptException {
        return (P3)this.getPointOrPlane(i, false, allowFractional, true, false, 3, 3);
    }

    public P4 getPoint4f(int i) throws ScriptException {
        return (P4)this.getPointOrPlane(i, false, false, false, false, 4, 4);
    }

    public P3 xypParameter(int index) throws ScriptException {
        boolean isPercent;
        int tok = this.tokAt(index);
        if (tok == 1073742195) {
            tok = this.tokAt(++index);
        }
        if (tok != 0x10000040 || !this.isFloatParameter(++index)) {
            return null;
        }
        P3 pt = new P3();
        pt.x = this.floatParameter(index);
        if (this.tokAt(++index) == 0x10000030) {
            ++index;
        }
        if (!this.isFloatParameter(index)) {
            return null;
        }
        pt.y = this.floatParameter(index);
        boolean bl = isPercent = this.tokAt(++index) == 268435634;
        if (isPercent) {
            ++index;
        }
        if (this.tokAt(index) != 0x10000041) {
            return null;
        }
        this.iToken = index;
        pt.z = (float)(isPercent ? -1 : 1) * Float.MAX_VALUE;
        return pt;
    }

    public P4 xyzpParameter(int index) throws ScriptException {
        boolean isPercent;
        int tok = this.tokAt(index);
        if (tok == 1073742195) {
            tok = this.tokAt(++index);
        }
        if (tok != 0x10000040 || !this.isFloatParameter(++index)) {
            return null;
        }
        P4 pt = new P4();
        pt.x = this.floatParameter(index);
        if (this.tokAt(++index) == 0x10000030) {
            ++index;
        }
        if (!this.isFloatParameter(index)) {
            return null;
        }
        pt.y = this.floatParameter(index);
        if (this.tokAt(++index) == 0x10000030) {
            ++index;
        }
        if (!this.isFloatParameter(index)) {
            return null;
        }
        pt.z = this.floatParameter(index);
        boolean bl = isPercent = this.tokAt(++index) == 268435634;
        if (isPercent) {
            ++index;
        }
        if (this.tokAt(index) != 0x10000041) {
            return null;
        }
        this.iToken = index;
        pt.w = (float)(isPercent ? -1 : 1) * Float.MAX_VALUE;
        return pt;
    }

    public String optParameterAsString(int i) throws ScriptException {
        return i >= this.slen ? "" : this.paramAsStr(i);
    }

    public int intParameter(int index) throws ScriptException {
        if (this.checkToken(index) && this.getToken((int)index).tok == 2) {
            return this.theToken.intValue;
        }
        this.error(20);
        return 0;
    }

    public boolean isFloatParameter(int index) {
        switch (this.tokAt(index)) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public float floatParameter(int index) throws ScriptException {
        if (this.checkToken(index)) {
            this.getToken(index);
            switch (this.theTok) {
                case 1073742363: {
                    return -this.theToken.intValue;
                }
                case 2: 
                case 1073742362: {
                    return this.theToken.intValue;
                }
                case 3: 
                case 1073742359: {
                    return ((Float)this.theToken.value).floatValue();
                }
            }
        }
        this.error(34);
        return 0.0f;
    }

    public P3[] getPointArray(int i, int nPoints, boolean allowNull) throws ScriptException {
        if (nPoints == Integer.MAX_VALUE) {
            nPoints = -1;
        }
        P3[] points = nPoints < 0 ? null : new P3[nPoints];
        Lst<P3> vp = nPoints < 0 ? new Lst<P3>() : null;
        int tok = i < 0 ? 7 : this.getToken((int)i++).tok;
        switch (tok) {
            case 7: {
                Lst<SV> v = ((SV)this.theToken).getList();
                if (nPoints >= 0 && v.size() != nPoints) {
                    this.invArg();
                }
                nPoints = v.size();
                if (points == null) {
                    points = new P3[nPoints];
                }
                for (int j = 0; j < nPoints; ++j) {
                    points[j] = SV.ptValue((SV)v.get(j));
                    if (points[j] != null || allowNull) continue;
                    this.invArg();
                }
                return points;
            }
            case 1073742195: {
                tok = this.tokAt(i++);
            }
        }
        if (tok != 0x10000040) {
            this.invArg();
        }
        int n = 0;
        block9: while (tok != 0x10000041 && tok != 0) {
            tok = this.getToken((int)i).tok;
            switch (tok) {
                case 0: 
                case 0x10000041: {
                    continue block9;
                }
                case 0x10000030: {
                    ++i;
                    continue block9;
                }
            }
            if (nPoints >= 0 && n == nPoints) {
                tok = 0;
                continue;
            }
            P3 pt = this.centerParameter(i, null);
            if (points == null) {
                vp.addLast(pt);
            } else {
                points[n] = pt;
            }
            ++n;
            i = this.iToken + 1;
        }
        if (tok != 0x10000041) {
            this.invArg();
        }
        if (points == null) {
            points = vp.toArray(new P3[vp.size()]);
        }
        if (nPoints > 0 && points[nPoints - 1] == null) {
            this.invArg();
        }
        return points;
    }

    public Lst<Object> listParameter(int i, int nMin, int nMax) throws ScriptException {
        return this.listParameter4(i, nMin, nMax, false);
    }

    public Lst<Object> listParameter4(int i, int nMin, int nMax, boolean allowString) throws ScriptException {
        boolean haveSquare;
        Lst<Object> v = new Lst<Object>();
        int tok = this.tokAt(i);
        if (tok == 1073742195) {
            tok = this.tokAt(++i);
        }
        boolean haveBrace = tok == 1073742332;
        boolean bl = haveSquare = tok == 0x10000040;
        if (haveBrace || haveSquare) {
            ++i;
        }
        int n = 0;
        while (n < nMax) {
            tok = this.tokAt(i);
            if (haveBrace && tok == 0x40000202 || haveSquare && tok == 0x10000041) break;
            switch (tok) {
                case 0x10000030: 
                case 0x100000A0: 
                case 1073742332: 
                case 0x40000202: {
                    break;
                }
                case 4: {
                    if (!allowString) break;
                    v.addLast(this.stringParameter(i));
                    break;
                }
                case 9: {
                    P4 pt4 = this.getPoint4f(i);
                    v.addLast(Float.valueOf(pt4.x));
                    v.addLast(Float.valueOf(pt4.y));
                    v.addLast(Float.valueOf(pt4.z));
                    v.addLast(Float.valueOf(pt4.w));
                    n += 4;
                    break;
                }
                default: {
                    if (this.isCenterParameter(i)) {
                        P3 pt = this.centerParameter(i, null);
                        i = this.iToken;
                        v.addLast(Float.valueOf(pt.x));
                        v.addLast(Float.valueOf(pt.y));
                        v.addLast(Float.valueOf(pt.z));
                        n += 3;
                        break;
                    }
                    v.addLast(Float.valueOf(this.floatParameter(i)));
                    ++n;
                }
            }
            i += n == nMax && haveSquare && this.tokAt(i + 1) == 0x40000202 ? 2 : 1;
        }
        if (haveBrace && this.tokAt(i++) != 0x40000202 || haveSquare && this.tokAt(i++) != 0x10000041 || n < nMin || n > nMax) {
            this.invArg();
        }
        this.iToken = i - 1;
        return v;
    }

    public float[] floatParameterSet(int i, int nMin, int nMax) throws ScriptException {
        Lst<Object> v = null;
        float[] fparams = null;
        int n = 0;
        String s = null;
        this.iToken = i;
        switch (this.tokAt(i)) {
            case 4: {
                s = SV.sValue(this.st[i]);
                s = PT.replaceWithCharacter(s, "{},[]\"'", ' ');
                fparams = PT.parseFloatArray(s);
                n = fparams.length;
                break;
            }
            case 7: {
                fparams = SV.flistValue(this.st[i], 0);
                n = fparams.length;
                break;
            }
            default: {
                v = this.listParameter(i, nMin, nMax);
                n = v.size();
            }
        }
        if (n < nMin || n > nMax) {
            this.invArg();
        }
        if (fparams == null) {
            fparams = new float[n];
            for (int j = 0; j < n; ++j) {
                fparams[j] = ((Float)v.get(j)).floatValue();
            }
        }
        return fparams;
    }

    public boolean isArrayParameter(int i) {
        switch (this.tokAt(i)) {
            case 7: 
            case 11: 
            case 12: 
            case 0x10000040: 
            case 1073742195: {
                return true;
            }
        }
        return false;
    }

    public Quat getQuaternionParameter(int i, BS bsAtoms, boolean divideByCurrent) throws ScriptException {
        switch (this.tokAt(i)) {
            case 7: {
                Lst<SV> sv = ((SV)this.getToken(i)).getList();
                P4 p4 = null;
                if (sv.size() == 0 || (p4 = SV.pt4Value((SV)sv.get(0))) == null) {
                    this.invArg();
                }
                return Quat.newP4(p4);
            }
            case 1073741864: {
                return this.chk ? null : (Quat)this.vwr.getOrientationText(1073741864, divideByCurrent ? "best" : "", bsAtoms);
            }
        }
        return Quat.newP4(this.getPoint4f(i));
    }

    public int checkLast(int i) throws ScriptException {
        return this.checkLength(i + 1) - 1;
    }

    public int checkLength(int length) throws ScriptException {
        if (length >= 0) {
            return this.checkLengthErrorPt(length, 0);
        }
        if (this.slen > -length) {
            this.iToken = -length;
            this.bad();
        }
        return this.slen;
    }

    public int checkLengthErrorPt(int length, int errorPt) throws ScriptException {
        if (this.slen != length) {
            int n = this.iToken = errorPt > 0 ? errorPt : this.slen;
            if (errorPt > 0) {
                this.invArg();
            } else {
                this.bad();
            }
        }
        return this.slen;
    }

    public int checkLength23() throws ScriptException {
        this.iToken = this.slen;
        if (this.slen != 2 && this.slen != 3) {
            this.bad();
        }
        return this.slen;
    }

    protected int checkLength34() throws ScriptException {
        this.iToken = this.slen;
        if (this.slen != 3 && this.slen != 4) {
            this.bad();
        }
        return this.slen;
    }

    public int modelNumberParameter(int index) throws ScriptException {
        int iFrame = 0;
        boolean useModelNumber = false;
        switch (this.tokAt(index)) {
            case 2: {
                useModelNumber = true;
            }
            case 3: {
                iFrame = this.getToken((int)index).intValue;
                break;
            }
            case 4: {
                iFrame = ScriptParam.getFloatEncodedInt(this.stringParameter(index));
                break;
            }
            default: {
                this.invArg();
            }
        }
        return this.vwr.ms.getModelNumberIndex(iFrame, useModelNumber, true);
    }

    public int getMadParameter() throws ScriptException {
        int mad = 1;
        switch (this.getToken((int)1).tok) {
            case 1073742072: {
                ((ScriptEval)this).restrictSelected(false, false);
            }
            case 1073742335: {
                break;
            }
            case 1073742334: {
                mad = 0;
                break;
            }
            case 2: {
                int radiusRasMol = this.intParameterRange(1, 0, 750);
                mad = radiusRasMol * 4 * 2;
                break;
            }
            case 3: {
                float f = this.floatParameterRange(1, -3.0f, 3.0f);
                int n = mad = Float.isNaN(f) ? Integer.MAX_VALUE : (int)Math.floor(f * 1000.0f * 2.0f);
                if (mad >= 0) break;
                ((ScriptEval)this).restrictSelected(false, false);
                mad = -mad;
                break;
            }
            default: {
                this.error(6);
            }
        }
        return mad;
    }

    public int intParameterRange(int i, int min, int max) throws ScriptException {
        int val = this.intParameter(i);
        if (val < min || val > max) {
            this.integerOutOfRange(min, max);
            return Integer.MAX_VALUE;
        }
        return val;
    }

    protected float floatParameterRange(int i, float min, float max) throws ScriptException {
        float val = this.floatParameter(i);
        if (val < min || val > max) {
            this.numberOutOfRange(min, max);
            return Float.NaN;
        }
        return val;
    }

    public Lst<P3> getPointVector(T t, int i) throws ScriptException {
        switch (t.tok) {
            case 10: {
                return this.vwr.ms.getAtomPointVector((BS)t.value);
            }
            case 7: {
                Lst<P3> data = new Lst<P3>();
                Lst<SV> pts = ((SV)t).getList();
                for (int j = 0; j < pts.size(); ++j) {
                    P3 pt = SV.ptValue((SV)pts.get(j));
                    if (pt == null) {
                        return null;
                    }
                    data.addLast(pt);
                }
                return data;
            }
        }
        if (i > 0) {
            return this.vwr.ms.getAtomPointVector(((ScriptExpr)this).atomExpressionAt(i));
        }
        return null;
    }

    static int getFloatEncodedInt(String strDecimal) {
        int pt = strDecimal.indexOf(".");
        if (pt < 1 || strDecimal.charAt(0) == '-' || strDecimal.endsWith(".") || strDecimal.contains(".0")) {
            return Integer.MAX_VALUE;
        }
        int i = 0;
        int j = 0;
        if (pt > 0) {
            try {
                i = Integer.parseInt(strDecimal.substring(0, pt));
                if (i < 0) {
                    i = -i;
                }
            }
            catch (NumberFormatException e) {
                i = -1;
            }
        }
        if (pt < strDecimal.length() - 1) {
            try {
                j = Integer.parseInt(strDecimal.substring(pt + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return (i = i * 1000000 + j) < 0 ? Integer.MAX_VALUE : i;
    }

    public static int getPartialBondOrderFromFloatEncodedInt(int bondOrderInteger) {
        return (bondOrderInteger / 1000000 % 7 << 5) + (bondOrderInteger % 1000000 & 0x1F);
    }

    public static int getBondOrderFromString(String s) {
        return s.indexOf(32) < 0 ? Edge.getBondOrderFromString(s) : (s.toLowerCase().indexOf("partial ") == 0 ? ScriptParam.getPartialBondOrderFromString(s.substring(8).trim()) : 131071);
    }

    private static int getPartialBondOrderFromString(String s) {
        return ScriptParam.getPartialBondOrderFromFloatEncodedInt(ScriptParam.getFloatEncodedInt(s));
    }

    public boolean isColorParam(int i) {
        int tok = this.tokAt(i);
        return tok != 0 && (tok == 0x22000022 || tok == 1073742195 || tok == 0x10000040 || tok == 7 || tok == 8 || this.isPoint3f(i) || (tok == 4 || T.tokAttr(tok, 0x40000000)) && CU.getArgbFromString((String)this.st[i].value) != 0);
    }

    public int getArgbParam(int index) throws ScriptException {
        return this.getArgbParamOrNone(index, false);
    }

    protected int getArgbParamLast(int index, boolean allowNone) throws ScriptException {
        int icolor = this.getArgbParamOrNone(index, allowNone);
        this.checkLast(this.iToken);
        return icolor;
    }

    protected int getArgbParamOrNone(int index, boolean allowNone) throws ScriptException {
        P3 pt = null;
        if (this.checkToken(index)) {
            switch (this.getToken((int)index).tok) {
                default: {
                    if (!T.tokAttr(this.theTok, 0x40000000)) break;
                }
                case 4: 
                case 0x22000022: {
                    return CU.getArgbFromString(this.paramAsStr(index));
                }
                case 1073742195: {
                    return this.getColorTriad(index + 2);
                }
                case 0x10000040: {
                    return this.getColorTriad(++index);
                }
                case 7: {
                    float[] rgb = SV.flistValue(this.theToken, 3);
                    if (rgb == null || rgb.length == 3) break;
                    pt = P3.new3(rgb[0], rgb[1], rgb[2]);
                    break;
                }
                case 8: {
                    pt = (P3)this.theToken.value;
                    break;
                }
                case 1073742332: {
                    pt = this.getPoint3f(index, false);
                    break;
                }
                case 1073742333: {
                    if (!allowNone) break;
                    return 0;
                }
            }
        }
        if (pt == null) {
            this.error(8);
        }
        return CU.colorPtToFFRGB(pt);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getColorTriad(int i) throws ScriptException {
        P3 pt;
        String hex;
        int n;
        block22: {
            float[] colors = new float[3];
            n = 0;
            hex = "";
            this.getToken(i);
            pt = null;
            float val = 0.0f;
            switch (this.theTok) {
                case 2: 
                case 3: 
                case 1073742362: {
                    break;
                }
                case 8: {
                    pt = (P3)this.theToken.value;
                    break block22;
                }
                case 0x40000000: {
                    hex = this.paramAsStr(i);
                    break block22;
                }
                default: {
                    this.error(4);
                    break block22;
                }
            }
            while (i < this.slen) {
                block23: {
                    switch (this.getToken((int)i).tok) {
                        case 0x10000030: {
                            break block23;
                        }
                        case 0x40000000: {
                            if (n != 1 || colors[0] != 0.0f) {
                                this.error(4);
                            }
                            hex = "0" + this.paramAsStr(i);
                            break block22;
                        }
                        case 3: {
                            if (n > 2) {
                                this.error(4);
                            }
                            val = this.floatParameter(i);
                            break;
                        }
                        case 2: {
                            if (n > 2) {
                                this.error(4);
                            }
                            val = this.theToken.intValue;
                            break;
                        }
                        case 1073742362: {
                            if (n > 2) {
                                this.error(4);
                            }
                            val = (Integer)this.theToken.value % 256;
                            break;
                        }
                        case 0x10000041: {
                            if (n != 3) {
                                this.error(4);
                            }
                            --i;
                            pt = P3.new3(colors[0], colors[1], colors[2]);
                            break block22;
                        }
                        default: {
                            this.error(4);
                        }
                    }
                    colors[n++] = val;
                }
                ++i;
            }
            this.error(4);
        }
        if (this.getToken((int)(++i)).tok != 0x10000041) {
            this.error(4);
        }
        if (pt != null) {
            return CU.colorPtToFFRGB(pt);
        }
        n = CU.getArgbFromString("[" + hex + "]");
        if (n == 0) {
            this.error(4);
        }
        return n;
    }

    public TickInfo tickParamAsStr(int index, boolean allowUnitCell, boolean allowScale, boolean allowFirst) throws ScriptException {
        this.iToken = index - 1;
        if (this.tokAt(index) != 1073742164) {
            return null;
        }
        String str = " ";
        switch (this.tokAt(index + 1)) {
            case 1111492629: 
            case 1111492630: 
            case 1111492631: {
                str = this.paramAsStr(++index).toLowerCase();
                break;
            }
            case 0x40000000: {
                this.invArg();
            }
        }
        if (this.tokAt(++index) == 1073742333) {
            TickInfo tickInfo = new TickInfo(null);
            tickInfo.type = str;
            this.iToken = index;
            return tickInfo;
        }
        TickInfo tickInfo = new TickInfo((P3)this.getPointOrPlane(index, false, true, false, false, 3, 3));
        if (this.coordinatesAreFractional || this.tokAt(this.iToken + 1) == 1814695966) {
            tickInfo.scale = P3.new3(Float.NaN, Float.NaN, Float.NaN);
            allowScale = false;
        }
        if (this.tokAt(this.iToken + 1) == 1814695966) {
            ++this.iToken;
        }
        tickInfo.type = str;
        if (this.tokAt(this.iToken + 1) == 1287653388) {
            tickInfo.tickLabelFormats = this.stringParameterSet(this.iToken + 2);
        }
        if (!allowScale) {
            return tickInfo;
        }
        if (this.tokAt(this.iToken + 1) == 1073742138) {
            if (this.isFloatParameter(this.iToken + 2)) {
                float f = this.floatParameter(this.iToken + 2);
                tickInfo.scale = P3.new3(f, f, f);
            } else {
                tickInfo.scale = this.getPoint3f(this.iToken + 2, true);
            }
        }
        if (allowFirst && this.tokAt(this.iToken + 1) == 1073741942) {
            tickInfo.first = this.floatParameter(this.iToken + 2);
        }
        return tickInfo;
    }

    public void setBooleanProperty(String key, boolean value) {
        if (!this.chk) {
            this.vwr.setBooleanProperty(key, value);
        }
    }

    protected boolean setIntProperty(String key, int value) {
        if (!this.chk) {
            this.vwr.setIntProperty(key, value);
        }
        return true;
    }

    protected boolean setFloatProperty(String key, float value) {
        if (!this.chk) {
            this.vwr.setFloatProperty(key, value);
        }
        return true;
    }

    protected void setStringProperty(String key, String value) {
        if (!this.chk) {
            this.vwr.setStringProperty(key, value);
        }
    }
}

