/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.menu;

import com.github.weisj.darklaf.ui.UIAction;
import com.github.weisj.darklaf.ui.menu.MenuItemUI;
import com.github.weisj.darklaf.util.LazyActionMap;
import com.intellij.util.ui.MenuItemLayoutHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class DarkMenuItemUIBase
extends BasicMenuItemUI
implements MenuItemUI {
    protected int acceleratorTextOffset;
    protected boolean useEvenHeight;
    private boolean closeOnClick;

    public static ComponentUI createUI(JComponent c) {
        return new DarkMenuItemUIBase();
    }

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("doClick"));
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.closeOnClick = !UIManager.getBoolean(this.getPropertyPrefix() + ".doNotCloseOnMouseClick");
        this.useEvenHeight = !Boolean.TRUE.equals(UIManager.get(this.getPropertyPrefix() + ".evenHeight"));
        this.acceleratorTextOffset = UIManager.getInt(this.getPropertyPrefix() + ".acceleratorTextOffset");
        this.acceleratorFont = UIManager.getFont("MenuItem.font");
        this.acceleratorForeground = UIManager.getColor("MenuItem.foreground");
        this.acceleratorSelectionForeground = UIManager.getColor("MenuItem.selectionForeground");
        this.disabledForeground = UIManager.getColor("MenuItem.disabledForeground");
    }

    @Override
    public void uninstallUI(JComponent c) {
        MenuItemLayoutHelper.clearUsedParentClientProperties(this.menuItem);
        super.uninstallUI(c);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        LazyActionMap.installLazyActionMap(this.menuItem, DarkMenuItemUIBase.class, this.getPropertyPrefix() + ".actionMap");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.isSelected(c) ? this.selectionForeground : c.getForeground(), this.defaultTextIconGap);
    }

    protected boolean isSelected(JComponent menuItem) {
        if (!(menuItem instanceof JMenuItem)) {
            return false;
        }
        return menuItem.isEnabled() && ((JMenuItem)menuItem).isArmed();
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        this.paintMenuItemImpl(g, c, checkIcon, arrowIcon, background, foreground, defaultTextIconGap);
    }

    @Override
    public MenuItemLayoutHelper getMenuItemLayoutHelper(Icon checkIcon, Icon arrowIcon, int defaultTextIconGap, JMenuItem mi, Rectangle viewRect) {
        return DarkMenuItemUIBase.getMenuItemLayoutHelperImpl(this.acceleratorDelimiter, this.acceleratorFont, this.getPropertyPrefix(), checkIcon, arrowIcon, defaultTextIconGap, mi, viewRect);
    }

    @Override
    public String getPropertyPrefix() {
        return super.getPropertyPrefix();
    }

    @Override
    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    @Override
    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    @Override
    public Color getAcceleratorSelectionForeground() {
        return this.acceleratorSelectionForeground;
    }

    @Override
    public Color getAcceleratorForeground() {
        return this.acceleratorForeground;
    }

    @Override
    public int getAcceleratorTextOffset() {
        return this.acceleratorTextOffset;
    }

    @Override
    public boolean isUseEvenHeight() {
        return this.useEvenHeight;
    }

    protected static MenuItemLayoutHelper getMenuItemLayoutHelperImpl(String acceleratorDelimiter, Font acceleratorFont, String propertyPrefix, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap, JMenuItem mi, Rectangle viewRect) {
        return new MenuItemLayoutHelper(mi, checkIcon, arrowIcon, viewRect, defaultTextIconGap, acceleratorDelimiter, mi.getComponentOrientation().isLeftToRight(), mi.getFont(), acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(mi), propertyPrefix);
    }

    @Override
    protected void doClick(MenuSelectionManager selectionManager) {
        if (this.isCloseOnClick()) {
            MenuSelectionManager msm = selectionManager;
            if (msm == null) {
                msm = MenuSelectionManager.defaultManager();
            }
            msm.clearSelectedPath();
        }
        JMenuItem item = this.menuItem;
        item.doClick(0);
        item.setArmed(!this.isCloseOnClick());
    }

    protected boolean isCloseOnClick() {
        return this.closeOnClick;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        return this.getPreferredMenuItemSizeImpl(c, checkIcon, arrowIcon, defaultTextIconGap);
    }

    protected static class Actions
    extends UIAction {
        protected static final String CLICK = "doClick";

        protected Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }
}

