/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.Timer;
import jetbrains.datalore.base.geometry.Rectangle;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.batik.gvt.GraphicsNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0016\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/vis/swing/BatikMapperComponentRepaintManager;", "", "component", "Ljava/awt/Component;", "delay", "", "(Ljava/awt/Component;I)V", "dirtyRects", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Ljetbrains/datalore/base/geometry/Rectangle;", "timer", "Ljavax/swing/Timer;", "repaintBounds", "", "clipBounts", "repaintComponent", "clipBoundsSet", "", "repaintNode", "node", "Lorg/apache/batik/gvt/GraphicsNode;", "stop", "vis-svg-mapper-batik"})
public final class BatikMapperComponentRepaintManager {
    @NotNull
    private final Component component;
    @NotNull
    private final AtomicReference<Set<Rectangle>> dirtyRects;
    @NotNull
    private final Timer timer;

    /*
     * WARNING - void declaration
     */
    public BatikMapperComponentRepaintManager(@NotNull Component component, int delay) {
        void $this$timer_u24lambda_u241;
        Timer timer;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = component;
        this.dirtyRects = new AtomicReference(new LinkedHashSet());
        Timer timer2 = timer = new Timer(delay, arg_0 -> BatikMapperComponentRepaintManager.timer$lambda$0(this, arg_0));
        BatikMapperComponentRepaintManager batikMapperComponentRepaintManager = this;
        boolean bl = false;
        $this$timer_u24lambda_u241.setRepeats(false);
        batikMapperComponentRepaintManager.timer = timer;
    }

    public final void repaintNode(@NotNull GraphicsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!node.isVisible()) {
            return;
        }
        Rectangle2D bounds = node.getTransformedBounds(new AffineTransform());
        if (bounds == null) {
            return;
        }
        int ext = 1;
        Rectangle clipBounts = new Rectangle((int)bounds.getX() - ext, (int)bounds.getY() - ext, (int)Math.ceil(bounds.getWidth()) + 2 * ext, (int)Math.ceil(bounds.getHeight()) + 2 * ext);
        this.repaintBounds(clipBounts);
    }

    private final void repaintBounds(Rectangle clipBounts) {
        if (clipBounts.isEmpty()) {
            return;
        }
        this.dirtyRects.get().add(clipBounts);
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void repaintComponent(Set<Rectangle> clipBoundsSet) {
        List rawBounds = CollectionsKt.toList((Iterable)clipBoundsSet);
        ArrayList<Object> unitedBounds = new ArrayList<Object>();
        while (!((Collection)rawBounds).isEmpty()) {
            Object r0 = null;
            r0 = CollectionsKt.first((List)rawBounds);
            if (rawBounds.size() == 1) {
                rawBounds = CollectionsKt.emptyList();
            } else {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = rawBounds.subList(1, rawBounds.size());
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Rectangle rectangle;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Rectangle it = (Rectangle)element$iv$iv;
                    boolean bl2 = false;
                    if (((Rectangle)r0).intersects(it)) {
                        r0 = ((Rectangle)r0).union(it);
                        rectangle = null;
                    } else {
                        rectangle = it;
                    }
                    if (rectangle == null) continue;
                    Rectangle it$iv$iv = rectangle;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                rawBounds = (List)destination$iv$iv;
            }
            unitedBounds.add(r0);
        }
        Iterable $this$forEach$iv = unitedBounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rectangle it = (Rectangle)element$iv;
            boolean bl = false;
            Component component = this.component;
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            ((JComponent)component).paintImmediately(it.getOrigin().getX(), it.getOrigin().getY(), it.getDimension().getX(), it.getDimension().getY());
        }
    }

    public final void stop() {
        this.timer.stop();
    }

    private static final void timer$lambda$0(BatikMapperComponentRepaintManager this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Set clipBoundsSet = this$0.dirtyRects.getAndSet(new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue((Object)clipBoundsSet, (String)"clipBoundsSet");
        this$0.repaintComponent(clipBoundsSet);
    }
}

