/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows;

import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.platform.decorations.CustomTitlePane;
import com.github.weisj.darklaf.platform.decorations.DecorationsProvider;
import com.github.weisj.darklaf.platform.decorations.UnsupportedProviderException;
import com.github.weisj.darklaf.platform.windows.JNIDecorationsWindows;
import com.github.weisj.darklaf.platform.windows.PointerUtil;
import com.github.weisj.darklaf.platform.windows.WindowsLibrary;
import com.github.weisj.darklaf.platform.windows.ui.WindowsTitlePane;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Properties;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.UIDefaults;
import javax.swing.border.Border;

public class WindowsDecorationsProvider
implements DecorationsProvider {
    public WindowsDecorationsProvider() throws UnsupportedProviderException {
        if (!SystemInfo.isWindows10) {
            throw new UnsupportedProviderException("Only supported on Windows 10 or later");
        }
        if (!WindowsLibrary.get().canLoad()) {
            throw new UnsupportedProviderException("Native components aren't supported");
        }
    }

    public CustomTitlePane createTitlePane(JRootPane rootPane, int decorationStyle, Window window) {
        return new WindowsTitlePane(rootPane, decorationStyle, window);
    }

    public boolean isCustomDecorationSupported() {
        return WindowsLibrary.get().isLoaded();
    }

    public void initialize() {
        WindowsLibrary.get().updateLibrary();
    }

    public void installPopupWindow(Window window) {
        long hwnd;
        if (!window.isDisplayable()) {
            window.addNotify();
        }
        if ((hwnd = PointerUtil.getHWND(window)) > 0L) {
            JNIDecorationsWindows.installPopupMenuDecorations(hwnd);
            if (window instanceof RootPaneContainer) {
                Color bg;
                JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                Color color = bg = rootPane != null ? rootPane.getBackground() : null;
                if (bg != null) {
                    JNIDecorationsWindows.setBackground(hwnd, bg.getRed(), bg.getGreen(), bg.getBlue());
                }
            }
        }
    }

    public void uninstallPopupWindow(Window window) {
        if (window.isDisplayable()) {
            long hwnd = PointerUtil.getHWND(window);
            if (hwnd != 0L) {
                JNIDecorationsWindows.uninstallDecorations(hwnd, false);
            }
            window.dispose();
        }
    }

    public void adjustContentArea(JRootPane root, Rectangle rect) {
        Border border = root.getBorder();
        if (border != null) {
            Insets ins = border.getBorderInsets(root);
            rect.x -= ins.left;
            rect.y -= ins.top;
        }
    }

    public void adjustWindowInsets(Window window, Insets i) {
        if (window != null) {
            Insets insets = window.getInsets();
            i.left -= insets.left;
            i.right -= insets.right;
            i.top -= insets.top;
            i.bottom -= insets.bottom;
        }
    }

    public void loadDecorationProperties(Properties properties, UIDefaults currentDefaults) {
        IconLoader iconLoader = IconLoader.get(WindowsDecorationsProvider.class);
        PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(WindowsDecorationsProvider.class, (String)"windows_decorations", (String)""), (Properties)properties, (UIDefaults)currentDefaults, (IconLoader)iconLoader);
        PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(WindowsDecorationsProvider.class, (String)"windows_icons", (String)""), (Properties)properties, (UIDefaults)currentDefaults, (IconLoader)iconLoader);
    }
}

