/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.AbstractRealDistribution;
import jetbrains.datalore.plot.base.stat.math3.Gamma;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0014\u0010\u000b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000f\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/GammaDistribution;", "Ljetbrains/datalore/plot/base/stat/math3/AbstractRealDistribution;", "alpha", "", "beta", "gammaEpsilon", "solverAbsoluteAccuracy", "(DDDD)V", "isSupportConnected", "", "()Z", "isSupportLowerBoundInclusive", "isSupportUpperBoundInclusive", "numericalMean", "getNumericalMean", "()D", "numericalVariance", "getNumericalVariance", "getSolverAbsoluteAccuracy", "supportLowerBound", "getSupportLowerBound", "supportUpperBound", "getSupportUpperBound", "cumulativeProbability", "x", "density", "probability", "Companion", "plot-base-portable"})
public final class GammaDistribution
extends AbstractRealDistribution {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double alpha;
    private final double beta;
    private final double gammaEpsilon;
    private final double solverAbsoluteAccuracy;
    private final double numericalMean;
    private final double numericalVariance;
    private final double supportLowerBound;
    private final double supportUpperBound;
    private final boolean isSupportLowerBoundInclusive;
    private final boolean isSupportUpperBoundInclusive;
    private final boolean isSupportConnected;
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    public static final double DEFAULT_GAMMA_EPSILON = 1.0E-14;

    @JvmOverloads
    public GammaDistribution(double alpha, double beta, double gammaEpsilon, double solverAbsoluteAccuracy) {
        this.alpha = alpha;
        this.beta = beta;
        this.gammaEpsilon = gammaEpsilon;
        this.solverAbsoluteAccuracy = solverAbsoluteAccuracy;
        this.numericalMean = this.alpha / this.beta;
        this.numericalVariance = this.alpha / Math.pow(this.beta, 2);
        this.supportUpperBound = Double.POSITIVE_INFINITY;
        this.isSupportConnected = true;
        if (this.alpha <= 0.0) {
            throw new IllegalStateException(("NotStrictlyPositive - alpha: " + this.alpha).toString());
        }
        if (this.beta <= 0.0) {
            throw new IllegalStateException(("NotStrictlyPositive - beta: " + this.beta).toString());
        }
    }

    public /* synthetic */ GammaDistribution(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d3 = 1.0E-14;
        }
        if ((n & 8) != 0) {
            d4 = 1.0E-9;
        }
        this(d, d2, d3, d4);
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    @Override
    public double getNumericalMean() {
        return this.numericalMean;
    }

    @Override
    public double getNumericalVariance() {
        return this.numericalVariance;
    }

    @Override
    public double getSupportLowerBound() {
        return this.supportLowerBound;
    }

    @Override
    public double getSupportUpperBound() {
        return this.supportUpperBound;
    }

    @Override
    public boolean isSupportLowerBoundInclusive() {
        return this.isSupportLowerBoundInclusive;
    }

    @Override
    public boolean isSupportUpperBoundInclusive() {
        return this.isSupportUpperBoundInclusive;
    }

    @Override
    public boolean isSupportConnected() {
        return this.isSupportConnected;
    }

    @Override
    public double probability(double x) {
        return 0.0;
    }

    @Override
    public double density(double x) {
        Function1 gamma2 = (Function1)new Function1<Double, Double>(this){
            final /* synthetic */ GammaDistribution this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Double invoke(double t) {
                return Gamma.regularizedGammaP$default(Gamma.INSTANCE, GammaDistribution.access$getAlpha$p(this.this$0), GammaDistribution.access$getBeta$p(this.this$0) * t, GammaDistribution.access$getGammaEpsilon$p(this.this$0), 0, 8, null);
            }
        };
        double h = Math.sqrt(this.gammaEpsilon) * x;
        return (((Number)gamma2.invoke((Object)(x + h))).doubleValue() - ((Number)gamma2.invoke((Object)(x - h))).doubleValue()) / (2.0 * h);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x > 37.0) {
            return 1.0;
        }
        return Gamma.regularizedGammaP$default(Gamma.INSTANCE, this.alpha, this.beta * x, this.gammaEpsilon, 0, 8, null);
    }

    @JvmOverloads
    public GammaDistribution(double alpha, double beta, double gammaEpsilon) {
        this(alpha, beta, gammaEpsilon, 0.0, 8, null);
    }

    @JvmOverloads
    public GammaDistribution(double alpha, double beta) {
        this(alpha, beta, 0.0, 0.0, 12, null);
    }

    public static final /* synthetic */ double access$getAlpha$p(GammaDistribution $this) {
        return $this.alpha;
    }

    public static final /* synthetic */ double access$getBeta$p(GammaDistribution $this) {
        return $this.beta;
    }

    public static final /* synthetic */ double access$getGammaEpsilon$p(GammaDistribution $this) {
        return $this.gammaEpsilon;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/GammaDistribution$Companion;", "", "()V", "DEFAULT_GAMMA_EPSILON", "", "DEFAULT_INVERSE_ABSOLUTE_ACCURACY", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

