/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BinStat;
import jetbrains.datalore.plot.base.stat.BinStatUtil;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.plot.common.util.MutableDouble;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003!\"#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J&\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000e2\u0006\u0010\t\u001a\u00020\nJL\u0010\u0013\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0002J>\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000e2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ljetbrains/datalore/plot/base/stat/BinStatUtil;", "", "()V", "MAX_BIN_COUNT", "", "binCountAndWidth", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$CountAndWidth;", "dataRange", "", "binOptions", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinOptions;", "computeDotdensityBins", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinsData;", "valuesX", "", "binWidth", "computeDotdensityStatSeries", "rangeX", "Ljetbrains/datalore/base/interval/DoubleSpan;", "computeHistogramBins", "startX", "binCount", "weightAtIndex", "Lkotlin/Function1;", "densityNormalizingFactor", "computeHistogramStatSeries", "data", "Ljetbrains/datalore/plot/base/DataFrame;", "xPosKind", "Ljetbrains/datalore/plot/base/stat/BinStat$XPosKind;", "xPos", "weightVector", "dataLength", "BinOptions", "BinsData", "CountAndWidth", "plot-base-portable"})
public final class BinStatUtil {
    @NotNull
    public static final BinStatUtil INSTANCE = new BinStatUtil();
    private static final int MAX_BIN_COUNT = 500;

    private BinStatUtil() {
    }

    @NotNull
    public final Function1<Integer, Double> weightAtIndex(@NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.has(TransformVar.INSTANCE.getWEIGHT())) {
            List<Double> weights = data.getNumeric(TransformVar.INSTANCE.getWEIGHT());
            return (Function1)new Function1<Integer, Double>(weights){
                final /* synthetic */ List<Double> $weights;
                {
                    this.$weights = $weights;
                    super(1);
                }

                @NotNull
                public final Double invoke(int index) {
                    Double weight = this.$weights.get(index);
                    return SeriesUtil.INSTANCE.asFinite(weight, 0.0);
                }
            };
        }
        return weightAtIndex.2.INSTANCE;
    }

    @NotNull
    public final List<Double> weightVector(int dataLength, @NotNull DataFrame data) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.has(TransformVar.INSTANCE.getWEIGHT())) {
            list2 = data.getNumeric(TransformVar.INSTANCE.getWEIGHT());
        } else {
            ArrayList<Double> arrayList = new ArrayList<Double>(dataLength);
            int n = 0;
            while (n < dataLength) {
                int n2;
                int n3 = n2 = n++;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(1.0);
            }
            list2 = arrayList;
        }
        return list2;
    }

    @NotNull
    public final CountAndWidth binCountAndWidth(double dataRange, @NotNull BinOptions binOptions) {
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        int binCount = binOptions.getBinCount();
        double binWidth = 0.0;
        if (binOptions.hasBinWidth()) {
            Double d = binOptions.getBinWidth();
            Intrinsics.checkNotNull((Object)d);
            binWidth = d;
            double count = dataRange / binWidth;
            count = Math.min(500.0, count);
            binCount = (int)Math.ceil(count);
        } else {
            binWidth = dataRange / (double)binCount;
        }
        return new CountAndWidth(binCount, binWidth);
    }

    @NotNull
    public final BinsData computeHistogramStatSeries(@NotNull DataFrame data, @NotNull DoubleSpan rangeX, @NotNull List<Double> valuesX, @NotNull BinStat.XPosKind xPosKind, double xPos, @NotNull BinOptions binOptions) {
        double normalBinWidth;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)rangeX, (String)"rangeX");
        Intrinsics.checkNotNullParameter(valuesX, (String)"valuesX");
        Intrinsics.checkNotNullParameter((Object)((Object)xPosKind), (String)"xPosKind");
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        Double startX = rangeX.getLowerEnd();
        double d = rangeX.getUpperEnd();
        Double d2 = startX;
        Intrinsics.checkNotNull((Object)d2);
        double spanX = d - d2;
        CountAndWidth b2 = this.binCountAndWidth(spanX, binOptions);
        startX = startX - b2.getWidth() * 0.7;
        spanX += b2.getWidth() * 1.4;
        b2 = this.binCountAndWidth(spanX, binOptions);
        int binCount = b2.getCount();
        double binWidth = b2.getWidth();
        if (xPosKind != BinStat.XPosKind.NONE) {
            double minDelta = Double.MAX_VALUE;
            double x = xPos;
            for (int i = 0; i < binCount; ++i) {
                double binLeft = startX + (double)i * binWidth;
                double delta = 0.0;
                if (xPosKind == BinStat.XPosKind.CENTER) {
                    delta = x - (binLeft + binWidth / (double)2);
                } else {
                    if (i == 0) {
                        minDelta = x - startX;
                    }
                    delta = x - (binLeft + binWidth);
                }
                if (!(Math.abs(delta) < Math.abs(minDelta))) continue;
                minDelta = delta;
            }
            double offset = minDelta % (binWidth / (double)2);
            startX = startX + offset;
        }
        double densityNormalizingFactor = (normalBinWidth = rangeX.getLength() / (double)binCount) > 0.0 ? 1.0 / normalBinWidth : 1.0;
        BinsData binsData = this.computeHistogramBins(valuesX, startX, binCount, binWidth, this.weightAtIndex(data), densityNormalizingFactor);
        if (!(binsData.getX$plot_base_portable().size() == binCount)) {
            boolean bl = false;
            String string = "Internal: stat data size=" + binsData.getX$plot_base_portable().size() + " expected bin count=" + binCount;
            throw new IllegalStateException(string.toString());
        }
        return binsData;
    }

    @NotNull
    public final BinsData computeDotdensityStatSeries(@NotNull DoubleSpan rangeX, @NotNull List<Double> valuesX, @NotNull BinOptions binOptions) {
        Intrinsics.checkNotNullParameter((Object)rangeX, (String)"rangeX");
        Intrinsics.checkNotNullParameter(valuesX, (String)"valuesX");
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        double spanX = rangeX.getLength();
        double binWidth = spanX > 0.0 ? this.binCountAndWidth(spanX, binOptions).getWidth() : 1.0;
        return this.computeDotdensityBins(valuesX, binWidth);
    }

    private final BinsData computeHistogramBins(List<Double> valuesX, double startX, int binCount, double binWidth, Function1<? super Integer, Double> weightAtIndex2, double densityNormalizingFactor) {
        ArrayList<Double> arrayList;
        double totalCount = 0.0;
        HashMap countByBinIndex = new HashMap();
        int n = valuesX.size();
        for (int dataIndex = 0; dataIndex < n; ++dataIndex) {
            Double x = valuesX.get(dataIndex);
            if (!SeriesUtil.INSTANCE.isFinite(x)) continue;
            double weight = ((Number)weightAtIndex2.invoke((Object)dataIndex)).doubleValue();
            totalCount += weight;
            Double d = x;
            Intrinsics.checkNotNull((Object)d);
            int binIndex = (int)Math.floor((d - startX) / binWidth);
            if (!countByBinIndex.containsKey(binIndex)) {
                Integer n2 = binIndex;
                ((Map)countByBinIndex).put(n2, new MutableDouble(0.0));
            }
            Object v = countByBinIndex.get(binIndex);
            Intrinsics.checkNotNull(v);
            ((MutableDouble)v).getAndAdd(weight);
        }
        ArrayList<Double> x = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> densities = new ArrayList<Double>();
        double x0 = startX + binWidth / (double)2;
        for (int i = 0; i < binCount; ++i) {
            x.add(x0 + (double)i * binWidth);
            double count = 0.0;
            if (countByBinIndex.containsKey(i)) {
                Object v = countByBinIndex.get(i);
                Intrinsics.checkNotNull(v);
                count = ((MutableDouble)v).get();
            }
            counts.add(count);
            double density2 = count / totalCount * densityNormalizingFactor;
            densities.add(density2);
        }
        int n3 = x.size();
        List list2 = densities;
        List list3 = counts;
        List list4 = x;
        ArrayList<Double> arrayList2 = new ArrayList<Double>(n3);
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6 = n5 = n4++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(binWidth);
        }
        ArrayList<Double> arrayList3 = arrayList = (ArrayList<Double>)arrayList2;
        List list5 = list2;
        List list6 = list3;
        List list7 = list4;
        return new BinsData(list7, list6, list5, arrayList3);
    }

    /*
     * WARNING - void declaration
     */
    private final BinsData computeDotdensityBins(List<Double> valuesX, double binWidth) {
        Object[] $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        Double it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = valuesX;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (Double)t;
            bl = false;
            if (!SeriesUtil.INSTANCE.isFinite(it)) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (Double)t;
            Collection collection = destination$iv$iv;
            bl = false;
            Double d = it;
            Intrinsics.checkNotNull((Object)d);
            collection.add(Double.valueOf(d));
        }
        List sortedX = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        BinsData binsData = new BinsData(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
        if (sortedX.isEmpty()) {
            return binsData;
        }
        $this$mapTo$iv$iv = new Double[]{(Double)CollectionsKt.first((List)sortedX)};
        List stack = CollectionsKt.mutableListOf((Object[])$this$mapTo$iv$iv);
        int n = sortedX.size();
        for (int i = 1; i < n; ++i) {
            if (((Number)sortedX.get(i)).doubleValue() - ((Number)CollectionsKt.first((List)stack)).doubleValue() < binWidth) {
                stack.add(sortedX.get(i));
                continue;
            }
            binsData = BinStatUtil.computeDotdensityBins$updateBinsData(binWidth, binsData, stack, sortedX.size());
            Object[] objectArray = new Double[]{(Double)sortedX.get(i)};
            stack = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        binsData = BinStatUtil.computeDotdensityBins$updateBinsData(binWidth, binsData, stack, sortedX.size());
        return binsData;
    }

    private static final BinsData computeDotdensityBins$updateBinsData(double $binWidth, BinsData binsData, List<Double> stack, int dataSize) {
        double v = (((Number)CollectionsKt.last(stack)).doubleValue() - ((Number)CollectionsKt.first(stack)).doubleValue()) / 2.0;
        return new BinsData(CollectionsKt.plus((Collection)binsData.getX$plot_base_portable(), (Iterable)CollectionsKt.listOf((Object)(((Number)CollectionsKt.first(stack)).doubleValue() + v))), CollectionsKt.plus((Collection)binsData.getCount$plot_base_portable(), (Iterable)CollectionsKt.listOf((Object)stack.size())), CollectionsKt.plus((Collection)binsData.getDensity$plot_base_portable(), (Iterable)CollectionsKt.listOf((Object)((double)stack.size() / (double)dataSize))), CollectionsKt.plus((Collection)binsData.getBinWidth$plot_base_portable(), (Iterable)CollectionsKt.listOf((Object)$binWidth)));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinOptions;", "", "binCount", "", "binWidth", "", "(ILjava/lang/Double;)V", "getBinCount", "()I", "getBinWidth", "()Ljava/lang/Double;", "Ljava/lang/Double;", "hasBinWidth", "", "plot-base-portable"})
    public static final class BinOptions {
        @Nullable
        private final Double binWidth;
        private final int binCount;

        public BinOptions(int binCount, @Nullable Double binWidth) {
            this.binWidth = binWidth;
            this.binCount = Math.min(500, Math.max(1, binCount));
        }

        @Nullable
        public final Double getBinWidth() {
            return this.binWidth;
        }

        public final int getBinCount() {
            return this.binCount;
        }

        public final boolean hasBinWidth() {
            return this.binWidth != null && this.binWidth > 0.0;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/base/stat/BinStatUtil$CountAndWidth;", "", "count", "", "width", "", "(ID)V", "getCount", "()I", "getWidth", "()D", "plot-base-portable"})
    public static final class CountAndWidth {
        private final int count;
        private final double width;

        public CountAndWidth(int count, double width2) {
            this.count = count;
            this.width = width2;
        }

        public final int getCount() {
            return this.count;
        }

        public final double getWidth() {
            return this.width;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\n\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinsData;", "", "x", "", "", "count", "density", "binWidth", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getBinWidth$plot_base_portable", "()Ljava/util/List;", "getCount$plot_base_portable", "getDensity$plot_base_portable", "getX$plot_base_portable", "plot-base-portable"})
    public static final class BinsData {
        @NotNull
        private final List<Double> x;
        @NotNull
        private final List<Double> count;
        @NotNull
        private final List<Double> density;
        @NotNull
        private final List<Double> binWidth;

        public BinsData(@NotNull List<Double> x, @NotNull List<Double> count, @NotNull List<Double> density2, @NotNull List<Double> binWidth) {
            Intrinsics.checkNotNullParameter(x, (String)"x");
            Intrinsics.checkNotNullParameter(count, (String)"count");
            Intrinsics.checkNotNullParameter(density2, (String)"density");
            Intrinsics.checkNotNullParameter(binWidth, (String)"binWidth");
            this.x = x;
            this.count = count;
            this.density = density2;
            this.binWidth = binWidth;
        }

        @NotNull
        public final List<Double> getX$plot_base_portable() {
            return this.x;
        }

        @NotNull
        public final List<Double> getCount$plot_base_portable() {
            return this.count;
        }

        @NotNull
        public final List<Double> getDensity$plot_base_portable() {
            return this.density;
        }

        @NotNull
        public final List<Double> getBinWidth$plot_base_portable() {
            return this.binWidth;
        }
    }
}

