/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.ContinuousTransform;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.Transform;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0006\u001a\u00020\fJ\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/base/scale/ScaleUtil;", "", "()V", "applyInverseTransform", "Ljetbrains/datalore/base/interval/DoubleSpan;", "r", "transform", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "applyTransform", "", "", "source", "Ljetbrains/datalore/plot/base/Transform;", "labelByBreak", "", "", "scale", "Ljetbrains/datalore/plot/base/Scale;", "transformedDefinedLimits", "Lkotlin/Pair;", "plot-base-portable"})
public final class ScaleUtil {
    @NotNull
    public static final ScaleUtil INSTANCE = new ScaleUtil();

    private ScaleUtil() {
    }

    @NotNull
    public final Map<Object, String> labelByBreak(@NotNull Scale scale) {
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        ScaleBreaks scaleBreaks = scale.getScaleBreaks();
        return MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)scaleBreaks.getDomainValues(), (Iterable)scaleBreaks.getLabels()));
    }

    @NotNull
    public final Pair<Double, Double> transformedDefinedLimits(@NotNull ContinuousTransform transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Double d = transform.apply((Double)transform.definedLimits().getFirst());
        Double d2 = transform.apply((Double)transform.definedLimits().getSecond());
        Pair pair = new Pair((Object)(d != null ? d : Double.NaN), (Object)(d2 != null ? d2 : Double.NaN));
        double lower = ((Number)pair.component1()).doubleValue();
        double upper = ((Number)pair.component2()).doubleValue();
        return SeriesUtil.INSTANCE.allFinite(Double.valueOf(lower), Double.valueOf(upper)) ? new Pair((Object)Math.min(lower, upper), (Object)Math.max(lower, upper)) : new Pair((Object)lower, (Object)upper);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> applyTransform(@NotNull List<?> source, @NotNull Transform transform) {
        List list2;
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        if (transform.hasDomainLimits()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = source;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(transform.isInDomain(it) ? it : null);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = source;
        }
        List source2 = list2;
        return transform.apply(source2);
    }

    @NotNull
    public final DoubleSpan applyTransform(@NotNull DoubleSpan r, @NotNull ContinuousTransform transform) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Double d = transform.apply(r.getLowerEnd());
        Intrinsics.checkNotNull((Object)d);
        double a2 = d;
        Double d2 = transform.apply(r.getUpperEnd());
        Intrinsics.checkNotNull((Object)d2);
        double b2 = d2;
        return new DoubleSpan(Math.min(a2, b2), Math.max(a2, b2));
    }

    @NotNull
    public final DoubleSpan applyInverseTransform(@NotNull DoubleSpan r, @NotNull ContinuousTransform transform) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Double d = transform.applyInverse(r.getLowerEnd());
        Intrinsics.checkNotNull((Object)d);
        double a2 = d;
        Double d2 = transform.applyInverse(r.getUpperEnd());
        Intrinsics.checkNotNull((Object)d2);
        double b2 = d2;
        return new DoubleSpan(Math.min(a2, b2), Math.max(a2, b2));
    }
}

