/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.logging.Logger;
import jetbrains.datalore.base.logging.PortableLogging;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u001c\n\u0002\b\b\u0018\u0000 ;2\u00020\u0001:\u0004:;<=B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\nH\u0002J$\u0010\u001e\u001a\u00020\u00002\u001a\u0010\u001f\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0 H\u0002J\u0006\u0010\u0002\u001a\u00020\u0003J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\"2\u0006\u0010\u001c\u001a\u00020\nJ\u0014\u0010#\u001a\u00020\u00002\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000bJ \u0010&\u001a\u00020'2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002J\u0015\u0010(\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u001c\u001a\u00020\nH\u0086\u0002J\u0016\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0\u000f2\u0006\u0010\u001c\u001a\u00020\nJ\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010,\u001a\u00020\u0014H\u0002J\u000e\u0010-\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010.\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010/\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u00100\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u00101\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\nJ\u0010\u00102\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u00103\u001a\u00020%J\u0014\u00104\u001a\u00020\u00002\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000fJ\u0014\u00104\u001a\u00020\u00002\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000bJ\u0014\u00105\u001a\u00020\u00002\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%06J\u000e\u00107\u001a\u00020'2\u0006\u00108\u001a\u00020'J\f\u00109\u001a\b\u0012\u0004\u0012\u00020\n0\u000bR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R6\u0010\b\u001a*\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000b0\tj\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0015\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\tj\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u0016`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Ljetbrains/datalore/plot/base/DataFrame;", "", "builder", "Ljetbrains/datalore/plot/base/DataFrame$Builder;", "(Ljetbrains/datalore/plot/base/DataFrame$Builder;)V", "isEmpty", "", "()Z", "myDistinctValues", "Ljava/util/HashMap;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "Lkotlin/collections/HashMap;", "myFactorLevelsByVar", "", "", "myIsDateTime", "", "myIsNumeric", "myOrderSpecs", "Ljetbrains/datalore/plot/base/DataFrame$OrderSpec;", "myRanges", "Ljetbrains/datalore/base/interval/DoubleSpan;", "myVectorByVar", "assertAllSeriesAreSameSize", "", "vectorByVar", "assertDefined", "variable", "assertNumeric", "buildModified", "serieFun", "Lkotlin/Function1;", "distinctValues", "", "dropIndices", "indices", "", "dumpSizes", "", "get", "getNumeric", "", "getOrderedDistinctValues", "orderSpec", "has", "hasNoOrEmpty", "isDateTime", "isDiscrete", "isNumeric", "range", "rowCount", "selectIndices", "slice", "", "undefinedVariableErrorMessage", "varName", "variables", "Builder", "Companion", "OrderSpec", "Variable", "plot-base-portable"})
public final class DataFrame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Variable, List<?>> myVectorByVar;
    @NotNull
    private final Map<Variable, Boolean> myIsNumeric;
    @NotNull
    private final Map<Variable, Boolean> myIsDateTime;
    @NotNull
    private final List<OrderSpec> myOrderSpecs;
    @NotNull
    private final Map<Variable, List<Object>> myFactorLevelsByVar;
    @NotNull
    private final HashMap<Variable, DoubleSpan> myRanges = new HashMap();
    @NotNull
    private final HashMap<Variable, Set<Object>> myDistinctValues = new HashMap();
    @NotNull
    private static final Logger LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(DataFrame.class));

    private DataFrame(Builder builder) {
        this.assertAllSeriesAreSameSize((Map)builder.getMyVectorByVar$plot_base_portable());
        this.myVectorByVar = new HashMap(builder.getMyVectorByVar$plot_base_portable());
        this.myIsNumeric = new HashMap(builder.getMyIsNumeric$plot_base_portable());
        this.myIsDateTime = new HashMap(builder.getMyIsDateTime$plot_base_portable());
        this.myOrderSpecs = builder.getMyOrderSpecs$plot_base_portable();
        this.myFactorLevelsByVar = builder.getMyFactorLevelsByVar$plot_base_portable();
    }

    public final boolean isEmpty() {
        return this.myVectorByVar.isEmpty();
    }

    private final void assertAllSeriesAreSameSize(Map<Variable, ? extends List<?>> vectorByVar) {
        if (vectorByVar.size() > 1) {
            Iterator<Map.Entry<Variable, List<?>>> entries = vectorByVar.entrySet().iterator();
            Map.Entry<Variable, List<?>> first = entries.next();
            int size = first.getValue().size();
            while (entries.hasNext()) {
                Map.Entry<Variable, List<?>> next = entries.next();
                if (next.getValue().size() == size) continue;
                throw new IllegalArgumentException("All data series in data frame must have equal size\n" + this.dumpSizes(vectorByVar));
            }
        }
    }

    private final String dumpSizes(Map<Variable, ? extends List<?>> vectorByVar) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Variable, List<?>> entry : vectorByVar.entrySet()) {
            Variable key = entry.getKey();
            List<?> value = entry.getValue();
            sb.append(key.getName()).append(" : ").append(value.size()).append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public final int rowCount() {
        return this.myVectorByVar.isEmpty() ? 0 : this.myVectorByVar.entrySet().iterator().next().getValue().size();
    }

    public final boolean has(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.myVectorByVar.containsKey(variable);
    }

    public final boolean isEmpty(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.get(variable).isEmpty();
    }

    public final boolean hasNoOrEmpty(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return !this.has(variable) || this.isEmpty(variable);
    }

    @NotNull
    public final List<?> get(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        return (List)MapsKt.getValue(this.myVectorByVar, (Object)variable);
    }

    @NotNull
    public final List<Double> getNumeric(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        List list2 = (List)MapsKt.getValue(this.myVectorByVar, (Object)variable);
        if (!((Collection)list2).isEmpty()) {
            this.assertNumeric(variable);
        }
        Intrinsics.checkNotNull((Object)list2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Double?>");
        return list2;
    }

    @NotNull
    public final Collection<Object> distinctValues(@NotNull Variable variable) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        Map $this$getOrPut$iv = this.myDistinctValues;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(variable);
        if (value$iv == null) {
            OrderSpec orderSpec;
            block3: {
                boolean bl = false;
                List<OrderSpec> list2 = this.myOrderSpecs;
                ListIterator<OrderSpec> listIterator = list2.listIterator(list2.size());
                while (listIterator.hasPrevious()) {
                    OrderSpec orderSpec2;
                    OrderSpec it = orderSpec2 = listIterator.previous();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getVariable(), (Object)variable)) continue;
                    orderSpec = orderSpec2;
                    break block3;
                }
                orderSpec = null;
            }
            OrderSpec orderSpec3 = orderSpec;
            Set answer$iv = orderSpec3 != null ? this.getOrderedDistinctValues(orderSpec3) : CollectionsKt.toSet((Iterable)(this.myFactorLevelsByVar.containsKey(variable) ? (Collection)CollectionsKt.filterNotNull((Iterable)CollectionsKt.intersect((Iterable)CollectionsKt.toSet((Iterable)((Iterable)MapsKt.getValue(this.myFactorLevelsByVar, (Object)variable))), (Iterable)this.get(variable))) : (Collection)CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)this.get(variable)))));
            $this$getOrPut$iv.put(variable, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Collection)object;
    }

    @NotNull
    public final Set<Variable> variables() {
        return this.myVectorByVar.keySet();
    }

    public final boolean isNumeric(@NotNull Variable variable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        if (variable.isTransform()) {
            bl = true;
        } else {
            Boolean bl2;
            Map<Variable, Boolean> $this$getOrPut$iv = this.myIsNumeric;
            boolean $i$f$getOrPut = false;
            Boolean value$iv = $this$getOrPut$iv.get(variable);
            if (value$iv == null) {
                boolean bl3 = false;
                SeriesUtil.CheckedDoubleList checkedDoubles = SeriesUtil.INSTANCE.checkedDoubles(this.get(variable));
                Boolean answer$iv = checkedDoubles.notEmptyAndCanBeCast();
                $this$getOrPut$iv.put(variable, answer$iv);
                bl2 = answer$iv;
            } else {
                bl2 = value$iv;
            }
            bl = bl2;
        }
        return bl;
    }

    public final boolean isDiscrete(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return !this.isNumeric(variable);
    }

    public final boolean isDateTime(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        return this.myIsDateTime.containsKey(variable);
    }

    @Nullable
    public final DoubleSpan range(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (!this.myRanges.containsKey(variable)) {
            List<Double> v = this.getNumeric(variable);
            DoubleSpan r = SeriesUtil.INSTANCE.range((Iterable)v);
            ((Map)this.myRanges).put(variable, r);
        }
        return this.myRanges.get(variable);
    }

    @NotNull
    public final Builder builder() {
        return new Builder(this);
    }

    @NotNull
    public final DataFrame slice(@NotNull Iterable<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return new Builder(this, indices).build();
    }

    public final void assertDefined(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (!this.has(variable)) {
            IllegalArgumentException e = new IllegalArgumentException(this.undefinedVariableErrorMessage(variable.getName()));
            LOG.error((Throwable)e, (Function0)new Function0<String>(e){
                final /* synthetic */ IllegalArgumentException $e;
                {
                    this.$e = $e;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = this.$e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    return string;
                }
            });
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String undefinedVariableErrorMessage(@NotNull String varName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        Iterable iterable = this.variables();
        StringBuilder stringBuilder = new StringBuilder().append("Variable not found: '").append(varName).append("'. Variables in data frame: ");
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Variable variable = (Variable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add('\'' + it.getName() + '\'');
        }
        return stringBuilder.append((List)destination$iv$iv).toString();
    }

    private final void assertNumeric(Variable variable) {
        if (!this.isNumeric(variable)) {
            IllegalArgumentException e = new IllegalArgumentException("Not a numeric variable: '" + variable + '\'');
            LOG.error((Throwable)e, (Function0)new Function0<String>(e){
                final /* synthetic */ IllegalArgumentException $e;
                {
                    this.$e = $e;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = this.$e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    return string;
                }
            });
            throw e;
        }
    }

    @NotNull
    public final DataFrame selectIndices(@NotNull List<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return this.buildModified((Function1)new Function1<List<?>, List<?>>(indices){
            final /* synthetic */ List<Integer> $indices;
            {
                this.$indices = $indices;
                super(1);
            }

            @NotNull
            public final List<?> invoke(@NotNull List<?> serie) {
                Intrinsics.checkNotNullParameter(serie, (String)"serie");
                return SeriesUtil.INSTANCE.pickAtIndices(serie, this.$indices);
            }
        });
    }

    @NotNull
    public final DataFrame selectIndices(@NotNull Set<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return this.buildModified((Function1)new Function1<List<?>, List<?>>(indices){
            final /* synthetic */ Set<Integer> $indices;
            {
                this.$indices = $indices;
                super(1);
            }

            @NotNull
            public final List<?> invoke(@NotNull List<?> serie) {
                Intrinsics.checkNotNullParameter(serie, (String)"serie");
                return SeriesUtil.INSTANCE.pickAtIndices(serie, this.$indices);
            }
        });
    }

    @NotNull
    public final DataFrame dropIndices(@NotNull Set<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return indices.isEmpty() ? this : this.buildModified((Function1)new Function1<List<?>, List<?>>(indices){
            final /* synthetic */ Set<Integer> $indices;
            {
                this.$indices = $indices;
                super(1);
            }

            @NotNull
            public final List<?> invoke(@NotNull List<?> serie) {
                Intrinsics.checkNotNullParameter(serie, (String)"serie");
                return SeriesUtil.INSTANCE.skipAtIndices(serie, this.$indices);
            }
        });
    }

    private final DataFrame buildModified(Function1<? super List<?>, ? extends List<?>> serieFun) {
        Builder builder = this.builder();
        for (Variable variable : this.myVectorByVar.keySet()) {
            List<?> serie;
            List<?> list2 = serie = this.myVectorByVar.get(variable);
            Intrinsics.checkNotNull(list2);
            List modifiedSerie = (List)serieFun.invoke(list2);
            builder.putIntern$plot_base_portable(variable, modifiedSerie);
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Object> getOrderedDistinctValues(OrderSpec orderSpec) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        void $this$mapNotNullTo$iv$iv2;
        Object it;
        Iterable $this$filterTo$iv$iv;
        List list2;
        Function1[] $this$mapValuesTo$iv$iv;
        Object destination$iv$iv;
        if (orderSpec.getAggregateOperation() != null) {
            Object byValue;
            Object object;
            Object list$iv$iv;
            Object key$iv$iv;
            Object $this$groupByTo$iv$iv;
            if (!this.isNumeric(orderSpec.getOrderBy())) {
                boolean $i$a$-require-DataFrame$getOrderedDistinctValues$orderedValues$22 = false;
                String $i$a$-require-DataFrame$getOrderedDistinctValues$orderedValues$22 = "Can't apply aggregate operation to non-numeric values";
                throw new IllegalArgumentException($i$a$-require-DataFrame$getOrderedDistinctValues$orderedValues$22.toString());
            }
            Iterable $this$groupBy$iv = CollectionsKt.zip((Iterable)this.get(orderSpec.getVariable()), (Iterable)this.getNumeric(orderSpec.getOrderBy()));
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object value;
                Object element$iv$iv = iterator.next();
                Pair pair = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-DataFrame$getOrderedDistinctValues$orderedValues$42 = false;
                key$iv$iv = value = pair.component1();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                Pair $i$a$-groupBy-DataFrame$getOrderedDistinctValues$orderedValues$42 = (Pair)element$iv$iv;
                object = list$iv$iv;
                boolean bl = false;
                byValue = (Double)$i$a$-groupBy-DataFrame$getOrderedDistinctValues$orderedValues$42.component2();
                object.add(byValue);
            }
            Object $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            list$iv$iv = $this$associateByTo$iv$iv$iv.iterator();
            while (list$iv$iv.hasNext()) {
                void $this$filterTo$iv$iv2;
                void $this$filter$iv;
                void it$iv$iv;
                Object element$iv$iv$iv = list$iv$iv.next();
                Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                key$iv$iv = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry $i$f$getOrPut = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = key$iv$iv;
                boolean bl3 = false;
                List byValues = (List)$i$f$getOrPut.getValue();
                byValue = byValues;
                Function1<List<Double>, Double> function1 = orderSpec.getAggregateOperation();
                boolean $i$f$filter = false;
                void var21_57 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv;
                    Object p0 = element$iv$iv = iterator2.next();
                    boolean bl4 = false;
                    if (!DataFrame.getOrderedDistinctValues$isValueComparable(p0)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Double d = (Double)function1.invoke((Object)((List)destination$iv$iv2));
                object.put(k, d);
            }
            list2 = MapsKt.toList((Map)destination$iv$iv);
        } else {
            list2 = CollectionsKt.zip((Iterable)this.get(orderSpec.getVariable()), (Iterable)this.get(orderSpec.getOrderBy()));
        }
        Function1[] $this$filter$iv = (Function1[])list2;
        boolean $i$f$filter = false;
        $this$mapValuesTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(DataFrame.getOrderedDistinctValues$isValueComparable(it.getSecond()) && DataFrame.getOrderedDistinctValues$isValueComparable(it.getFirst()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = new Function1[]{getOrderedDistinctValues.orderedValues.6.INSTANCE, getOrderedDistinctValues.orderedValues.7.INSTANCE};
        Iterable $this$mapNotNull$iv2 = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)ComparisonsKt.compareBy((Function1[])$this$filter$iv));
        boolean $i$f$mapNotNull22 = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Pair it2 = (Pair)element$iv$iv;
            boolean bl5 = false;
            if (it2.getFirst() == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List orderedValues2 = (List)destination$iv$iv;
        Iterable $i$f$mapNotNull22 = CollectionsKt.zip((Iterable)this.get(orderSpec.getVariable()), (Iterable)this.get(orderSpec.getOrderBy()));
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Pair it3 = (Pair)element$iv$iv;
            boolean bl = false;
            if (DataFrame.getOrderedDistinctValues$isValueComparable(it3.getSecond())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv3;
        boolean $i$f$mapNotNull = false;
        $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair it4 = (Pair)element$iv$iv;
            boolean bl7 = false;
            if (it4.getFirst() == null) continue;
            boolean bl8 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List nonComparableAppendix = (List)destination$iv$iv3;
        return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)(orderSpec.getDirection() < 0 ? CollectionsKt.reversed((Iterable)orderedValues2) : orderedValues2), (Iterable)nonComparableAppendix));
    }

    private static final boolean getOrderedDistinctValues$isValueComparable(Object value) {
        double d;
        return value != null && (!(value instanceof Double) || !Double.isInfinite(d = ((Number)value).doubleValue()) && !Double.isNaN(d));
    }

    public /* synthetic */ DataFrame(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\t\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012 \b\u0002\u0010\u0007\u001a\u001a\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bR)\u0010\u0007\u001a\u001a\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$OrderSpec;", "", "variable", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "orderBy", "direction", "", "aggregateOperation", "Lkotlin/Function1;", "", "", "(Ljetbrains/datalore/plot/base/DataFrame$Variable;Ljetbrains/datalore/plot/base/DataFrame$Variable;ILkotlin/jvm/functions/Function1;)V", "getAggregateOperation", "()Lkotlin/jvm/functions/Function1;", "getDirection", "()I", "getOrderBy", "()Ljetbrains/datalore/plot/base/DataFrame$Variable;", "getVariable", "plot-base-portable"})
    public static final class OrderSpec {
        @NotNull
        private final Variable variable;
        @NotNull
        private final Variable orderBy;
        private final int direction;
        @Nullable
        private final Function1<List<Double>, Double> aggregateOperation;

        public OrderSpec(@NotNull Variable variable, @NotNull Variable orderBy, int direction, @Nullable Function1<? super List<Double>, Double> aggregateOperation) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
            this.variable = variable;
            this.orderBy = orderBy;
            this.direction = direction;
            this.aggregateOperation = aggregateOperation;
        }

        public /* synthetic */ OrderSpec(Variable variable, Variable variable2, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                function1 = null;
            }
            this(variable, variable2, n, (Function1<? super List<Double>, Double>)function1);
        }

        @NotNull
        public final Variable getVariable() {
            return this.variable;
        }

        @NotNull
        public final Variable getOrderBy() {
            return this.orderBy;
        }

        public final int getDirection() {
            return this.direction;
        }

        @Nullable
        public final Function1<List<Double>, Double> getAggregateOperation() {
            return this.aggregateOperation;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Companion;", "", "()V", "LOG", "Ljetbrains/datalore/base/logging/Logger;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0006\u0010\u0013\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "name", "", "source", "Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;", "label", "(Ljava/lang/String;Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;Ljava/lang/String;)V", "isOrigin", "", "()Z", "isStat", "isTransform", "getLabel", "()Ljava/lang/String;", "getName", "getSource", "()Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;", "toString", "toSummaryString", "Companion", "Source", "plot-base-portable"})
    public static final class Variable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final Source source;
        @NotNull
        private final String label;

        @JvmOverloads
        public Variable(@NotNull String name, @NotNull Source source, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.name = name;
            this.source = source;
            this.label = label;
        }

        public /* synthetic */ Variable(String string, Source source, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                source = Source.ORIGIN;
            }
            if ((n & 4) != 0) {
                string2 = string;
            }
            this(string, source, string2);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Source getSource() {
            return this.source;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final boolean isOrigin() {
            return this.source == Source.ORIGIN;
        }

        public final boolean isStat() {
            return this.source == Source.STAT;
        }

        public final boolean isTransform() {
            return this.source == Source.TRANSFORM;
        }

        @NotNull
        public String toString() {
            return this.name;
        }

        @NotNull
        public final String toSummaryString() {
            return this.name + ", '" + this.label + "' [" + (Object)((Object)this.source) + ']';
        }

        @JvmOverloads
        public Variable(@NotNull String name, @NotNull Source source) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            this(name, source, null, 4, null);
        }

        @JvmOverloads
        public Variable(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this(name, null, null, 6, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;", "", "(Ljava/lang/String;I)V", "ORIGIN", "TRANSFORM", "STAT", "plot-base-portable"})
        public static final class Source
        extends Enum<Source> {
            public static final /* enum */ Source ORIGIN = new Source();
            public static final /* enum */ Source TRANSFORM = new Source();
            public static final /* enum */ Source STAT = new Source();
            private static final /* synthetic */ Source[] $VALUES;

            public static Source[] values() {
                return (Source[])$VALUES.clone();
            }

            public static Source valueOf(String value) {
                return Enum.valueOf(Source.class, value);
            }

            static {
                $VALUES = sourceArray = new Source[]{Source.ORIGIN, Source.TRANSFORM, Source.STAT};
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Variable$Companion;", "", "()V", "createOriginal", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "name", "", "label", "plot-base-portable"})
        public static final class Companion {
            private Companion() {
            }

            @JvmOverloads
            @NotNull
            public final Variable createOriginal(@NotNull String name, @NotNull String label) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                return new Variable(name, Source.ORIGIN, label);
            }

            public static /* synthetic */ Variable createOriginal$default(Companion companion, String string, String string2, int n, Object object) {
                if ((n & 2) != 0) {
                    string2 = string;
                }
                return companion.createOriginal(string, string2);
            }

            @JvmOverloads
            @NotNull
            public final Variable createOriginal(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return jetbrains.datalore.plot.base.DataFrame$Variable$Companion.createOriginal$default(this, name, null, 2, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u00015B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ \u0010\u001e\u001a\u00020\u00002\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0018J\u0014\u0010#\u001a\u00020\u00002\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180\rJ\u0006\u0010%\u001a\u00020\u0004Jp\u0010&\u001a\u00020'2\u0016\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0 2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120 2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0 H\u0002J\u001a\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\rJ\u001a\u0010.\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\rJ\u001a\u0010/\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\rJ!\u00100\u001a\u00020'2\u0006\u0010,\u001a\u00020\f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\rH\u0000\u00a2\u0006\u0002\b1J\u001e\u00102\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\f2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030\rJ\u000e\u00104\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\fR<\u0010\n\u001a*\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0\u000bj\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r`\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R0\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0012`\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R0\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0012`\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R$\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR8\u0010\u001c\u001a&\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u000bj\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r`\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010\u00a8\u00066"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Builder;", "", "()V", "data", "Ljetbrains/datalore/plot/base/DataFrame;", "(Ljetbrains/datalore/plot/base/DataFrame;)V", "indices", "", "", "(Ljetbrains/datalore/plot/base/DataFrame;Ljava/lang/Iterable;)V", "myFactorLevelsByVar", "Ljava/util/HashMap;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "Lkotlin/collections/HashMap;", "getMyFactorLevelsByVar$plot_base_portable", "()Ljava/util/HashMap;", "myIsDateTime", "", "getMyIsDateTime$plot_base_portable", "myIsNumeric", "getMyIsNumeric$plot_base_portable", "myOrderSpecs", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/base/DataFrame$OrderSpec;", "Lkotlin/collections/ArrayList;", "getMyOrderSpecs$plot_base_portable", "()Ljava/util/ArrayList;", "myVectorByVar", "getMyVectorByVar$plot_base_portable", "addFactorLevels", "factorLevelsByVar", "", "addOrderSpec", "orderSpec", "addOrderSpecs", "orderSpecs", "build", "initInternals", "", "vectorByVar", "isNumeric", "isDateTime", "put", "variable", "v", "putDateTime", "putDiscrete", "putIntern", "putIntern$plot_base_portable", "putNumeric", "", "remove", "Companion", "plot-base-portable"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final HashMap<Variable, List<?>> myVectorByVar;
        @NotNull
        private final HashMap<Variable, Boolean> myIsNumeric;
        @NotNull
        private final HashMap<Variable, Boolean> myIsDateTime;
        @NotNull
        private final ArrayList<OrderSpec> myOrderSpecs;
        @NotNull
        private final HashMap<Variable, List<Object>> myFactorLevelsByVar;

        @NotNull
        public final HashMap<Variable, List<?>> getMyVectorByVar$plot_base_portable() {
            return this.myVectorByVar;
        }

        @NotNull
        public final HashMap<Variable, Boolean> getMyIsNumeric$plot_base_portable() {
            return this.myIsNumeric;
        }

        @NotNull
        public final HashMap<Variable, Boolean> getMyIsDateTime$plot_base_portable() {
            return this.myIsDateTime;
        }

        @NotNull
        public final ArrayList<OrderSpec> getMyOrderSpecs$plot_base_portable() {
            return this.myOrderSpecs;
        }

        @NotNull
        public final HashMap<Variable, List<Object>> getMyFactorLevelsByVar$plot_base_portable() {
            return this.myFactorLevelsByVar;
        }

        public Builder() {
            this.myVectorByVar = new HashMap();
            this.myIsNumeric = new HashMap();
            this.myIsDateTime = new HashMap();
            this.myOrderSpecs = new ArrayList();
            this.myFactorLevelsByVar = new HashMap();
        }

        public Builder(@NotNull DataFrame data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.myVectorByVar = new HashMap();
            this.myIsNumeric = new HashMap();
            this.myIsDateTime = new HashMap();
            this.myOrderSpecs = new ArrayList();
            this.myFactorLevelsByVar = new HashMap();
            this.initInternals(data.myVectorByVar, data.myIsNumeric, data.myIsDateTime, data.myOrderSpecs, data.myFactorLevelsByVar);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull DataFrame data, @NotNull Iterable<Integer> indices) {
            void $this$mapValuesTo$iv$iv;
            List list2;
            Map map;
            Object object;
            void $this$associateWith$iv;
            Object object2;
            Variable v;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(indices, (String)"indices");
            this.myVectorByVar = new HashMap();
            this.myIsNumeric = new HashMap();
            this.myIsDateTime = new HashMap();
            this.myOrderSpecs = new ArrayList();
            this.myFactorLevelsByVar = new HashMap();
            Iterable iterable = data.variables();
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                v = (Variable)element$iv$iv;
                boolean bl = false;
                if (!(!v.isTransform())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                v = (Variable)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !((Map)this.myFactorLevelsByVar).containsKey(v);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Object v1;
                block7: {
                    v = (Variable)element$iv$iv;
                    boolean bl = false;
                    Iterable iterable2 = this.myOrderSpecs;
                    Iterator iterator = iterable2.iterator();
                    while (iterator.hasNext()) {
                        object2 = iterator.next();
                        OrderSpec it = (OrderSpec)object2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getVariable(), (Object)v)) continue;
                        v1 = object2;
                        break block7;
                    }
                    v1 = null;
                }
                boolean bl = v1 == null;
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                v = (Variable)element$iv$iv;
                boolean bl = false;
                if (!data.isDiscrete(v)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo22 = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                v = (Variable)element$iv$iv;
                object = element$iv$iv;
                map = result$iv;
                boolean bl = false;
                list2 = CollectionsKt.toList((Iterable)data.distinctValues((Variable)it));
                map.put(object, list2);
            }
            Map addFactorLevelsByVar = result$iv;
            Map newFactorLevelsByVar = MapsKt.plus((Map)data.myFactorLevelsByVar, (Map)addFactorLevelsByVar);
            Map $this$mapValues$iv = data.myVectorByVar;
            boolean $i$f$mapValues = false;
            Map $i$f$associateWithTo22 = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                object2 = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv2;
                boolean bl = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                object = it$iv$iv.getKey();
                map = map2;
                boolean bl4 = false;
                List serie = (List)entry.getValue();
                list2 = CollectionsKt.slice((List)serie, indices);
                map.put(object, list2);
            }
            Map newVectors = destination$iv$iv2;
            this.initInternals(newVectors, data.myIsNumeric, data.myIsDateTime, data.myOrderSpecs, newFactorLevelsByVar);
        }

        private final void initInternals(Map<Variable, ? extends List<?>> vectorByVar, Map<Variable, Boolean> isNumeric, Map<Variable, Boolean> isDateTime, List<OrderSpec> orderSpecs, Map<Variable, ? extends List<? extends Object>> factorLevelsByVar) {
            this.myVectorByVar.putAll(vectorByVar);
            this.myIsNumeric.putAll(isNumeric);
            this.myIsDateTime.putAll(isDateTime);
            this.myOrderSpecs.addAll((Collection<OrderSpec>)orderSpecs);
            this.myFactorLevelsByVar.putAll(factorLevelsByVar);
        }

        @NotNull
        public final Builder put(@NotNull Variable variable, @NotNull List<?> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.putIntern$plot_base_portable(variable, v);
            this.myIsNumeric.remove(variable);
            this.myIsDateTime.remove(variable);
            return this;
        }

        @NotNull
        public final Builder putNumeric(@NotNull Variable variable, @NotNull List<Double> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.putIntern$plot_base_portable(variable, v);
            ((Map)this.myIsNumeric).put(variable, true);
            return this;
        }

        @NotNull
        public final Builder putDiscrete(@NotNull Variable variable, @NotNull List<?> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.putIntern$plot_base_portable(variable, v);
            ((Map)this.myIsNumeric).put(variable, false);
            return this;
        }

        @NotNull
        public final Builder putDateTime(@NotNull Variable variable, @NotNull List<?> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.putIntern$plot_base_portable(variable, v);
            ((Map)this.myIsDateTime).put(variable, true);
            return this;
        }

        public final void putIntern$plot_base_portable(@NotNull Variable variable, @NotNull List<?> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            ((Map)this.myVectorByVar).put(variable, new ArrayList(v));
        }

        @NotNull
        public final Builder remove(@NotNull Variable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            this.myVectorByVar.remove(variable);
            this.myIsNumeric.remove(variable);
            this.myIsDateTime.remove(variable);
            return this;
        }

        @NotNull
        public final Builder addOrderSpecs(@NotNull List<OrderSpec> orderSpecs) {
            Intrinsics.checkNotNullParameter(orderSpecs, (String)"orderSpecs");
            Iterable $this$forEach$iv = orderSpecs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OrderSpec p0 = (OrderSpec)element$iv;
                boolean bl = false;
                this.addOrderSpec(p0);
            }
            return this;
        }

        @NotNull
        public final Builder addOrderSpec(@NotNull OrderSpec orderSpec) {
            OrderSpec currentOrderSpec;
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)orderSpec, (String)"orderSpec");
                Iterable iterable = this.myOrderSpecs;
                for (Object t : iterable) {
                    OrderSpec it = (OrderSpec)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getVariable(), (Object)orderSpec.getVariable())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            OrderSpec orderSpec2 = currentOrderSpec = (OrderSpec)v0;
            if ((orderSpec2 != null ? orderSpec2.getAggregateOperation() : null) == null) {
                TypeIntrinsics.asMutableCollection((Object)this.myOrderSpecs).remove(currentOrderSpec);
                this.myOrderSpecs.add(orderSpec);
            }
            return this;
        }

        @NotNull
        public final Builder addFactorLevels(@NotNull Map<Variable, ? extends List<? extends Object>> factorLevelsByVar) {
            Intrinsics.checkNotNullParameter(factorLevelsByVar, (String)"factorLevelsByVar");
            this.myFactorLevelsByVar.putAll(factorLevelsByVar);
            return this;
        }

        @NotNull
        public final DataFrame build() {
            return new DataFrame(this, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Builder$Companion;", "", "()V", "emptyFrame", "Ljetbrains/datalore/plot/base/DataFrame;", "plot-base-portable"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DataFrame emptyFrame() {
                return new Builder().build();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

