/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.sampling.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.builder.sampling.PointSampling;
import jetbrains.datalore.plot.builder.sampling.method.SamplingBase;
import jetbrains.datalore.plot.builder.sampling.method.SamplingUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/builder/sampling/method/PickSampling;", "Ljetbrains/datalore/plot/builder/sampling/method/SamplingBase;", "Ljetbrains/datalore/plot/builder/sampling/PointSampling;", "sampleSize", "", "(I)V", "expressionText", "", "getExpressionText", "()Ljava/lang/String;", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "population", "Companion", "plot-builder-portable"})
public final class PickSampling
extends SamplingBase
implements PointSampling {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ALIAS = "pick";

    public PickSampling(int sampleSize) {
        super(sampleSize);
    }

    @Override
    @NotNull
    public String getExpressionText() {
        return "sampling_pick(n=" + this.getSampleSize() + ')';
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame population) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        if (!this.isApplicable(population)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DataFrame.Variable xVar = SamplingUtil.INSTANCE.xVar(population);
        Collection xFactors = population.distinctValues(xVar);
        if (xFactors.size() <= this.getSampleSize()) {
            return population;
        }
        Set pickX = CollectionsKt.toSet((Iterable)CollectionsKt.take((Iterable)xFactors, (int)this.getSampleSize()));
        List xValues = population.get(xVar);
        ArrayList<Integer> pickedIndices = new ArrayList<Integer>();
        Iterator iterator = xValues.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Object v = iterator.next();
            if (!CollectionsKt.contains((Iterable)pickX, v)) continue;
            pickedIndices.add(index);
        }
        return population.selectIndices((List)pickedIndices);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/builder/sampling/method/PickSampling$Companion;", "", "()V", "ALIAS", "", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

