/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import jetbrains.datalore.plot.builder.layout.PlotLabelSpecFactory;
import jetbrains.datalore.plot.builder.layout.PlotLayoutUtil;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\f\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/builder/guide/LegendBoxLayout;", "", "title", "", "legendDirection", "Ljetbrains/datalore/plot/builder/guide/LegendDirection;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "(Ljava/lang/String;Ljetbrains/datalore/plot/builder/guide/LegendDirection;Ljetbrains/datalore/plot/builder/theme/LegendTheme;)V", "graphOrigin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getGraphOrigin", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "graphSize", "getGraphSize", "isHorizontal", "", "()Z", "size", "getSize", "getTheme", "()Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "titleBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "getTitleBounds", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "titleSize", "getTitleSize$plot_builder_portable", "plot-builder-portable"})
public abstract class LegendBoxLayout {
    @NotNull
    private final String title;
    @NotNull
    private final LegendTheme theme;
    private final boolean isHorizontal;

    public LegendBoxLayout(@NotNull String title, @NotNull LegendDirection legendDirection, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)((Object)legendDirection), (String)"legendDirection");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.title = title;
        this.theme = theme;
        this.isHorizontal = legendDirection == LegendDirection.HORIZONTAL;
    }

    @NotNull
    protected final LegendTheme getTheme() {
        return this.theme;
    }

    @NotNull
    public abstract DoubleVector getGraphSize();

    public final boolean isHorizontal() {
        return this.isHorizontal;
    }

    private final DoubleRectangle getTitleBounds() {
        return new DoubleRectangle(DoubleVector.Companion.getZERO(), this.getTitleSize$plot_builder_portable());
    }

    @NotNull
    public final DoubleVector getGraphOrigin() {
        DoubleVector doubleVector;
        if (this.isHorizontal) {
            DoubleVector $this$_get_graphOrigin__u24lambda_u240 = this.getTitleSize$plot_builder_portable();
            boolean bl = false;
            doubleVector = new DoubleVector($this$_get_graphOrigin__u24lambda_u240.getX(), $this$_get_graphOrigin__u24lambda_u240.getY() > this.getGraphSize().getY() ? ($this$_get_graphOrigin__u24lambda_u240.getY() - this.getGraphSize().getY()) / (double)2 : 0.0);
        } else {
            doubleVector = new DoubleVector(0.0, this.getTitleSize$plot_builder_portable().getY() + PlotLabelSpecFactory.INSTANCE.legendTitle(this.theme).height() / (double)2);
        }
        return doubleVector;
    }

    @NotNull
    public final DoubleVector getSize() {
        DoubleRectangle graphBounds = new DoubleRectangle(this.getGraphOrigin(), this.getGraphSize());
        DoubleRectangle titleAndContent = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO()).union(this.getTitleBounds()).union(graphBounds);
        return titleAndContent.getDimension();
    }

    @NotNull
    public final DoubleVector getTitleSize$plot_builder_portable() {
        return StringsKt.isBlank((CharSequence)this.title) || !this.theme.showTitle() ? DoubleVector.Companion.getZERO() : PlotLayoutUtil.INSTANCE.textDimensions$plot_builder_portable(this.title, PlotLabelSpecFactory.INSTANCE.legendTitle(this.theme));
    }
}

