/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.PlotContext;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.base.aes.AestheticsDefaults;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.base.scale.breaks.ScaleBreaksUtil;
import jetbrains.datalore.plot.builder.assemble.GuideOptions;
import jetbrains.datalore.plot.builder.assemble.LegendAssemblerUtil;
import jetbrains.datalore.plot.builder.assemble.LegendOptions;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.LegendBreak;
import jetbrains.datalore.plot.builder.guide.LegendComponent;
import jetbrains.datalore.plot.builder.guide.LegendComponentLayout;
import jetbrains.datalore.plot.builder.guide.LegendComponentSpec;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0002!\"BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001a\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJd\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00162\u0016\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0006J\u0006\u0010\u001f\u001a\u00020 R\u001e\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ljetbrains/datalore/plot/builder/assemble/LegendAssembler;", "", "legendTitle", "", "guideOptionsMap", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/builder/assemble/GuideOptions;", "scaleMappers", "Ljetbrains/datalore/plot/base/ScaleMapper;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljetbrains/datalore/plot/builder/theme/LegendTheme;)V", "legendLayers", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/builder/assemble/LegendAssembler$LegendLayer;", "Lkotlin/collections/ArrayList;", "addLayer", "", "keyFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "aesList", "", "constantByAes", "aestheticsDefaults", "Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;", "ctx", "Ljetbrains/datalore/plot/base/PlotContext;", "colorByAes", "Ljetbrains/datalore/base/values/Color;", "fillByAes", "createLegend", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "Companion", "LegendLayer", "plot-builder-portable"})
public final class LegendAssembler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String legendTitle;
    @NotNull
    private final Map<Aes<?>, GuideOptions> guideOptionsMap;
    @NotNull
    private final Map<Aes<?>, ScaleMapper<?>> scaleMappers;
    @NotNull
    private final LegendTheme theme;
    @NotNull
    private final ArrayList<LegendLayer> legendLayers;
    private static final boolean DEBUG_DRAWING = false;

    public LegendAssembler(@NotNull String legendTitle, @NotNull Map<Aes<?>, ? extends GuideOptions> guideOptionsMap, @NotNull Map<Aes<?>, ? extends ScaleMapper<?>> scaleMappers, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)legendTitle, (String)"legendTitle");
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        Intrinsics.checkNotNullParameter(scaleMappers, (String)"scaleMappers");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.legendTitle = legendTitle;
        this.guideOptionsMap = guideOptionsMap;
        this.scaleMappers = scaleMappers;
        this.theme = theme;
        this.legendLayers = new ArrayList();
    }

    public final void addLayer(@NotNull LegendKeyElementFactory keyFactory, @NotNull List<? extends Aes<?>> aesList, @NotNull Map<Aes<?>, ? extends Object> constantByAes, @NotNull AestheticsDefaults aestheticsDefaults, @NotNull PlotContext ctx, @NotNull Aes<Color> colorByAes, @NotNull Aes<Color> fillByAes) {
        Intrinsics.checkNotNullParameter((Object)keyFactory, (String)"keyFactory");
        Intrinsics.checkNotNullParameter(aesList, (String)"aesList");
        Intrinsics.checkNotNullParameter(constantByAes, (String)"constantByAes");
        Intrinsics.checkNotNullParameter((Object)aestheticsDefaults, (String)"aestheticsDefaults");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(colorByAes, (String)"colorByAes");
        Intrinsics.checkNotNullParameter(fillByAes, (String)"fillByAes");
        this.legendLayers.add(new LegendLayer(keyFactory, aesList, constantByAes, aestheticsDefaults, this.scaleMappers, ctx, colorByAes, fillByAes));
    }

    @NotNull
    public final LegendBoxInfo createLegend() {
        LinkedHashMap legendBreaksByLabel = new LinkedHashMap();
        for (LegendLayer legendLayer : this.legendLayers) {
            LegendKeyElementFactory keyElementFactory = legendLayer.getKeyElementFactory$plot_builder_portable();
            Iterator dataPoints = legendLayer.getKeyAesthetics$plot_builder_portable().dataPoints().iterator();
            for (String label : legendLayer.getKeyLabels$plot_builder_portable()) {
                Object object;
                Map $this$getOrPut$iv = legendBreaksByLabel;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(label);
                if (value$iv == null) {
                    boolean bl = false;
                    LegendBreak answer$iv = new LegendBreak(label);
                    $this$getOrPut$iv.put(label, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((LegendBreak)object).addLayer((DataPointAesthetics)dataPoints.next(), keyElementFactory);
            }
        }
        ArrayList<LegendBreak> legendBreaks = new ArrayList<LegendBreak>();
        for (Object legendBreak : legendBreaksByLabel.values()) {
            if (((LegendBreak)legendBreak).isEmpty()) continue;
            legendBreaks.add((LegendBreak)legendBreak);
        }
        if (legendBreaks.isEmpty()) {
            return LegendBoxInfo.Companion.getEMPTY();
        }
        ArrayList<LegendOptions> arrayList = new ArrayList<LegendOptions>();
        for (LegendLayer legendLayer : this.legendLayers) {
            List<Aes<?>> aesList = legendLayer.getAesList$plot_builder_portable();
            for (Aes<?> aes : aesList) {
                if (!(this.guideOptionsMap.get(aes) instanceof LegendOptions)) continue;
                GuideOptions guideOptions = this.guideOptionsMap.get(aes);
                Intrinsics.checkNotNull((Object)guideOptions, (String)"null cannot be cast to non-null type jetbrains.datalore.plot.builder.assemble.LegendOptions");
                arrayList.add((LegendOptions)guideOptions);
            }
        }
        LegendComponentSpec spec = Companion.createLegendSpec(this.legendTitle, (List<LegendBreak>)legendBreaks, this.theme, LegendOptions.Companion.combine((List<LegendOptions>)arrayList));
        DoubleVector doubleVector = spec.getSize();
        return new LegendBoxInfo(spec, doubleVector){
            final /* synthetic */ LegendComponentSpec $spec;
            {
                this.$spec = $spec;
                super($super_call_param$1);
            }

            @NotNull
            public LegendBox createLegendBox() {
                LegendComponent c = new LegendComponent(this.$spec);
                c.setDebug(false);
                return c;
            }
        };
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u007f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u001a\u0010\u000b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006\u00a2\u0006\u0002\u0010\u0012R\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/builder/assemble/LegendAssembler$LegendLayer;", "", "keyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "aesList", "", "Ljetbrains/datalore/plot/base/Aes;", "constantByAes", "", "aestheticsDefaults", "Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;", "scaleMappers", "Ljetbrains/datalore/plot/base/ScaleMapper;", "ctx", "Ljetbrains/datalore/plot/base/PlotContext;", "colorByAes", "Ljetbrains/datalore/base/values/Color;", "fillByAes", "(Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;Ljava/util/List;Ljava/util/Map;Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;Ljava/util/Map;Ljetbrains/datalore/plot/base/PlotContext;Ljetbrains/datalore/plot/base/Aes;Ljetbrains/datalore/plot/base/Aes;)V", "getAesList$plot_builder_portable", "()Ljava/util/List;", "keyAesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "getKeyAesthetics$plot_builder_portable", "()Ljetbrains/datalore/plot/base/Aesthetics;", "getKeyElementFactory$plot_builder_portable", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "keyLabels", "", "getKeyLabels$plot_builder_portable", "plot-builder-portable"})
    private static final class LegendLayer {
        @NotNull
        private final LegendKeyElementFactory keyElementFactory;
        @NotNull
        private final List<Aes<?>> aesList;
        @NotNull
        private final Aesthetics keyAesthetics;
        @NotNull
        private final List<String> keyLabels;

        /*
         * WARNING - void declaration
         */
        public LegendLayer(@NotNull LegendKeyElementFactory keyElementFactory, @NotNull List<? extends Aes<?>> aesList, @NotNull Map<Aes<?>, ? extends Object> constantByAes, @NotNull AestheticsDefaults aestheticsDefaults, @NotNull Map<Aes<?>, ? extends ScaleMapper<?>> scaleMappers, @NotNull PlotContext ctx, @NotNull Aes<Color> colorByAes, @NotNull Aes<Color> fillByAes) {
            Intrinsics.checkNotNullParameter((Object)keyElementFactory, (String)"keyElementFactory");
            Intrinsics.checkNotNullParameter(aesList, (String)"aesList");
            Intrinsics.checkNotNullParameter(constantByAes, (String)"constantByAes");
            Intrinsics.checkNotNullParameter((Object)aestheticsDefaults, (String)"aestheticsDefaults");
            Intrinsics.checkNotNullParameter(scaleMappers, (String)"scaleMappers");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter(colorByAes, (String)"colorByAes");
            Intrinsics.checkNotNullParameter(fillByAes, (String)"fillByAes");
            this.keyElementFactory = keyElementFactory;
            this.aesList = aesList;
            LinkedHashMap aesValuesByLabel = new LinkedHashMap();
            for (Aes<?> aes : this.aesList) {
                void $this$mapTo$iv$iv;
                Scale scale = ctx.getScale(aes);
                if (!scale.hasBreaks()) {
                    scale = ScaleBreaksUtil.INSTANCE.withBreaks(scale, ctx.overallTransformedDomain(aes), 5);
                }
                if (!scale.hasBreaks()) {
                    boolean $i$a$-check-LegendAssembler$LegendLayer$22 = false;
                    String $i$a$-check-LegendAssembler$LegendLayer$22 = "No breaks were defined for scale " + aes;
                    throw new IllegalStateException($i$a$-check-LegendAssembler$LegendLayer$22.toString());
                }
                ScaleBreaks scaleBreaks = scale.getScaleBreaks();
                Iterable $this$map$iv = scaleBreaks.getTransformedValues();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    double d = ((Number)item$iv$iv).doubleValue();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object object = ((ScaleMapper)MapsKt.getValue(scaleMappers, aes)).invoke(Double.valueOf((double)it));
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
                    collection.add(object);
                }
                List aesValues = (List)destination$iv$iv;
                List labels = scaleBreaks.getLabels();
                for (Iterable iterable2 : CollectionsKt.zip((Iterable)labels, (Iterable)aesValues)) {
                    Object object;
                    String label = (String)iterable2.component1();
                    Object aesValue = iterable2.component2();
                    Map $this$getOrPut$iv = aesValuesByLabel;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(label);
                    if (value$iv == null) {
                        boolean bl = false;
                        Map answer$iv = new HashMap();
                        $this$getOrPut$iv.put(label, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Map)object).put(aes, aesValue);
                }
            }
            Collection collection = aesValuesByLabel.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"aesValuesByLabel.values");
            this.keyAesthetics = LegendAssemblerUtil.INSTANCE.mapToAesthetics(collection, constantByAes, aestheticsDefaults, colorByAes, fillByAes);
            this.keyLabels = new ArrayList(aesValuesByLabel.keySet());
        }

        @NotNull
        public final LegendKeyElementFactory getKeyElementFactory$plot_builder_portable() {
            return this.keyElementFactory;
        }

        @NotNull
        public final List<Aes<?>> getAesList$plot_builder_portable() {
            return this.aesList;
        }

        @NotNull
        public final Aesthetics getKeyAesthetics$plot_builder_portable() {
            return this.keyAesthetics;
        }

        @NotNull
        public final List<String> getKeyLabels$plot_builder_portable() {
            return this.keyLabels;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/assemble/LegendAssembler$Companion;", "", "()V", "DEBUG_DRAWING", "", "createLegendSpec", "Ljetbrains/datalore/plot/builder/guide/LegendComponentSpec;", "title", "", "breaks", "", "Ljetbrains/datalore/plot/builder/guide/LegendBreak;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "options", "Ljetbrains/datalore/plot/builder/assemble/LegendOptions;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LegendComponentSpec createLegendSpec(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull LegendTheme theme, @NotNull LegendOptions options) {
            List list;
            boolean $i$f$map22;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            LegendDirection legendDirection = LegendAssemblerUtil.INSTANCE.legendDirection(theme);
            DoubleVector themeKeySize = new DoubleVector(theme.keySize(), theme.keySize());
            Iterable iterable = breaks;
            boolean $i$f$map = false;
            void var10_12 = $this$map$iv;
            Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void br;
                LegendBreak legendBreak = (LegendBreak)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(themeKeySize.max(jetbrains.datalore.plot.builder.assemble.LegendAssembler$Companion.createLegendSpec$pretty(br.getMinimumKeySize())));
            }
            List sizes = (List)((Object)destination$iv$iv);
            boolean bl = false;
            if (legendDirection == LegendDirection.HORIZONTAL) {
                void $this$mapTo$iv$iv2;
                destination$iv$iv = ((Iterable)sizes).iterator();
                if (!destination$iv$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object p0 = (DoubleVector)destination$iv$iv.next();
                boolean bl2 = false;
                double d = p0.getY();
                while (destination$iv$iv.hasNext()) {
                    DoubleVector p02 = (DoubleVector)destination$iv$iv.next();
                    doubleVector = false;
                    double d2 = p02.getY();
                    d = Math.max(d, d2);
                }
                double maxKeyHeight = d;
                Iterable $this$map$iv2 = sizes;
                $i$f$map22 = false;
                p0 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    DoubleVector doubleVector = (DoubleVector)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(new DoubleVector(it.getX(), maxKeyHeight));
                }
                list = (List)destination$iv$iv2;
            } else {
                void $this$mapTo$iv$iv3;
                Iterator $i$f$map22 = ((Iterable)sizes).iterator();
                if (!$i$f$map22.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object p0 = (DoubleVector)$i$f$map22.next();
                boolean bl4 = false;
                double d = p0.getX();
                while ($i$f$map22.hasNext()) {
                    DoubleVector p03 = (DoubleVector)$i$f$map22.next();
                    doubleVector = false;
                    double d3 = p03.getX();
                    d = Math.max(d, d3);
                }
                double maxKeyWidth = d;
                Iterable $this$map$iv3 = sizes;
                $i$f$map22 = false;
                p0 = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it;
                    DoubleVector doubleVector = (DoubleVector)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl5 = false;
                    collection.add(new DoubleVector(maxKeyWidth, it.getY()));
                }
                list = (List)destination$iv$iv3;
            }
            List keySizes = list;
            int breakCount = breaks.size();
            int colCount = 0;
            int rowCount = 0;
            if (options.isByRow()) {
                colCount = options.hasColCount() ? Math.min(options.getColCount(), breakCount) : (options.hasRowCount() ? (int)Math.ceil((double)breakCount / (double)options.getRowCount()) : (legendDirection == LegendDirection.HORIZONTAL ? breakCount : 1));
                rowCount = (int)Math.ceil((double)breakCount / (double)colCount);
            } else {
                rowCount = options.hasRowCount() ? Math.min(options.getRowCount(), breakCount) : (options.hasColCount() ? (int)Math.ceil((double)breakCount / (double)options.getColCount()) : (legendDirection != LegendDirection.HORIZONTAL ? breakCount : 1));
                colCount = (int)Math.ceil((double)breakCount / (double)rowCount);
            }
            LegendComponentLayout layout = null;
            layout = legendDirection == LegendDirection.HORIZONTAL ? (options.hasRowCount() || options.hasColCount() && options.getColCount() < breakCount ? LegendComponentLayout.Companion.horizontalMultiRow(title, breaks, keySizes, theme) : LegendComponentLayout.Companion.horizontal(title, breaks, keySizes, theme)) : LegendComponentLayout.Companion.vertical(title, breaks, keySizes, theme);
            layout.setColCount(colCount);
            layout.setRowCount(rowCount);
            layout.setFillByRow(options.isByRow());
            return new LegendComponentSpec(title, breaks, theme, layout, false);
        }

        public static /* synthetic */ LegendComponentSpec createLegendSpec$default(Companion companion, String string, List list, LegendTheme legendTheme, LegendOptions legendOptions, int n, Object object) {
            if ((n & 8) != 0) {
                legendOptions = new LegendOptions();
            }
            return companion.createLegendSpec(string, list, legendTheme, legendOptions);
        }

        private static final DoubleVector createLegendSpec$pretty(DoubleVector v) {
            double margin = 1.0;
            return new DoubleVector(Math.floor(v.getX() / (double)2) * (double)2 + 1.0 + margin, Math.floor(v.getY() / (double)2) * (double)2 + 1.0 + margin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

