/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.base.scale.breaks.ScaleBreaksUtil;
import jetbrains.datalore.plot.builder.assemble.ColorBarOptions;
import jetbrains.datalore.plot.builder.assemble.LegendAssemblerUtil;
import jetbrains.datalore.plot.builder.guide.ColorBarComponent;
import jetbrains.datalore.plot.builder.guide.ColorBarComponentLayout;
import jetbrains.datalore.plot.builder.guide.ColorBarComponentSpec;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.PlotLabelSpecFactory;
import jetbrains.datalore.plot.builder.layout.PlotLayoutUtil;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0017\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u0015R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/plot/builder/assemble/ColorBarAssembler;", "", "legendTitle", "", "transformedDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "scale", "Ljetbrains/datalore/plot/base/Scale;", "scaleMapper", "Ljetbrains/datalore/plot/base/ScaleMapper;", "Ljetbrains/datalore/base/values/Color;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "(Ljava/lang/String;Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/plot/base/ScaleMapper;Ljetbrains/datalore/plot/builder/theme/LegendTheme;)V", "colorBarOptions", "Ljetbrains/datalore/plot/builder/assemble/ColorBarOptions;", "createColorBar", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "setOptions", "", "options", "setOptions$plot_builder_portable", "Companion", "plot-builder-portable"})
public final class ColorBarAssembler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String legendTitle;
    @NotNull
    private final DoubleSpan transformedDomain;
    @NotNull
    private final Scale scale;
    @NotNull
    private final ScaleMapper<Color> scaleMapper;
    @NotNull
    private final LegendTheme theme;
    @Nullable
    private ColorBarOptions colorBarOptions;
    private static final boolean DEBUG_DRAWING = false;

    public ColorBarAssembler(@NotNull String legendTitle, @NotNull DoubleSpan transformedDomain, @NotNull Scale scale, @NotNull ScaleMapper<Color> scaleMapper2, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)legendTitle, (String)"legendTitle");
        Intrinsics.checkNotNullParameter((Object)transformedDomain, (String)"transformedDomain");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter(scaleMapper2, (String)"scaleMapper");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.legendTitle = legendTitle;
        this.transformedDomain = transformedDomain;
        this.scale = scale;
        this.scaleMapper = scaleMapper2;
        this.theme = theme;
    }

    @NotNull
    public final LegendBoxInfo createColorBar() {
        ScaleBreaks scaleBreaks;
        Scale scale = this.scale;
        if (!scale.hasBreaks()) {
            scale = ScaleBreaksUtil.INSTANCE.withBreaks(scale, this.transformedDomain, 5);
        }
        if ((scaleBreaks = scale.getScaleBreaks()).isEmpty()) {
            return LegendBoxInfo.Companion.getEMPTY();
        }
        ColorBarComponentSpec spec = Companion.createColorBarSpec(this.legendTitle, this.transformedDomain, scaleBreaks, this.scaleMapper, this.theme, this.colorBarOptions);
        DoubleVector doubleVector = spec.getSize();
        return new LegendBoxInfo(spec, doubleVector){
            final /* synthetic */ ColorBarComponentSpec $spec;
            {
                this.$spec = $spec;
                super($super_call_param$1);
            }

            @NotNull
            public LegendBox createLegendBox() {
                ColorBarComponent c = new ColorBarComponent(this.$spec);
                c.setDebug(false);
                return c;
            }
        };
    }

    public final void setOptions$plot_builder_portable(@Nullable ColorBarOptions options) {
        this.colorBarOptions = options;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/assemble/ColorBarAssembler$Companion;", "", "()V", "DEBUG_DRAWING", "", "createColorBarSpec", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentSpec;", "title", "", "transformedDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "scaleMapper", "Ljetbrains/datalore/plot/base/ScaleMapper;", "Ljetbrains/datalore/base/values/Color;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "options", "Ljetbrains/datalore/plot/builder/assemble/ColorBarOptions;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorBarComponentSpec createColorBarSpec(@NotNull String title, @NotNull DoubleSpan transformedDomain, @NotNull ScaleBreaks breaks, @NotNull ScaleMapper<Color> scaleMapper2, @NotNull LegendTheme theme, @Nullable ColorBarOptions options) {
            double d;
            String label;
            double d2;
            String label2;
            Iterator iterator;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)transformedDomain, (String)"transformedDomain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(scaleMapper2, (String)"scaleMapper");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            LegendDirection legendDirection = LegendAssemblerUtil.INSTANCE.legendDirection(theme);
            boolean horizontal = legendDirection == LegendDirection.HORIZONTAL;
            ColorBarOptions colorBarOptions = options;
            Double width = colorBarOptions != null ? colorBarOptions.getWidth() : null;
            ColorBarOptions colorBarOptions2 = options;
            Double height = colorBarOptions2 != null ? colorBarOptions2.getHeight() : null;
            DoubleVector barSize = ColorBarComponentSpec.Companion.barAbsoluteSize$plot_builder_portable(horizontal, theme);
            if (width != null) {
                barSize = new DoubleVector(width.doubleValue(), barSize.getY());
            } else if (horizontal) {
                iterator = ((Iterable)breaks.getLabels()).iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                label2 = (String)iterator.next();
                boolean bl = false;
                d2 = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder_portable(label2, PlotLabelSpecFactory.INSTANCE.legendItem(theme)).getX();
                while (iterator.hasNext()) {
                    label = (String)iterator.next();
                    $i$a$-maxOf-ColorBarAssembler$Companion$createColorBarSpec$labelMaxWidth$1 = false;
                    d = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder_portable(label, PlotLabelSpecFactory.INSTANCE.legendItem(theme)).getX();
                    d2 = Math.max(d2, d);
                }
                double labelMaxWidth = d2;
                barSize = new DoubleVector(Math.max(barSize.getX(), labelMaxWidth * (double)(breaks.getSize() + 1)), barSize.getY());
            }
            if (height != null) {
                barSize = new DoubleVector(barSize.getX(), height.doubleValue());
            } else if (!horizontal) {
                iterator = ((Iterable)breaks.getLabels()).iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                label2 = (String)iterator.next();
                boolean bl = false;
                d2 = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder_portable(label2, PlotLabelSpecFactory.INSTANCE.legendItem(theme)).getY();
                while (iterator.hasNext()) {
                    label = (String)iterator.next();
                    $i$a$-maxOf-ColorBarAssembler$Companion$createColorBarSpec$labelMaxHeight$1 = false;
                    d = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder_portable(label, PlotLabelSpecFactory.INSTANCE.legendItem(theme)).getY();
                    d2 = Math.max(d2, d);
                }
                double labelMaxHeight = d2;
                barSize = new DoubleVector(barSize.getX(), Math.max(barSize.getY(), labelMaxHeight * (double)(breaks.getSize() + 1)));
            }
            boolean reverse = !horizontal;
            ColorBarComponentLayout layout = horizontal ? ColorBarComponentLayout.Companion.horizontal(title, transformedDomain, breaks, barSize, reverse, theme) : ColorBarComponentLayout.Companion.vertical(title, transformedDomain, breaks, barSize, reverse, theme);
            Object object = options;
            return new ColorBarComponentSpec(title, transformedDomain, breaks, scaleMapper2, object != null && (object = ((ColorBarOptions)object).getBinCount()) != null ? (Integer)object : 20, theme, layout, reverse);
        }

        public static /* synthetic */ ColorBarComponentSpec createColorBarSpec$default(Companion companion, String string, DoubleSpan doubleSpan, ScaleBreaks scaleBreaks, ScaleMapper scaleMapper2, LegendTheme legendTheme, ColorBarOptions colorBarOptions, int n, Object object) {
            if ((n & 0x20) != 0) {
                colorBarOptions = null;
            }
            return companion.createColorBarSpec(string, doubleSpan, scaleBreaks, (ScaleMapper<Color>)scaleMapper2, legendTheme, colorBarOptions);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

